// 3DMapping.h: interface for the C3DMapping class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_3DMAPPING_H__800E0C39_67D0_11D3_ADEA_006008B0E0C3__INCLUDED_)
#define AFX_3DMAPPING_H__800E0C39_67D0_11D3_ADEA_006008B0E0C3__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "AreaMap.h"
#include "Texan_Model.h"

enum
{
   STUDENT,
   TOWER,
   CHASE_PLANE
};

class C3DMapping : public CAreaMap  
{
public:
	C3DMapping();
	virtual ~C3DMapping();
   static CWidget* CreateObject();

   virtual  void  ChangeValue(const CString& rstrElementVar, CChangeValue* pCV);
   virtual  bool  UpdateRenderVariables();

   virtual  void  BeginDrawing(void);
   virtual  void  DrawSymbols(void);
   virtual  void  DrawLeadAircraft(void);
   virtual  void  DrawWingAircraft(void);
   virtual  void  DrawLeadTrack(void);
   virtual  void  DrawWingTrack(void);
   virtual  void  SetupPerspective(void);
   virtual  void  MoveViewingPosition(void);
   virtual  void  DrawEarth(void);
   virtual  void  EndDrawing(void);

private:
   Texan_Model leadModel;
   Texan_Model wingModel;

   double      m_3d_scale;
   double      m_3d_scale_cv;
   COpenGLtext m_Scale;
   CString     m_CStr_scale;

   float       m_tilt_angle;
   
   float       m_spin_angle;
   float       m_spin_angle_cv;
   COpenGLtext m_SpinAngle;
   CString     m_CStr_spin_angle;

   float       m_camera_altitude;
   COpenGLtext m_CameraAltitude;
   CString     m_CStr_camera_altitude;

   float       m_camera_angle;
   float       m_camera_angle_cv;
   COpenGLtext m_CameraAngle;
   CString     m_CStr_camera_angle;

   float       m_ac_pitch_lead;
   float       m_ac_pitch_lead_cv;
   float       m_ac_roll_lead;
   float       m_ac_roll_lead_cv;

   float       m_ac_pitch_wing;
   float       m_ac_pitch_wing_cv;
   float       m_ac_roll_wing;
   float       m_ac_roll_wing_cv;

   float       m_height_of_terrain;
   float       m_height_of_terrain_cv;

   long        m_3d_map_spider_web_cv;

   bool        m_3d_map_scale_aircraft;
   bool        m_3d_map_scale_aircraft_cv;

   bool        m_bool_nose_gear_down;
   bool        m_bool_nose_gear_down_cv;

   bool        m_bool_left_gear_down;
   bool        m_bool_left_gear_down_cv;

   bool        m_bool_right_gear_down;
   bool        m_bool_right_gear_down_cv;

   double      m_active_airport_latitude;
   double      m_active_airport_longitude;

   float       m_field_of_view;
   float       m_field_of_view_cv;
   float       m_z_offset;

   float       m_zoom_ratio;

   long        m_long_camera_position;
   long        m_long_camera_position_cv;

   GLUquadricObj  *m_pquad;

   COpenGLtext m_DeltaAltitude;
   CString     m_CStr_delta_altitude;

// Attributes
public:
  	enum { IDB = IDB_3D_MAPPING  };
};

#endif // !defined(AFX_3DMAPPING_H__800E0C39_67D0_11D3_ADEA_006008B0E0C3__INCLUDED_)
