// TimeInfo.cpp: implementation of the CTimeInfo class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "TimeInfo.h"
#include "PurgeDebrief.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CTimeInfo::CTimeInfo()
{
   m_ulTicksToKeep = 0;
   m_ulTodayTicks  = 0;
}

CTimeInfo::~CTimeInfo()
{
}


bool CTimeInfo::Initialize(int nHoursToKeep, bool bExcludeWeekends)
{
   enum {SUNDAY=0, MONDAY, TUESDAY, WEDNESDAY, THURSDAY, FRIDAY, SATURDAY};  

   SYSTEMTIME todaySystemTime;
   FILETIME   todayFileTime;

   GetLocalTime(&todaySystemTime);
   SystemTimeToFileTime(&todaySystemTime, &todayFileTime);

   memcpy(&m_ulTodayTicks, &todayFileTime, sizeof m_ulTodayTicks);

   int nTotalHoursToKeep = nHoursToKeep;

   if (bExcludeWeekends)
   {
      if ((todaySystemTime.wDayOfWeek == SATURDAY) || (todaySystemTime.wDayOfWeek == SUNDAY))
      {
         //cout << "Won\'t delete files on a weekend.\n";
         return false;
      }
 
      if (todaySystemTime.wDayOfWeek == MONDAY)
         nTotalHoursToKeep += 48;
   }

   // 1 "tick" is 100 nanoseconds
   UINT64 ticksPerHour = 3600 * (UINT64)10000000;
   m_ulTicksToKeep = nTotalHoursToKeep * ticksPerHour;

   return true;
}
