// PurgeDebrief.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"
#include "PurgeDebrief.h"
#include "DeleteSettings.h"
#include "TimeInfo.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// The one and only application object

CWinApp theApp;
CDeleteSettings theSettings;
CTimeInfo theTimeInfo;

void DeleteFiles(CString); //forward

using namespace std;
 
int _tmain(int argc, TCHAR* argv[], TCHAR* envp[])
{
	// initialize MFC and print and error on failure
	if (!AfxWinInit(::GetModuleHandle(NULL), NULL, ::GetCommandLine(), 0))
	{
		cerr << _T("Fatal Error: MFC initialization failed") << endl;
      return 1;
	}


   if (theSettings.GetSettings() == false)
   {
      cerr << "Error:  .INI file not found or path not configured.\n";
      return 1;
   }

   if (theTimeInfo.Initialize(theSettings.m_nHoursToKeep, theSettings.m_bExcludeWeekends) == false)
   {
      cerr << "Will not purge wireframes on a weekend.\n";
      return 0;
   }


   cout << "Purging wireframe files...\n";

   DeleteFiles(theSettings.m_strDirectory);

   cout << "Purge complete\n";

	return 0;
}



// recursive routine
void DeleteFiles(CString directory)
{
   static int nExtLength  = theSettings.m_strExtension.GetLength();
   static int nExt2Length = theSettings.m_strExtension2.GetLength();

   static bool bFirstPass = true;
   bool bFirstDirectory = false;

   WIN32_FIND_DATA findData;
   HANDLE hFind;
   
   if (bFirstPass)
   {
      // this will keep the root dir from being deleted in the end
      bFirstDirectory = true;
      bFirstPass  = false;
   }

   CString path = directory + "\\*";

   hFind = FindFirstFile(path, &findData);

   if (hFind == INVALID_HANDLE_VALUE)
      return;

   do {
      if (strcmp(findData.cFileName,".") && strcmp(findData.cFileName,".."))
      {
         //cout << (LPCTSTR)directory << "\\" << findData.cFileName;

         if ((((CString)findData.cFileName).Right(nExtLength) == theSettings.m_strExtension) ||
             (((CString)findData.cFileName).Right(nExt2Length)== theSettings.m_strExtension2) )
         {
            //cout << "   FOUND ONE";
            UINT64 fileTimeTicks;
            UINT64 timeDiff;
            FILETIME localFileTime;
            FileTimeToLocalFileTime((const FILETIME *)&(findData.ftLastWriteTime), &localFileTime);
            memcpy(&fileTimeTicks, &localFileTime, sizeof fileTimeTicks);
            timeDiff = theTimeInfo.m_ulTodayTicks - fileTimeTicks;
            if (timeDiff > theTimeInfo.m_ulTicksToKeep)
            {
               cout << " Deleting file: " << (LPCTSTR)(directory + "\\" + (CString)findData.cFileName) << endl;
               DeleteFile((LPCTSTR)(directory + "\\" + (CString)findData.cFileName));
            }

         }

         //cout << endl;

         if ((findData.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY) && theSettings.m_bRecurseFolders)
            DeleteFiles(directory + "\\" + findData.cFileName);
        
      }
      
   } while (FindNextFile(hFind, &findData) != FALSE);


   FindClose(hFind);

   // this will try to delete all directories, but will only succed on empty ones
   if (theSettings.m_bDeleteEmptyFolders && !bFirstDirectory)
      RemoveDirectory(directory);
}