// DeleteSettings.cpp: implementation of the CDeleteSettings class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "PurgeDebrief.h"
#include "DeleteSettings.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif


static const char strIniAppName[]       = "Purge Debrief";
static const char strIniFilename[]      = ".\\PurgeDebrief.ini";
static const char strDefaultExtension[] = ".dat";
static const char strDefaultExtension2[]= ".idx";

CDeleteSettings::CDeleteSettings()
{
   // note: defaults are defined by the GetPrivateProfile() calls, not here
   m_bRecurseFolders     = false;
   m_bDeleteEmptyFolders = false;
   m_bExcludeWeekends    = false;
   m_strDirectory        = "";
   m_strExtension        = "";
   m_strExtension2       = "";
   m_nHoursToKeep        = 0;
}

CDeleteSettings::~CDeleteSettings()
{

}

bool CDeleteSettings::GetSettings()
{
   // gets the .ini file settings.  returns true if okay.

   char  tempStr[MAX_PATH];
   DWORD tempNum;

   GetPrivateProfileString(strIniAppName, "Debrief Directory", "", tempStr,  sizeof tempStr, strIniFilename);
   m_strDirectory = tempStr;

   if (m_strDirectory == "")
      return false;

   GetPrivateProfileString(strIniAppName, "File Extension", strDefaultExtension, tempStr, sizeof tempStr, strIniFilename);
   if (tempStr[0] != '.')
      m_strExtension = '.' + tempStr;
   else
      m_strExtension = tempStr;

   GetPrivateProfileString(strIniAppName, "File Extension2", strDefaultExtension2, tempStr, sizeof tempStr, strIniFilename);
   if (tempStr[0] != '.')
      m_strExtension2 = '.' + tempStr;
   else
      m_strExtension2 = tempStr;

   tempNum = GetPrivateProfileInt(strIniAppName, "Recurse Folders", 0, strIniFilename);
   m_bRecurseFolders = (tempNum != 0);

   tempNum = GetPrivateProfileInt(strIniAppName, "Delete Empty Folders", 0, strIniFilename);
   m_bDeleteEmptyFolders = (tempNum != 0);

   tempNum = GetPrivateProfileInt(strIniAppName, "Hours To Keep", 24, strIniFilename);
   m_nHoursToKeep = tempNum;

   tempNum = GetPrivateProfileInt(strIniAppName, "Exclude Weekends", 0, strIniFilename);
   m_bExcludeWeekends = (tempNum != 0);

   return true;

}
