#include "..\core\stdafx.h"
#include "PageEditorComponentInterface.h"
#include "..\fsisuite\product_version.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

// The following static members contain the date and time of the last
// compilation of this class.
const char CPageEditorComponentInterface::m_cRevisionDate[] = __DATE__;
const char CPageEditorComponentInterface::m_cRevisionTime[] = __TIME__;

/////////////////////////////////////////////////////////////////////////////
//
// CPageEditorComponentInterface::CPageEditorComponentInterface()
//
// Inputs           : None.
//
// Return Values    : None.
//
// Date             : 26 October 1998
//
// Engineer         : Billy Baker
//
// Description      : This is the default constuctor for this class.  It 
//                    initializes the map of option pages, initializes 
//                    the string with the date and time of compilation, 
//                    and initializes the name of the component.
//
/////////////////////////////////////////////////////////////////////////////
CPageEditorComponentInterface::CPageEditorComponentInterface(
                                                  _FSI_STL::string stlStrPathName) :
                    CComponentInterface(_FSI_STL::string("Page File Editor"),
                                        stlStrPathName)
{
    _FSI_STL::string stlStrDate(m_cRevisionDate);
    _FSI_STL::string stlStrTime(m_cRevisionTime);

    m_stlStrDate = stlStrDate + " " + stlStrTime;

}

/////////////////////////////////////////////////////////////////////////////
//
// CPageEditorComponentInterface::~CPageEditorComponentInterface()
//
// Inputs           : None.
//
// Return Values    : None.
//
// Date             : 26 October 1998
//
// Engineer         : Billy Baker
//
// Description      : This is the default destructor for this class.  It 
//                    does not need to delete the option pages since 
//                    they are attached to a window when they are 
//                    created and will be deleted when that window is 
//                    destroyed.  The pointers in the map, though, are 
//                    freed with a call to the map clear() method in the
//                    base class destructor.
//
/////////////////////////////////////////////////////////////////////////////
CPageEditorComponentInterface::~CPageEditorComponentInterface()
{
}


/////////////////////////////////////////////////////////////////////////////
//
// bool CPageEditorComponentInterface::EditPageMode()
//
// Inputs           : None.
//
// Return Values    : true - if the view should be a page edit view
//                    false - runtime view (default)
//
// Date             : 26 October 1998
//
// Engineer         : Billy Baker
//
// Description      : EditPageMode return a boolean that specifies 
//                    whether the view in the main application should 
//                    be a runtime view or an edit view.  CComponentInterface
//                    implements EditPageMode to return false.
//
/////////////////////////////////////////////////////////////////////////////
bool CPageEditorComponentInterface::EditPageMode()
{
    return true;
}
