// MalfunctionSystemInterface.h: interface for the CMalfunctionSystemInterface class.
//
//////////////////////////////////////////////////////////////////////
#if !defined(_MALFUNCTIONSYSTEMINTERFACE_H_)
#define _MALFUNCTIONSYSTEMINTERFACE_H_

#include "..\core\widget.h"

#ifdef MALFUNCTION
#define MALFUNCTIONAPI __declspec( dllexport )
#else
#define MALFUNCTIONAPI __declspec( dllimport )
#endif


#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

class CMalfunctionData;
class CMalfCommsAction;

struct Malf_Preselect_Data
{
    double                  s_dValue1;
    double                  s_dValue2;

    long                    s_lAndResults;

    long                    s_lConditional1;
    long                    s_lConditional2;

    _FSI_STL::string        s_stlStrMalfTitle;

    _FSI_STL::string        s_stlStrTrigger1;
    _FSI_STL::string        s_stlStrTrigger2;

};

class MALFUNCTIONAPI CMalfunctionSystemInterface  
{
protected:
    long                                        m_lSectionCount;

    _FSI_STL::map<HWND, long>                   m_mapSectionStarts;
    _FSI_STL::map<HWND, long>                   m_mapMalfStarts;
    _FSI_STL::map<HWND, long>                   m_mapMalfCounts;

    _FSI_STL::map<HWND, _FSI_STL::string>       m_mapCurrentMalfunction;
    _FSI_STL::map<HWND, _FSI_STL::string>       m_mapCurrentSet;
    _FSI_STL::map<HWND, _FSI_STL::string>       m_mapLastSelectedSet;

    _FSI_STL::string                            m_stlStrCurrentDB;

    _FSI_STL::list<_FSI_STL::string>            m_listDatabaseNames;

    CXMLWidget                                  m_xmlCommsSampleWidget;

    static _FSI_STL::map<_FSI_STL::string, struct Malf_Preselect_Data> m_mapPreselectConditionals;

    static CCriticalSection                     m_syncPreselect;

    static UINT InvalidPreselectThread(LPVOID param);

public:
	CMalfunctionSystemInterface();
	virtual ~CMalfunctionSystemInterface();

    void AddDBName(const _FSI_STL::string& rstlStrDatabaseName);
    void LoadData(const _FSI_STL::string& rstlStrDataFile);
    void Clean();

    bool AddPreselect(const _FSI_STL::string& rstlStrTrigger1,
                        const long lConditional1,
                        const double& rdValue1,
                        const _FSI_STL::string& rstlStrTrigger2,
                        const long lConditional2,
                        const double& rdValue2,
                        const _FSI_STL::string& rstlStrMalfunction,
                        const long lAndResults);

    // Accessors
    _FSI_STL::string CurrentMalfunction(const HWND hWnd);
    _FSI_STL::string CurrentSet(const HWND hWnd);
    _FSI_STL::string LastSelectedSet(const HWND hWnd);
    _FSI_STL::string CurrentDB();
    long             SectionStart(const HWND hWnd);
    long             SectionCount();
    long             MalfStart(const HWND hWnd);
    long             MalfCount(const HWND hWnd);

    // Mutators
    void CurrentMalfunction(const HWND hWnd, const _FSI_STL::string& rstlStrCurrentMalfunction);
    void CurrentSet(const HWND hWnd, const _FSI_STL::string& rstlStrCurrentSet);
    void CurrentDB(const _FSI_STL::string& rstlStrCurrentDB);
    void SectionStart(const HWND hWnd, long lSectionStart);
    void MalfStart(const HWND hWnd, long lMalfStart);
    void MalfCount(const HWND hWnd, long lMalfCount);

    void CurrentMalfunctionState(const _FSI_STL::string& rstlStrCurrentMalfunction, bool bState);
    void ChangeMalfState(HWND hWnd);
    void ChangePreselectState(HWND hWnd);
    void ClearAll();
    void ClearAllPreselects();

    static void UpdatePreselects();

    static bool LabelHasPreselect(const _FSI_STL::string& rstlStrLabel);

    _FSI_STL::map<_FSI_STL::string,  void*>     m_mapMalfFields;
    _FSI_STL::map<_FSI_STL::string,  _FSI_STL::map<_FSI_STL::string, CMalfunctionData*> >     m_mapMalfData;

    _FSI_STL::map<HWND, _FSI_STL::list<CAction*> >      m_mapDataActions;
    _FSI_STL::map<HWND, _FSI_STL::list<CAction*> >      m_mapFieldActions;
    _FSI_STL::map<HWND, _FSI_STL::list<CAction*> >      m_mapSectionActions;

    static _FSI_STL::map<_FSI_STL::string, CMalfCommsAction*>  m_mapCommsActions;
    static _FSI_STL::map<_FSI_STL::string, CXMLWidget>         m_mapCommsXMLWidgets;
    _FSI_STL::map<_FSI_STL::string, _FSI_STL::string>   m_mapPreselectTriggers;
    _FSI_STL::map<long, _FSI_STL::list<_FSI_STL::string> > m_mapTriggerEntries;
};

#endif // !defined(_MALFUNCTIONSYSTEMINTERFACE_H_)

