// MalfunctionSystemInterface.cpp: implementation of the CMalfunctionSystemInterface class.
//
//////////////////////////////////////////////////////////////////////
#include "..\core\stdafx.h"
#pragma warning(disable:4503) 

#include "MalfCommsAction.h"
#include "MalfunctionData.h"
#include "MalfunctionSystemInterface.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//#import "c:\program files\common files\system\ado\msado15.dll" \
//        no_namespace \
//        rename("EOF", "adoEOF")

#import <msado15.dll> \
        no_namespace \
        rename("EOF", "adoEOF")

_FSI_STL::map<_FSI_STL::string, struct Malf_Preselect_Data> CMalfunctionSystemInterface::m_mapPreselectConditionals;
_FSI_STL::map<_FSI_STL::string, CMalfCommsAction*>          CMalfunctionSystemInterface::m_mapCommsActions;
_FSI_STL::map<_FSI_STL::string, CXMLWidget>                 CMalfunctionSystemInterface::m_mapCommsXMLWidgets;
CCriticalSection                     CMalfunctionSystemInterface::m_syncPreselect;
//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CMalfunctionSystemInterface::CMalfunctionSystemInterface()
{
    m_stlStrCurrentDB           = _FSI_STL::string("");
    m_lSectionCount             = 0;
}

CMalfunctionSystemInterface::~CMalfunctionSystemInterface()
{
    Clean();
}

void CMalfunctionSystemInterface::AddDBName(const _FSI_STL::string& rstlStrDatabaseName)
{
    m_listDatabaseNames.push_back(rstlStrDatabaseName);
}

void CMalfunctionSystemInterface::Clean()
{
    m_mapTriggerEntries.clear();
    m_mapPreselectTriggers.clear();
    m_mapPreselectConditionals.clear();

    _FSI_STL::map<_FSI_STL::string,  _FSI_STL::map<_FSI_STL::string, CMalfunctionData*> >::iterator msIt = NULL;
    _FSI_STL::map<_FSI_STL::string,  _FSI_STL::map<_FSI_STL::string, CMalfunctionData*> >::iterator msEndIt = NULL;
    msIt    = m_mapMalfData.begin();
    msEndIt = m_mapMalfData.end();

    _FSI_STL::map<_FSI_STL::string, CMalfunctionData*>::iterator mIt    = NULL;
    _FSI_STL::map<_FSI_STL::string, CMalfunctionData*>::iterator mendIt = NULL;

    while (msIt != msEndIt)
    {
        mIt     = (*msIt).second.begin();
        mendIt  = (*msIt).second.end();

        while (mIt != mendIt)
        {
            delete (*mIt).second;
            ++mIt;
        }

        (*msIt).second.clear();

        ++msIt;
    }

    // Delete any comms actions that were created.
    _FSI_STL::map<_FSI_STL::string, CMalfCommsAction*>::iterator mcaIt     = NULL;
    _FSI_STL::map<_FSI_STL::string, CMalfCommsAction*>::iterator mcaendIt  = NULL;
    mcaIt       = m_mapCommsActions.begin();
    mcaendIt    = m_mapCommsActions.end();
    CWidget* pWidget = NULL;
    while (mcaIt != mcaendIt)
    {
        pWidget = dynamic_cast<CWidget*>((*mcaIt).second);
        if (pWidget != NULL)
        {
            if (CWidget::IsValidAddress(pWidget) != INVALID)
            {
                pWidget->Deleting(true);
            }
        }

        ++mcaIt;
    }
}

void CMalfunctionSystemInterface::LoadData(const _FSI_STL::string& rstlStrDataFile)
{
    Clean();

    HKEY hKey;
    RegOpenKeyEx(HKEY_LOCAL_MACHINE, _T("Software\\FlightSafety\\FSISuite\\Malfunctions"), 0, KEY_READ, &hKey);
    if (hKey != NULL)
    {
        long int lMalfPreselectCount = 0;
        long int lMalfPreselectStep = 1;
        unsigned long int ulData = 0;
        DWORD dwSize = sizeof (unsigned long int);
        RegQueryValueEx(hKey, _T("MalfPreselectCount"), NULL, NULL, (BYTE*)&ulData, 
                        &dwSize);
        lMalfPreselectCount = ulData;

        CString strMalfPreselectXXX;
        CString strMalfPreselectName;
        CString strMalfPreselectHostVar;

        while(lMalfPreselectStep <= lMalfPreselectCount)
        {
            strMalfPreselectXXX.Format("MalfPreselect%d",lMalfPreselectStep);

            // Get the name of the MalfPreselect.
		    CString strValue;
		    DWORD dwType, dwCount;
		    LONG lResult = RegQueryValueEx(hKey, (LPCTSTR)strMalfPreselectXXX, 
                                           NULL, &dwType, NULL, &dwCount);
		    if (lResult == ERROR_SUCCESS)
		    {
			    ASSERT(dwType == REG_SZ);
			    lResult = RegQueryValueEx(hKey, (LPCTSTR)strMalfPreselectXXX, 
                                          NULL, &dwType,
				             (LPBYTE)strValue.GetBuffer(dwCount/sizeof(TCHAR)),
                                          &dwCount);

			    strValue.ReleaseBuffer();
		    }

            strMalfPreselectName = strValue;

            // Get the RGB for the MalfPreselect
            if (strMalfPreselectName != "")
            {
                // Code copied from GetProfileString() in CWinApp 
                // implementation.
		        lResult = RegQueryValueEx(hKey, (LPCTSTR)strMalfPreselectName, 
                                               NULL, &dwType, NULL, &dwCount);
		        if (lResult == ERROR_SUCCESS)
		        {
			        ASSERT(dwType == REG_SZ);
			        lResult = RegQueryValueEx(hKey, (LPCTSTR)strMalfPreselectName, 
                                              NULL, &dwType,
				             (LPBYTE)strValue.GetBuffer(dwCount/sizeof(TCHAR)),
                                              &dwCount);

			        strValue.ReleaseBuffer();
		        }

                strMalfPreselectHostVar = strValue;

                m_mapPreselectTriggers[(LPCTSTR)strMalfPreselectName] = 
                                        _FSI_STL::string((LPCTSTR)strMalfPreselectHostVar);
                m_mapTriggerEntries[lMalfPreselectStep].push_back((LPCTSTR)strMalfPreselectName);
            }

            ++lMalfPreselectStep;
        }

        RegCloseKey(hKey);
    }

    long int lFields = 0;

    _ConnectionPtr      pConnection;
    HRESULT resConn = pConnection.CreateInstance(__uuidof(Connection));

    if (!SUCCEEDED(resConn))
    {
        return;
    }

    _RecordsetPtr       pRecordset;
    HRESULT resRecord = pRecordset.CreateInstance(__uuidof(Recordset));
    
    if (!SUCCEEDED(resRecord))
    {
        pConnection.Release();
        return;
    }

    CString strConnect;
    strConnect.Format("Provider=Microsoft.Jet.OLEDB.4.0; Data Source=%s",
                      rstlStrDataFile.c_str());

    bool bConnected     = false;
    bool bHaveRecordset = false;
    try
    {
        HRESULT resCOpen = pConnection->Open((LPCTSTR)strConnect, "", "", -1);

        if (SUCCEEDED(resCOpen)) 
        {
            bConnected = true;
        }
    }
    catch (_com_error& e)
    {
        AfxMessageBox(CString(rstlStrDataFile.c_str()) + " could not be opened.\nReason: " + CString((char*)e.Description()));
    }

    if (bConnected)
    {
        try
        {
            HRESULT resROpen = pRecordset->Open("tblMalfDesc", pConnection.GetInterfacePtr(),
                                                adOpenForwardOnly,
                                                adLockReadOnly,
                                                adCmdTable);

            if (SUCCEEDED(resROpen))
            {
                bHaveRecordset = true;
            }
        }
        catch (_com_error& e)
        {
           CString strError = (LPCSTR)(e.Description());
           AfxMessageBox("A recordset could not be created for table tblMalfDesc." + strError);
        }
    }

    if (bHaveRecordset)
    {
        // Get the field names.
        FieldsPtr pFields   = pRecordset->GetFields();
        long lFieldCount    = pFields->GetCount();
        while (lFields < lFieldCount)
        {
            _FSI_STL::string stlStrMalfData((LPCTSTR)_bstr_t(pFields->GetItem(lFields)->GetName()));

            if (m_mapMalfFields.find(stlStrMalfData) != m_mapMalfFields.end())
            {
                delete (*(m_mapMalfFields.find(stlStrMalfData))).second;
            }

            m_mapMalfFields[stlStrMalfData] = NULL;

            ++lFields;
        }
    }

    if (bHaveRecordset)
    {
        pRecordset->Close();
    }

    if (bConnected)
    {
        try
        {
            // Query for malfunction sections and the number of malfunctions
            // in the section.
            CString strSQL  = "SELECT tblMalfDesc.mfPgTitle, "
                              "tblMalfDesc.mfTitle, tblMalfDesc.mfLabel, "
                              "tblMalfDesc.mfCause, tblMalfDesc.mfEffects "
                              "FROM tblMalfDesc WHERE tblMalfDesc.mfTitle "
                              "<> 'SPARE'";
//            CString strSQL = "SELECT DISTINCTROW tblMalfSection.mfPgTitle, "
//                             "(SELECT COUNT(*) FROM tblMalfDesc WHERE "
//                             "tblMalfDesc.mfTitle <> 'SPARE' AND "
//                             "tblMalfDesc.mfPgTitle = tblMalfSection.mfPgTitle) "
//                             "AS SetCount FROM tblMalfDesc, tblMalfSection "
//                             "ORDER BY tblMalfSection.mfPgTitle";

            HRESULT resROpen = pRecordset->Open((LPCTSTR)strSQL, 
                                                pConnection.GetInterfacePtr(),
                                                adOpenForwardOnly,
                                                adLockReadOnly,
                                                adCmdText);

            if (SUCCEEDED(resROpen))
            {
                bHaveRecordset = true;
            }
        }
        catch (_com_error& e)
        {
           CString strError = (LPCSTR)(e.Description());
           AfxMessageBox("A recordset could not be created for table tblMalfDesc. " + strError);
        }
    }

    if (bHaveRecordset)
    {
        // Add the names of the sections with more than one malunction
        // to a map of section name to number of malfunctions.
        FieldsPtr           pFields   = pRecordset->GetFields();
        CMalfunctionData*   pMalfData = NULL;
        while (pRecordset->adoEOF == VARIANT_FALSE)
        {
            _FSI_STL::string stlStrSectionTitle((LPCTSTR)_bstr_t(pFields->GetItem((long)0)->GetValue()));
            _FSI_STL::string stlStrMalfTitle((LPCTSTR)_bstr_t(pFields->GetItem((long)1)->GetValue()));

            if ((m_mapMalfData[stlStrSectionTitle]).find(stlStrMalfTitle) !=
                (m_mapMalfData[stlStrSectionTitle]).end())
            {
                delete (m_mapMalfData[stlStrSectionTitle])[stlStrMalfTitle];
            }

            pMalfData = new CMalfunctionData;
            (m_mapMalfData[stlStrSectionTitle])[stlStrMalfTitle] = pMalfData;
            if (pMalfData != NULL)
            {
                _FSI_STL::string stlStrName1((LPCTSTR)_bstr_t(pFields->GetItem((long)2)->GetName()));
                _FSI_STL::string stlStrName2((LPCTSTR)_bstr_t(pFields->GetItem((long)3)->GetName()));
                _FSI_STL::string stlStrName3((LPCTSTR)_bstr_t(pFields->GetItem((long)4)->GetName()));

                _FSI_STL::string stlStrLabel((LPCTSTR)_bstr_t(pFields->GetItem((long)2)->GetValue()));
                _FSI_STL::string stlStrCause((LPCTSTR)_bstr_t(pFields->GetItem((long)3)->GetValue()));
                _FSI_STL::string stlStrEffects((LPCTSTR)_bstr_t(pFields->GetItem((long)4)->GetValue()));
                pMalfData->SetData(stlStrName1, stlStrLabel);
                pMalfData->SetData(stlStrName2, stlStrCause);
                pMalfData->SetData(stlStrName3, stlStrEffects);

                if (m_mapCommsActions.find(stlStrLabel) == m_mapCommsActions.end())
                {
                    CMalfCommsAction* pMCA          = new CMalfCommsAction;
                    m_mapCommsActions[stlStrLabel]  = pMCA;
                    if (pMCA != NULL)
                    {
                        CXMLWidget* pXMLWidget = NULL;
                        pMCA->Initialize(pXMLWidget, NULL, 1, false);
                        if (pXMLWidget != NULL)
                        {
                            m_mapCommsXMLWidgets[stlStrLabel] = *pXMLWidget;

                            delete pXMLWidget;

                            // Set the read mode to always and the write mode to never.
                            CXMLElement* pXMLElement = NULL;
                            POSITION pos = NULL;
                            if (m_mapCommsXMLWidgets[stlStrLabel].FindElement(pXMLElement, pos, _FSI_STL::string("VARIABLE")) == true)
                            {
                                pXMLElement->AddElementValue(stlStrLabel);

                                STRING2STRING_MAP::iterator s2sIt;
                                CString strValue;
                                if (pXMLElement->FindAttribute(s2sIt,_FSI_STL::string("READ_MODE")) == true)
                                {
                                    CString strValue;
                                    strValue.Format("%d",READ_CHANGED);
                                    (*s2sIt).second = _FSI_STL::string((LPCTSTR)strValue);
                                }

                                if (pXMLElement->FindAttribute(s2sIt,_FSI_STL::string("WRITE_MODE")) == true)
                                {
                                    (*s2sIt).second = _FSI_STL::string("YES");
                                }

                                if (pXMLElement->FindAttribute(s2sIt,_FSI_STL::string("ELEMENT_VAR")) == true)
                                {
                                    (*s2sIt).second = _FSI_STL::string("Default");
                                }
                            }

                            pXMLElement = NULL;
                            if (m_mapCommsXMLWidgets[stlStrLabel].FindElement(pXMLElement, pos, _FSI_STL::string("RANGE_DATA")) == true)
                            {
                                pXMLElement->AddElementValue(_FSI_STL::string("GENERIC"));
                            }


                            CXMLWidget* pXMLWidget = &(m_mapCommsXMLWidgets[stlStrLabel]);

                            pMCA->MalfTitle(stlStrMalfTitle);
                            pMCA->AddVariable(stlStrLabel);
                            pMCA->Initialize(pXMLWidget, NULL, 1, false);
                        }
                    }
                }
            }

            pRecordset->MoveNext();
        }

        m_lSectionCount = m_mapMalfData.size();
    }

    if (bHaveRecordset)
    {
        pRecordset->Close();
    }

    if (bConnected)
    {
        pConnection->Close();
    }

    pRecordset.Release();
    pConnection.Release();
}

void CMalfunctionSystemInterface::ChangeMalfState(HWND hWnd)
{
    _FSI_STL::string stlStrLastMalf = CurrentMalfunction(hWnd);
    _FSI_STL::string stlStrLastSet  = LastSelectedSet(hWnd);

    if (m_mapMalfData.find(stlStrLastSet) != m_mapMalfData.end())
    {
        if (m_mapMalfData[stlStrLastSet].find(stlStrLastMalf) != m_mapMalfData[stlStrLastSet].end())
        {
            CMalfunctionData* pMalfData = (m_mapMalfData[stlStrLastSet])[stlStrLastMalf];
            if (pMalfData != NULL)
            {
                _FSI_STL::string stlStrLabel = pMalfData->GetData(_FSI_STL::string("mfLabel"));
                if (m_mapCommsActions.find(stlStrLabel) != m_mapCommsActions.end())
                {
                    m_mapCommsActions[stlStrLabel]->OnLButtonUp();
                }

                if (m_mapPreselectConditionals.find(stlStrLabel) != m_mapPreselectConditionals.end())
                {
                    // Change the text for the malfunction from disarm
                    // to arm.
                    CVariant var;
                    _FSI_STL::string stlStrStateMsg("Arm Preselect");
                    var.Value(stlStrStateMsg);

                    CCommsShared::SetLocalValue(var, 
                                    _FSI_STL::string("Last_Selected_Preselect_State"), 
                                    -1, 
                                    (long)hWnd);

                    // Remove the preselect
                    m_syncPreselect.Lock();

                    m_mapPreselectConditionals.erase(m_mapPreselectConditionals.find(stlStrLabel));

                    m_syncPreselect.Unlock();
                }
            }
        }
    }
}

void CMalfunctionSystemInterface::ClearAll()
{
    _FSI_STL::map<_FSI_STL::string, CMalfCommsAction*>::iterator mIt    = m_mapCommsActions.begin();
    _FSI_STL::map<_FSI_STL::string, CMalfCommsAction*>::iterator mendIt = m_mapCommsActions.end();

    while (mIt != mendIt)
    {
        (*mIt).second->ClearMalf();

        ++mIt;
    }
}

UINT CMalfunctionSystemInterface::InvalidPreselectThread(LPVOID param)
{
    ::MessageBox(NULL, 
                 _T("The data entered for the preselect was determined to invalid."), 
                 _T("Invalid Preselect Data"), 
                 MB_OK | MB_ICONERROR | MB_SYSTEMMODAL);
    return 0;
}

void CMalfunctionSystemInterface::ChangePreselectState(HWND hWnd)
{
    _FSI_STL::string stlStrLastMalf = CurrentMalfunction(hWnd);
    _FSI_STL::string stlStrLastSet  = LastSelectedSet(hWnd);

    if (m_mapMalfData.find(stlStrLastSet) != m_mapMalfData.end())
    {
        if (m_mapMalfData[stlStrLastSet].find(stlStrLastMalf) != m_mapMalfData[stlStrLastSet].end())
        {
            CMalfunctionData* pMalfData = (m_mapMalfData[stlStrLastSet])[stlStrLastMalf];
            if (pMalfData != NULL)
            {
                _FSI_STL::string stlStrLabel = pMalfData->GetData("mfLabel");
                if (m_mapPreselectConditionals.find(stlStrLabel) == m_mapPreselectConditionals.end())
                {
                    // Not a preselect for this malf yet.  Try to add one.
                    _FSI_STL::string    stlStrTrigger1;
                    char                lConditional1;
                    double              dValue1;

                    _FSI_STL::string    stlStrTrigger2;
                    char                lConditional2;
                    double              dValue2;

                    long                lAndResults;

                    // Get all of the data needed to construct the preselect conditional(s).
                    CVariant var;
                    CCommsShared::GetLocalValue(var, _FSI_STL::string("Malf_Preselect_Conditional_Value1"), (long)hWnd);
                    dValue1 = (double)var;

                    CCommsShared::GetLocalValue(var, _FSI_STL::string("Malf_Preselect_Conditional_Value2"), (long)hWnd);
                    dValue2 = (double)var;

                    CCommsShared::GetLocalValue(var, _FSI_STL::string("Malf_Preselect_Conditional_Trigger1"), (long)hWnd);
                    long trigger = (long)var;
                    if (m_mapTriggerEntries.find(trigger) != m_mapTriggerEntries.end())
                        stlStrTrigger1 = m_mapTriggerEntries[trigger].front();

                    CCommsShared::GetLocalValue(var, _FSI_STL::string("Malf_Preselect_Conditional_Trigger2"), (long)hWnd);
                    trigger = (long)var;
                    if (m_mapTriggerEntries.find(trigger) != m_mapTriggerEntries.end())
                        stlStrTrigger2 = m_mapTriggerEntries[trigger].front();

                    CCommsShared::GetLocalValue(var, _FSI_STL::string("Malf_Preselect_Conditional1"), (long)hWnd);
                    lConditional1 = (long)var;

                    CCommsShared::GetLocalValue(var, _FSI_STL::string("Malf_Preselect_Conditional2"), (long)hWnd);
                    lConditional2 = (long)var;

                    CCommsShared::GetLocalValue(var, _FSI_STL::string("Malf_Preselect_Link_Conditional"), (long)hWnd);
                    lAndResults = (long)var;
    

                    bool bPreselectValid = AddPreselect(stlStrTrigger1, lConditional1, dValue1,
                                                        stlStrTrigger2, lConditional2, dValue2, 
                                                        stlStrLabel, lAndResults);

                    if (bPreselectValid)
                    {
                        if (m_mapCommsActions.find(stlStrLabel) != m_mapCommsActions.end())
                        {
                            m_mapCommsActions[stlStrLabel]->ShowAsPreselect(true);
                        }

                        _FSI_STL::string stlStrStateMsg("Disarm Preselect");
                        var.Value(stlStrStateMsg);

                        CCommsShared::SetLocalValue(var, 
                                        _FSI_STL::string("Last_Selected_Preselect_State"), 
                                        -1, 
                                        (long)hWnd);
                    }
                    else
                    {
                        AfxBeginThread(InvalidPreselectThread, (LPVOID)0);
                    }
                }
                else
                {
                    // Change the text for the malfunction from disarm
                    // to arm.
                    _FSI_STL::string stlStrStateMsg("Arm Preselect");
                    CVariant var;
                    var.Value(stlStrStateMsg);

                    CCommsShared::SetLocalValue(var, 
                                    _FSI_STL::string("Last_Selected_Preselect_State"), 
                                    -1, 
                                    (long)hWnd);

                    if (CCommsShared::m_pFailureSummarySystemInterface != NULL)
                    {
                        CCommsShared::m_pFailureSummarySystemInterface->DeleteFailure(MALFUNCTION_ARMED, 
                                                                                   stlStrLastMalf, 
                                                                                   _FSI_STL::string(" armed."));
                    }

                    if (m_mapCommsActions.find(stlStrLabel) != m_mapCommsActions.end())
                    {
                        m_mapCommsActions[stlStrLabel]->DoNotShowAsPreselect(true);
                    }

                    // Remove the preselect
                    m_syncPreselect.Lock();

                    m_mapPreselectConditionals.erase(m_mapPreselectConditionals.find(stlStrLabel));

                    m_syncPreselect.Unlock();
                }
            }
        }
    }
}

bool CMalfunctionSystemInterface::LabelHasPreselect(const _FSI_STL::string& rstlStrLabel)
{
    bool bRet = false;

    m_syncPreselect.Lock();

    if (m_mapPreselectConditionals.find(rstlStrLabel) != m_mapPreselectConditionals.end())
        bRet = true;

    m_syncPreselect.Unlock();

    return bRet;
}

void CMalfunctionSystemInterface::ClearAllPreselects()
{
    _FSI_STL::map<_FSI_STL::string, struct Malf_Preselect_Data>::iterator mIt;
    _FSI_STL::map<_FSI_STL::string, struct Malf_Preselect_Data>::iterator mendIt;

    m_syncPreselect.Lock();

    mIt     = m_mapPreselectConditionals.begin();
    mendIt  = m_mapPreselectConditionals.end();


    // Walk the list and remove all of the failure summary
    // entires for the preselects.
    _FSI_STL::string stlStrLabel;
    while (mIt != mendIt)
    {
        stlStrLabel = (*mIt).first;

        if (m_mapCommsActions.find(stlStrLabel) != m_mapCommsActions.end())
        {
            m_mapCommsActions[stlStrLabel]->DoNotShowAsPreselect(true);
        }

        if (CCommsShared::m_pFailureSummarySystemInterface != NULL)
        {
            CCommsShared::m_pFailureSummarySystemInterface->DeleteFailure(MALFUNCTION_ARMED, 
                                                                        (*mIt).second.s_stlStrMalfTitle, 
                                                                       _FSI_STL::string(" armed."));
        }

        ++mIt;
    }

    // Clear the list of all conditionals.
    m_mapPreselectConditionals.clear();

    m_syncPreselect.Unlock();

    // Walk all of the screens and make sure that the
    // preselect button says arm since all of the preselects
    // have been cleared.
    _FSI_STL::map<HWND, _FSI_STL::string>::iterator mcmIt     = m_mapCurrentMalfunction.begin();
    _FSI_STL::map<HWND, _FSI_STL::string>::iterator mendcmIt  = m_mapCurrentMalfunction.end();

    CVariant var;

    _FSI_STL::string stlStrStateMsg("Arm Preselect");
    var.Value(stlStrStateMsg);

    while (mcmIt != mendcmIt)
    {
        CCommsShared::SetLocalValue(var, 
                        _FSI_STL::string("Last_Selected_Preselect_State"), 
                        -1, 
                        (long)(*mcmIt).first);

        ++mcmIt;
    }
}

bool CMalfunctionSystemInterface::AddPreselect(const _FSI_STL::string& rstlStrTrigger1,
                                               const long lConditional1,
                                               const double& rdValue1,
                                               const _FSI_STL::string& rstlStrTrigger2,
                                               const long lConditional2,
                                               const double& rdValue2,
                                               const _FSI_STL::string& rstlStrMalfunction,
                                               const long lAndResults)
{
    if (m_mapCommsActions.find(rstlStrMalfunction) == m_mapCommsActions.end())
        return false;

    // Create a struct for all of the preslect data.
    struct Malf_Preselect_Data PreselectData;

    // Trigger is "Altitude", "Airspeed", etc.
    // Make sure the first trigger in the preselect is valid.
    if (m_mapPreselectTriggers.find(rstlStrTrigger1) == m_mapPreselectTriggers.end())
        return false;

    if (lConditional1 == LESS_THAN || lConditional1 == GREATER_THAN)
        PreselectData.s_lConditional1            = lConditional1;
    else
        return false;

    if (rstlStrTrigger2 != "")
    {
        // Make sure the second trigger in the preselect is valid.
        if (m_mapPreselectTriggers.find(rstlStrTrigger2) == m_mapPreselectTriggers.end())
            return false;
    }

    if (lAndResults > 0 && rstlStrTrigger2 != "" && lConditional2 < 0)
        return false;

    PreselectData.s_lConditional2             = lConditional2;

    PreselectData.s_dValue1                   = rdValue1;
    PreselectData.s_dValue2                   = rdValue2;

    PreselectData.s_stlStrTrigger1            = m_mapPreselectTriggers[rstlStrTrigger1];
    PreselectData.s_stlStrTrigger2            = m_mapPreselectTriggers[rstlStrTrigger2];

    PreselectData.s_lAndResults               = lAndResults;

    if (CCommsShared::m_pFailureSummarySystemInterface != NULL)
    {
        PreselectData.s_stlStrMalfTitle = m_mapCommsActions[rstlStrMalfunction]->MalfTitle();
        CCommsShared::m_pFailureSummarySystemInterface->AddFailure(MALFUNCTION_ARMED, 
                                                                   PreselectData.s_stlStrMalfTitle, 
                                                                   _FSI_STL::string(" armed."));
    }

    m_syncPreselect.Lock();
    m_mapPreselectConditionals[rstlStrMalfunction] = PreselectData;
    m_syncPreselect.Unlock();

    return true;
}

void CMalfunctionSystemInterface::UpdatePreselects()
{
    // Walk current preselect conditions evaluating
    // each for a true condition.  If a preselect
    // conditional is true, set the host value and 
    // remove the conditional.
    _FSI_STL::map<_FSI_STL::string, struct Malf_Preselect_Data>::iterator mIt;
    _FSI_STL::map<_FSI_STL::string, struct Malf_Preselect_Data>::iterator mendIt;

    _FSI_STL::list<_FSI_STL::map<_FSI_STL::string, struct Malf_Preselect_Data>::iterator> listToDelete;

    CVariant varMalf;
    CVariant varConditional1;
    CVariant varConditional2;

    _FSI_STL::string stlStrMalfVariable;

    bool bConditional2 = false;

    bool bPreselect  = false;

    m_syncPreselect.Lock();

    mIt     = m_mapPreselectConditionals.begin();
    mendIt  = m_mapPreselectConditionals.end();

    while (mIt != mendIt)
    {
        bConditional2   = false;
        bPreselect      = false;

        if ((*mIt).second.s_stlStrTrigger1 != "")
        {
            stlStrMalfVariable = (*mIt).first;

            // Get the value of the host variable that is
            // used in the conditional--i.e. altitude, airspeed, etc.
            varMalf.Value(false);
            CCommsShared::GetHostValue(varMalf, stlStrMalfVariable);

            CCommsShared::GetHostValue(varConditional1, (*mIt).second.s_stlStrTrigger1);
            if ((*mIt).second.s_lConditional1 == LESS_THAN)
            {
                if ((double)varConditional1 < (*mIt).second.s_dValue1)
                    bPreselect = true;
                else
                    bPreselect = false;
            }
            else if ((*mIt).second.s_lConditional1 == GREATER_THAN)
            {
                if ((double)varConditional1 > (*mIt).second.s_dValue1)
                    bPreselect = true;
                else
                    bPreselect = false;
            }

            if ((*mIt).second.s_stlStrTrigger2 != "")
            {
                CCommsShared::GetHostValue(varConditional2, (*mIt).second.s_stlStrTrigger2);
                if ((*mIt).second.s_lConditional2 == LESS_THAN)
                {
                    if ((double)varConditional2 < (*mIt).second.s_dValue2)
                        bConditional2 = true;
                    else
                        bConditional2 = false;
                }
                else if ((*mIt).second.s_lConditional2 == GREATER_THAN)
                {
                    if ((double)varConditional2 > (*mIt).second.s_dValue2)
                        bConditional2 = true;
                    else
                        bConditional2 = false;
                }

                if ((*mIt).second.s_lAndResults > 0)
                    bPreselect = bPreselect && bConditional2;
                else
                    bPreselect = bPreselect || bConditional2;
            }
        }


        if (bPreselect)
        {
            if (CCommsShared::m_pFailureSummarySystemInterface != NULL)
            {
                CCommsShared::m_pFailureSummarySystemInterface->DeleteFailure(MALFUNCTION_ARMED, 
                                                                            (*mIt).second.s_stlStrMalfTitle, 
                                                                           _FSI_STL::string(" armed."));
            }

            varMalf.Value(true);
            CCommsShared::SetHostValue(varMalf, stlStrMalfVariable, -1);
            listToDelete.push_back(mIt);

            if (m_mapCommsActions.find(stlStrMalfVariable) != m_mapCommsActions.end())
            {
                m_mapCommsActions[stlStrMalfVariable]->DoNotShowAsPreselect(true);
            }
        }

        ++mIt;
    }


    _FSI_STL::list<_FSI_STL::map<_FSI_STL::string, struct Malf_Preselect_Data>::iterator>::iterator ldelIt;
    _FSI_STL::list<_FSI_STL::map<_FSI_STL::string, struct Malf_Preselect_Data>::iterator>::iterator ldelendIt;

    ldelIt      = listToDelete.begin();
    ldelendIt   = listToDelete.end();

    // Walk the list of conditionals to delete.
    // Free the memory for the CRange instance,
    // and for the struct Malf_Preslect_Data.  Then,
    // remove the conditional from the list.
    while (ldelIt != ldelendIt)
    {
        m_mapPreselectConditionals.erase((*ldelIt));

        ++ldelIt;
    }

    listToDelete.clear();

    m_syncPreselect.Unlock();
}

//////////////////////////////////////////////////////////////////////
// Accessors
//////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
// _FSI_STL::string CMalfunctionSystemInterface::CurrentMalfunction()
//
// Inputs           : None.
//
// Return Values    : The label of the current malfunction.
//
// Date             : 07 January 1999
//
// Engineer         : Billy Baker
//
// Description      : Accesssor method for getting the current malfunction.
//
/////////////////////////////////////////////////////////////////////////////
_FSI_STL::string CMalfunctionSystemInterface::CurrentMalfunction(const HWND hWnd)
{
    _FSI_STL::string stlStrCurrentMalfunction("");

    if (m_mapCurrentMalfunction.find(hWnd) != m_mapCurrentMalfunction.end())
    {
        stlStrCurrentMalfunction = m_mapCurrentMalfunction[hWnd];
    }

    return stlStrCurrentMalfunction;
}

/////////////////////////////////////////////////////////////////////////////
//
// _FSI_STL::string CMalfunctionSystemInterface::CurrentSet()
//
// Inputs           : None.
//
// Return Values    : The last selected set name.
//
// Date             : 07 January 1999
//
// Engineer         : Billy Baker
//
// Description      : Accesssor method for getting the name of the last 
//                    selected malfunction set.
//
/////////////////////////////////////////////////////////////////////////////
_FSI_STL::string CMalfunctionSystemInterface::CurrentSet(const HWND hWnd)
{
    _FSI_STL::string stlStrCurrentSet("");

    if (m_mapCurrentSet.find(hWnd) != m_mapCurrentSet.end())
    {
        stlStrCurrentSet = m_mapCurrentSet[hWnd];
    }

    return stlStrCurrentSet;
}

_FSI_STL::string CMalfunctionSystemInterface::LastSelectedSet(const HWND hWnd)
{
    _FSI_STL::string stlStrLastSelectedSet("");

    if (m_mapLastSelectedSet.find(hWnd) != m_mapLastSelectedSet.end())
    {
        stlStrLastSelectedSet = m_mapLastSelectedSet[hWnd];
    }

    return stlStrLastSelectedSet;
}

/////////////////////////////////////////////////////////////////////////////
//
// _FSI_STL::string CMalfunctionSystemInterface::CurrentDB()
//
// Inputs           : None.
//
// Return Values    : The name of the database containing malfunction data.
//
// Date             : 07 January 1999
//
// Engineer         : Billy Baker
//
// Description      : Accesssor method for getting the name of the database 
//                    containing malfunction data.
//
/////////////////////////////////////////////////////////////////////////////
_FSI_STL::string CMalfunctionSystemInterface::CurrentDB()
{
    return m_stlStrCurrentDB;
}

/////////////////////////////////////////////////////////////////////////////
//
// long CMalfunctionSystemInterface::SectionStart()
//
// Inputs           : None.
//
// Return Values    : The first section title to display.
//
// Date             : 26 October 1999
//
// Engineer         : Billy Baker
//
// Description      : Accesssor method for getting the index of the first
//                    section title to display.
//
/////////////////////////////////////////////////////////////////////////////
long CMalfunctionSystemInterface::SectionStart(const HWND hWnd)
{
    long ret_val = 0;

    if (m_mapSectionStarts.find(hWnd) != m_mapSectionStarts.end())
    {
        ret_val = m_mapSectionStarts[hWnd];
    }

    return ret_val;
}

/////////////////////////////////////////////////////////////////////////////
//
// long CMalfunctionSystemInterface::SectionCount()
//
// Inputs           : None.
//
// Return Values    : The number of sections with malfunctions.
//
// Date             : 26 October 1999
//
// Engineer         : Billy Baker
//
// Description      : Accesssor method for getting the number of sections 
//                    with malfunctions.
//
/////////////////////////////////////////////////////////////////////////////
long CMalfunctionSystemInterface::SectionCount()
{
    return m_lSectionCount;
}

/////////////////////////////////////////////////////////////////////////////
//
// long CMalfunctionSystemInterface::MalfStart()
//
// Inputs           : None.
//
// Return Values    : The first Malf title to display.
//
// Date             : 26 October 1999
//
// Engineer         : Billy Baker
//
// Description      : Accesssor method for getting the index of the first
//                    malf title to display.
//
/////////////////////////////////////////////////////////////////////////////
long CMalfunctionSystemInterface::MalfStart(const HWND hWnd)
{
    long ret_val = 0;

    if (m_mapMalfStarts.find(hWnd) != m_mapMalfStarts.end())
    {
        ret_val = m_mapMalfStarts[hWnd];
    }

    return ret_val;
}

/////////////////////////////////////////////////////////////////////////////
//
// long CMalfunctionSystemInterface::MalfCount()
//
// Inputs           : None.
//
// Return Values    : The number of Malfs with malfunctions.
//
// Date             : 26 October 1999
//
// Engineer         : Billy Baker
//
// Description      : Accesssor method for getting the number of Malfs 
//                    with malfunctions.
//
/////////////////////////////////////////////////////////////////////////////
long CMalfunctionSystemInterface::MalfCount(const HWND hWnd)
{
    long ret_val = 0;

    if (m_mapMalfCounts.find(hWnd) != m_mapMalfCounts.end())
    {
        ret_val = m_mapMalfCounts[hWnd];
    }

    return ret_val;
}

//////////////////////////////////////////////////////////////////////
// Mutators
//////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
// void CMalfunctionSystemInterface::CurrentMalfunction()
//
// Inputs           : _FSI_STL::string& rstlStrCurrentMalfunction - the new current
//                                                             malfunction
//
// Return Values    : None.
//
// Date             : 07 January 1999
//
// Engineer         : Billy Baker
//
// Description      : Mutator method for setting the current malfunction.
//
/////////////////////////////////////////////////////////////////////////////
void CMalfunctionSystemInterface::CurrentMalfunction(const HWND hWnd,
                                        const _FSI_STL::string& rstlStrCurrentMalfunction)
{
    CVariant var;
    var.Value(m_mapCurrentSet[hWnd]);
    CCommsShared::SetLocalValue(var, _FSI_STL::string("Last_Selected_Set_Title"), -1, (long)hWnd);
    m_mapLastSelectedSet[hWnd] = m_mapCurrentSet[hWnd];
    var.Value(rstlStrCurrentMalfunction);
    CCommsShared::SetLocalValue(var, _FSI_STL::string("Last_Selected_Malf_Title"), -1, (long)hWnd);

    // An assignment and an update are needed.
    m_mapCurrentMalfunction[hWnd] = rstlStrCurrentMalfunction;

    // Update the CMalfDescWidget to show the new description.
    _FSI_STL::list<CAction*>::iterator lIt  = m_mapFieldActions[hWnd].begin();
    _FSI_STL::list<CAction*>::iterator lendIt = m_mapFieldActions[hWnd].end();
    while (lIt != lendIt)
    {
        (*lIt)->OnUpdate();

        ++lIt;
    }

    _FSI_STL::string stlStrLastSet = m_mapCurrentSet[hWnd];

    if (m_mapMalfData.find(stlStrLastSet) != m_mapMalfData.end())
    {
        if (m_mapMalfData[stlStrLastSet].find(rstlStrCurrentMalfunction) != m_mapMalfData[stlStrLastSet].end())
        {
            CMalfunctionData* pMalfData = (m_mapMalfData[stlStrLastSet])[rstlStrCurrentMalfunction];
            if (pMalfData != NULL)
            {
                _FSI_STL::string stlStrLabel = pMalfData->GetData("mfLabel");
                if (m_mapPreselectConditionals.find(stlStrLabel) != m_mapPreselectConditionals.end())
                {
                    // Set all of the data needed to construct the preselect conditional(s).
                    CVariant var;
                    struct Malf_Preselect_Data mpd = m_mapPreselectConditionals[stlStrLabel];

                    var.Value(mpd.s_dValue1);
                    CCommsShared::SetLocalValue(var, _FSI_STL::string("Malf_Preselect_Conditional_Value1"), -1, (long)hWnd);

                    var.Value(mpd.s_lConditional1);
                    CCommsShared::SetLocalValue(var, _FSI_STL::string("Malf_Preselect_Conditional1"), -1, (long)hWnd);

                    _FSI_STL::map<long, _FSI_STL::list<_FSI_STL::string> >::iterator mTrigIt;
                    _FSI_STL::map<long, _FSI_STL::list<_FSI_STL::string> >::iterator mendTrigIt;

                    mTrigIt = m_mapTriggerEntries.begin();
                    mendTrigIt = m_mapTriggerEntries.end();
                    long intForString = 0;
                    var.Value(0L);
                    while (mTrigIt != mendTrigIt)
                    {
                        ++intForString;

                        if (mpd.s_stlStrTrigger1 == m_mapPreselectTriggers[(*mTrigIt).second.front()])
                        {
                            var.Value(intForString);
                            break;
                        }

                        ++mTrigIt;
                    }
                    CCommsShared::SetLocalValue(var, _FSI_STL::string("Malf_Preselect_Conditional_Trigger1"), -1, (long)hWnd);

                    mTrigIt = m_mapTriggerEntries.begin();
                    mendTrigIt = m_mapTriggerEntries.end();
                    intForString = 0;
                    bool   second_trigger_found =  false;
                    while (mTrigIt != mendTrigIt)
                    {
                        ++intForString;

                        if (mpd.s_stlStrTrigger2 == m_mapPreselectTriggers[(*mTrigIt).second.front()])
                        {
                           second_trigger_found =  true;
                           break;
                        }

                        ++mTrigIt;
                    }

                    if (second_trigger_found)
                    {
                        var.Value(mpd.s_dValue2);
                        CCommsShared::SetLocalValue(var, _FSI_STL::string("Malf_Preselect_Conditional_Value2"), -1, (long)hWnd);
                        
                        var.Value(intForString);
                        CCommsShared::SetLocalValue(var, _FSI_STL::string("Malf_Preselect_Conditional_Trigger2"), -1, (long)hWnd);
                        
                        var.Value(mpd.s_lConditional2);
                        CCommsShared::SetLocalValue(var, _FSI_STL::string("Malf_Preselect_Conditional2"), -1, (long)hWnd);

                        var.Value(mpd.s_lAndResults);
                        CCommsShared::SetLocalValue(var, _FSI_STL::string("Malf_Preselect_Link_Conditional"), -1, (long)hWnd);
                    }
                    else
                    {
                        var.Value(0.0);
                        CCommsShared::SetLocalValue(var, _FSI_STL::string("Malf_Preselect_Conditional_Value2"), -1, (long)hWnd);
                        
                        var.Value(0L);
                        CCommsShared::SetLocalValue(var, _FSI_STL::string("Malf_Preselect_Conditional_Trigger2"), -1, (long)hWnd);
                        
                        var.Value(-1L);
                        CCommsShared::SetLocalValue(var, _FSI_STL::string("Malf_Preselect_Conditional2"), -1, (long)hWnd);

                        var.Value(-1L);
                        CCommsShared::SetLocalValue(var, _FSI_STL::string("Malf_Preselect_Link_Conditional"), -1, (long)hWnd);
                    }


                    _FSI_STL::string stlStrStateMsg("Disarm Preselect");
                    var.Value(stlStrStateMsg);

                    CCommsShared::SetLocalValue(var, 
                                    _FSI_STL::string("Last_Selected_Preselect_State"), 
                                    -1, 
                                    (long)hWnd);

                    var.Value(true);
                    CCommsShared::SetLocalValue(var, 
                                    _FSI_STL::string("malfunction_type"), 
                                    -1, 
                                    (long)hWnd);

                    var.Value(false);
                    CCommsShared::SetLocalValue(var, 
                                    _FSI_STL::string("malfunction_type_not"), 
                                    -1, 
                                    (long)hWnd);
                }
                else
                {
                    // Set all of the data needed to construct the preselect conditional(s).
                    CVariant var;

                    var.Value(0.0);
                    CCommsShared::SetLocalValue(var, _FSI_STL::string("Malf_Preselect_Conditional_Value1"), -1, (long)hWnd);

                    var.Value(0.0);
                    CCommsShared::SetLocalValue(var, _FSI_STL::string("Malf_Preselect_Conditional_Value2"), -1, (long)hWnd);

                    var.Value(0L);
                    CCommsShared::SetLocalValue(var, _FSI_STL::string("Malf_Preselect_Conditional_Trigger1"), -1, (long)hWnd);

                    var.Value(0L);
                    CCommsShared::SetLocalValue(var, _FSI_STL::string("Malf_Preselect_Conditional_Trigger2"), -1, (long)hWnd);

                    var.Value(-1L);
                    CCommsShared::SetLocalValue(var, _FSI_STL::string("Malf_Preselect_Conditional1"), -1, (long)hWnd);

                    var.Value(-1L);
                    CCommsShared::SetLocalValue(var, _FSI_STL::string("Malf_Preselect_Conditional2"), -1, (long)hWnd);

                    var.Value(-1L);
                    CCommsShared::SetLocalValue(var, _FSI_STL::string("Malf_Preselect_Link_Conditional"), -1, (long)hWnd);

                    _FSI_STL::string stlStrStateMsg("Arm Preselect");
                    var.Value(stlStrStateMsg);

                    CCommsShared::SetLocalValue(var, 
                                    _FSI_STL::string("Last_Selected_Preselect_State"), 
                                    -1, 
                                    (long)hWnd);

                    var.Value(false);
                    CCommsShared::SetLocalValue(var, 
                                    _FSI_STL::string("malfunction_type"), 
                                    -1, 
                                    (long)hWnd);

                    var.Value(true);
                    CCommsShared::SetLocalValue(var, 
                                    _FSI_STL::string("malfunction_type_not"), 
                                    -1, 
                                    (long)hWnd);
                }
            }
        }
    }
}

void CMalfunctionSystemInterface::CurrentMalfunctionState(const _FSI_STL::string& rstlStrCurrentMalfunction,
                                                            bool bState)
{
    _FSI_STL::map<HWND, _FSI_STL::string>::iterator mIt     = m_mapCurrentMalfunction.begin();
    _FSI_STL::map<HWND, _FSI_STL::string>::iterator mendIt  = m_mapCurrentMalfunction.end();

    CVariant var;

    while (mIt != mendIt)
    {
        if (rstlStrCurrentMalfunction == (*mIt).second)
        {
            if (bState)
            {
                _FSI_STL::string stlStrStateMsg("Arm Preselect");
                var.Value(stlStrStateMsg);

                // If the current malfunction had a preselect and
                // the malf is now active, then make sure that the
                // text on the preselect button changes from disarm to
                // arm.  If the malf is active and the button says arm
                // it should be disabled.
                CCommsShared::SetLocalValue(var, 
                                _FSI_STL::string("Last_Selected_Preselect_State"), 
                                -1, 
                                (long)(*mIt).first);

                var.Value(false);
                CCommsShared::SetLocalValue(var, 
                                _FSI_STL::string("malfunction_type"), 
                                -1, 
                                (long)(*mIt).first);

                var.Value(true);
                CCommsShared::SetLocalValue(var, 
                                _FSI_STL::string("malfunction_type_not"), 
                                -1, 
                                (long)(*mIt).first);

                stlStrStateMsg = "Deactivate Malfunction";
                var.Value(stlStrStateMsg);
            }
            else
            {
                _FSI_STL::string stlStrStateMsg("Activate Malfunction");
                var.Value(stlStrStateMsg);
            }

            CCommsShared::SetLocalValue(var, 
                                 _FSI_STL::string("Last_Selected_Malf_State"), 
                                 -1, 
                                 (long)(*mIt).first);
        }

        ++mIt;
    }
}
/////////////////////////////////////////////////////////////////////////////
//
// void CMalfunctionSystemInterface::CurrentSet()
//
// Inputs           : _FSI_STL::string& rstlStrCurrentSet - the new current malf set
//
// Return Values    : None.
//
// Date             : 27 January 1999
//
// Engineer         : Billy Baker
//
// Description      : Mutator method for setting the m_stlStrCurrentSet member 
//                    to the newly selected set name.
//
/////////////////////////////////////////////////////////////////////////////
void CMalfunctionSystemInterface::CurrentSet(const HWND hWnd,
                                             const _FSI_STL::string& rstlStrCurrentSet)
{
    CVariant var;
    var.Value(rstlStrCurrentSet);
    CCommsShared::SetLocalValue(var, _FSI_STL::string("Current_Selected_Set_Title"), -1, (long)hWnd);

    m_mapCurrentSet[hWnd]  = rstlStrCurrentSet;

    var.Value(false);
    CCommsShared::SetLocalValue(var, _FSI_STL::string("Previous_Malfs_Enabled"), -1, (long)hWnd);

    if (m_mapMalfData[m_mapCurrentSet[hWnd]].size() > m_mapDataActions[hWnd].size())
    {
        var.Value(true);
        CCommsShared::SetLocalValue(var, _FSI_STL::string("Next_Malfs_Enabled"), -1, (long)hWnd);
    }
    else
    {
        CCommsShared::SetLocalValue(var, _FSI_STL::string("Next_Malfs_Enabled"), -1, (long)hWnd);
    }

    MalfCount(hWnd, m_mapMalfData[m_mapCurrentSet[hWnd]].size());

    MalfStart(hWnd, 0);
}

/////////////////////////////////////////////////////////////////////////////
//
// void CMalfunctionSystemInterface::CurrentDB()
//
// Inputs           : _FSI_STL::string& rstlStrCurrentDB - the current malfunction DB
//
// Return Values    : None.
//
// Date             : 07 January 1999
//
// Engineer         : Billy Baker
//
// Description      : Mutator method for setting the current malfunction DB.
//
/////////////////////////////////////////////////////////////////////////////
void CMalfunctionSystemInterface::CurrentDB(const _FSI_STL::string& rstlStrCurrentDB)
{
    m_stlStrCurrentDB = rstlStrCurrentDB;
}

/////////////////////////////////////////////////////////////////////////////
//
// void CMalfunctionSystemInterface::SectionStart()
//
// Inputs           : long lSectionStart - new first section title to display
//
// Return Values    : None.
//
// Date             : 26 October 1999
//
// Engineer         : Billy Baker
//
// Description      : Mutator method for setting the first section title to
//                    display.
//
/////////////////////////////////////////////////////////////////////////////
void CMalfunctionSystemInterface::SectionStart(const HWND hWnd,
                                               long lSectionStart)
{
    if (m_mapSectionStarts[hWnd] != lSectionStart)
    {
        // An assignment and an update are needed.
        m_mapSectionStarts[hWnd] = lSectionStart;

        _FSI_STL::list<CAction*>::iterator lIt = m_mapSectionActions[hWnd].begin();
        _FSI_STL::list<CAction*>::iterator lendIt = m_mapSectionActions[hWnd].end();

        while (lIt != lendIt)
        {
            (*lIt)->OnUpdate();

            ++lIt;
        }
    }
}

/////////////////////////////////////////////////////////////////////////////
//
// void CMalfunctionSystemInterface::MalfStart()
//
// Inputs           : long lMalfStart - new first Malf title to display
//
// Return Values    : None.
//
// Date             : 26 October 1999
//
// Engineer         : Billy Baker
//
// Description      : Mutator method for setting the first Malf title to
//                    display.
//
/////////////////////////////////////////////////////////////////////////////
void CMalfunctionSystemInterface::MalfStart(const HWND hWnd, long lMalfStart)
{
    if (m_mapMalfStarts[hWnd] != lMalfStart)
    {
        // An assignment and an update are needed.
        m_mapMalfStarts[hWnd] = lMalfStart;

        CVariant var;
        if (m_mapMalfStarts[hWnd] > 0)
        {
            var.Value(true);
            CCommsShared::SetLocalValue(var, _FSI_STL::string("Previous_Malfs_Enabled"), -1, (long)hWnd);
        }
        else
        {
            var.Value(false);
            CCommsShared::SetLocalValue(var, _FSI_STL::string("Previous_Malfs_Enabled"), -1, (long)hWnd);
        }

        if (m_mapMalfData[m_mapCurrentSet[hWnd]].size() - m_mapMalfStarts[hWnd] > m_mapDataActions[hWnd].size())
        {
            var.Value(true);
            CCommsShared::SetLocalValue(var, _FSI_STL::string("Next_Malfs_Enabled"), -1, (long)hWnd);
        }
        else
        {
            var.Value(false);
            CCommsShared::SetLocalValue(var, _FSI_STL::string("Next_Malfs_Enabled"), -1, (long)hWnd);
        }

        // Update the CMalfDescWidget to show the new description.
        _FSI_STL::list<CAction*>::iterator lIt    = m_mapDataActions[hWnd].begin();
        _FSI_STL::list<CAction*>::iterator lendIt = m_mapDataActions[hWnd].end();

        _FSI_STL::list<CAction*>::iterator lmcaIt   = NULL;
        CWidget* pWidget        = NULL;
        CWidget* pActionWidget  = NULL;
        CAction* pAction        = NULL;

        while (lIt != lendIt)
        {
            pWidget        = ((CWidget*)(*lIt)->Widget())->ParentWidget();

            if (CWidget::IsValidAddress(pWidget) != INVALID)
            {
                pActionWidget  = pWidget->GetNextAction(lmcaIt);
                if (CWidget::IsValidAddress(pActionWidget) != INVALID)
                {
                    pAction = pActionWidget->Action();
                    while (pAction != NULL)
                    {
                        if (dynamic_cast<CMalfCommsAction*>(pAction) != NULL)
                        {
                            pWidget->DeleteAction(pAction);
                            pActionWidget->ParentWidget(NULL);
                            lmcaIt = NULL;
                        }

                        pActionWidget = pWidget->GetNextAction(lmcaIt);
                        if (pActionWidget != NULL)
                        {
                            pAction = pActionWidget->Action();
                        }
                        else
                        {
                            pAction = NULL;
                        }
                    }
                }

                (*lIt)->OnUpdate();

                ++lIt;

                lmcaIt = NULL;
            }
        }
    }
}

/////////////////////////////////////////////////////////////////////////////
//
// void CMalfunctionSystemInterface::MalfCount()
//
// Inputs           : long lMalfCount - number of Malfs with malfs
//
// Return Values    : None.
//
// Date             : 26 October 1999
//
// Engineer         : Billy Baker
//
// Description      : Mutator method for setting the number of Malfs with
//                    malfunctions.
//
/////////////////////////////////////////////////////////////////////////////
void CMalfunctionSystemInterface::MalfCount(const HWND hWnd, long lMalfCount)
{
    // An assignment and an update are needed.
    m_mapMalfCounts[hWnd] = lMalfCount;

    // Update the CMalfDescWidget to show the new description.
    _FSI_STL::list<CAction*>::iterator lIt      = m_mapDataActions[hWnd].begin();
    _FSI_STL::list<CAction*>::iterator lendIt   = m_mapDataActions[hWnd].end();

    CWidget* pWidget        = NULL;

    while (lIt != lendIt)
    {
        pWidget        = ((CWidget*)(*lIt)->Widget())->ParentWidget();

        if (CWidget::IsValidAddress(pWidget) != INVALID)
        {
            // Update the data action
            (*lIt)->OnUpdate();

            ++lIt;
        }
    }
}


