/////////////////////////////////////////////////////////////////////////////
//
//           F L I G H T S A F E T Y   I N T E R N A T I O N A L
//                     Simulation Systems Division
//                      2700 North Hemlock Circle
//                     Broken Arrow, Oklahoma 74012
//                          (918) 259-4000
/////////////////////////////////////////////////////////////////////////////
//
// DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
// Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
// technical or operational data or information from automatic dissemination
// under the International Exchange Program or by other means.  This protection
// covers information required solely for administrative or operational
// purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
//
// WARNING:  This document contains technical data whose export is restricted
// by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
// Executive Order 12470.  Violation of these export control laws is subject
// to severe criminal penalties.  Dissemination of this document is controlled
// under DOD Directive 5230.25
//
/////////////////////////////////////////////////////////////////////////////
//
//
// Filename         : MalfunctionsConfigPage.cpp
//
// Date             : 12 January 1999
//
// Engineer         : Billy Baker
//
// Revision         :
//
// Description      : MalfunctionsConfigPage.cpp contains the 
//                    implementation of the CMalfunctionsConfigPage.  
//                    This class provides additional configuration 
//                    settings that are specific to the Malfunctions 
//                    component.  These additional settings are the 
//                    paths for malfunction database files.  Like other 
//                    component configuration pages, 
//                    CMalfunctionsConfigPage is derived from CBasePage.
//
// Classification   : UNCLASSIFIED
//
// Requirements     : MFC.
//
// Components Used  : Core::CBasePage.
//
// Operational 
//    Restrictions  : Machine dependencies/restrictions
//                        None.
//                    Design dependencies/restrictions
//                        MFC, access to the registry.
//                    Operations containing dependencies/restrictions
//                        None.
//                    Compiler dependencies/restrictions
//                        None.
//                    Other conditions for proper execution
//                        None.
//
// Environment      : Operating system(s) - Microsoft Windows NT 4.0 with
//                                              NT service pack 3
//                                          Microsoft Windows NT 5.0
//
//                    Compiler(s) - Visual C++ 6.0
//
//                    Architechure(s) - Intel Pentium, Pentium II
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
//                              R e v i s i o n   H i s t o r y
//
/////////////////////////////////////////////////////////////////////////////
#include "..\core\stdafx.h"
#include "MalfunctionsConfigPage.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
//
// CMalfunctionsConfigPage::CMalfunctionsConfigPage()
//
// Inputs           : None.
//
// Return Values    : None.
//
// Date             : 12 January 1999
//
// Engineer         : Billy Baker
//
// Description      : Default constructor for the 
//                    CMalfunctionsConfigPage class.  The name of the 
//                    page is set and variables used for data exchange 
//                    are initialized.
//
/////////////////////////////////////////////////////////////////////////////
CMalfunctionsConfigPage::CMalfunctionsConfigPage() : 
                                        CBasePage(CMalfunctionsConfigPage::IDD)
{
	//{{AFX_DATA_INIT(CMalfunctionsConfigPage)
	m_strDatabase = _T("");
	//}}AFX_DATA_INIT
    m_stlStrPageName = _FSI_STL::string("Malfunctions Config");
}

/////////////////////////////////////////////////////////////////////////////
//
// CMalfunctionsConfigPage::~CMalfunctionsConfigPage()
//                    
//
// Inputs           : None.
//
// Return Values    : None.
//
// Date             : 12 January 1999
//
// Engineer         : Billy Baker
//
// Description      : Default destructor.
//
/////////////////////////////////////////////////////////////////////////////
CMalfunctionsConfigPage::~CMalfunctionsConfigPage()
{
}

void CMalfunctionsConfigPage::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CMalfunctionsConfigPage)
	DDX_Control(pDX, IDC_DB_LIST, m_ctrlDBList);
	DDX_Text(pDX, IDC_MALFUNCTIONDATABASE, m_strDatabase);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CMalfunctionsConfigPage, CBasePage)
	//{{AFX_MSG_MAP(CMalfunctionsConfigPage)
	ON_BN_CLICKED(IDC_ADD_DB_BUTTON, OnAddDb)
	ON_BN_CLICKED(IDC_DELETE_DB_BUTTON, OnDeleteDb)
	ON_BN_CLICKED(IDC_MALFUNCTIONDATABASE_BUTTON, OnMalfunctionDatabase)
	ON_NOTIFY(NM_CLICK, IDC_DB_LIST, OnClickDbList)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
//
// CBasePage* CMalfunctionsConfigPage::CreateObject()
//
// Inputs           : None.
//
// Return Values    : A pointer to a new instance of CMalfunctionsConfigP
//                    age.
//
// Date             : 12 January 1999
//
// Engineer         : Billy Baker
//
// Description      : CreateObject is a standard framework method that 
//                    must be implmemented by CBasePage derived 
//                    classes, CWidget derived classes, and CAction 
//                    derived classes.  It must be static.
//
/////////////////////////////////////////////////////////////////////////////
CBasePage* CMalfunctionsConfigPage::CreateObject()
{
    return new CMalfunctionsConfigPage;
}

/////////////////////////////////////////////////////////////////////////////
//
// void CMalfunctionsConfigPage::SetProperties()
//
// Inputs           : void* pWidget - a void pointer to the name of the 
//                                    component using this CBasePage 
//                                    derived class.
//
// Return Values    : None.
//
// Date             : 12 January 1999
//
// Engineer         : Billy Baker
//
// Description      : SetProperties is a standard framework method that 
//                    can be overriden in classes derived from 
//                    CBasePage.  By default, nothing will happen if 
//                    the method is not overriden.  SetProperties is 
//                    called when the CBasePage derived classes are 
//                    created and added to a CFSISuite::CPropertiesDlg 
//                    derived class.  These calls are made before 
//                    OnInitDialog so that data from the registry or a 
//                    data file can be used to initialize variables in 
//                    the class.
//
/////////////////////////////////////////////////////////////////////////////
void CMalfunctionsConfigPage::SetProperties(void* pWidget)
{
    CString strComponentName = CString((char *)pWidget);
    HKEY hKey;
    RegOpenKeyEx(HKEY_LOCAL_MACHINE, _T("Software\\FlightSafety\\FSISuite\\") + strComponentName, 0, KEY_READ, &hKey);

    if (hKey != NULL)
    {
        m_listDBPath.clear();

        long int lDBCount = 0;
        long int lDBStep = 1;
        unsigned long int ulData = 0;
        DWORD dwSize = sizeof (unsigned long int);
        RegQueryValueEx(hKey, _T("MalfDBCount"), NULL, NULL, (BYTE*)&ulData, 
                        &dwSize);
        lDBCount = ulData;

        CString strDBXXX;
        DWORD dwType, dwCount;
        LONG lResult;

        // Get all of the malfunction database paths.
        for (; lDBStep <= lDBCount; lDBStep++)
        {
            strDBXXX.Format("MalfDB%d",lDBStep);

		    CString strValue;
		    lResult = RegQueryValueEx(hKey, (LPCTSTR)strDBXXX, 
                                           NULL, &dwType, NULL, &dwCount);
		    if (lResult == ERROR_SUCCESS)
		    {
			    ASSERT(dwType == REG_SZ);
			    lResult = RegQueryValueEx(hKey, (LPCTSTR)strDBXXX, NULL, 
                                          &dwType,
				                (LPBYTE)strValue.GetBuffer(dwCount/sizeof(TCHAR)),
                                          &dwCount);

			    strValue.ReleaseBuffer();
		    }

            m_listDBPath.push_back(strValue);
        }

        RegCloseKey(hKey);
    }
}

/////////////////////////////////////////////////////////////////////////////
//
// void CMalfunctionsConfigPage::UpdateProperties()
//
// Inputs           : void* pWidget - a void pointer to the name of the 
//                                    component using this CBasePage 
//                                    derived class.
//
// Return Values    : None.
//
// Date             : 12 January 1999
//
// Engineer         : Billy Baker
//
// Description      : UpdateProperties is a standard framework method that 
//                    can be overriden in classes derived from 
//                    CBasePage.  By default, nothing will happen if 
//                    the method is not overriden.  UpdateProperties is 
//                    called when the Ok or Apply buttons are pressed on
//                    a CFSISuite::CPropertiesDlg derived class.  These 
//                    calls are made so that data from the variables in
//                    the class can be written to the registry or a 
//                    data file.
//
/////////////////////////////////////////////////////////////////////////////
void CMalfunctionsConfigPage::UpdateProperties(void* pWidget)
{
    if (GetSafeHwnd() == NULL)
    {
        return;
    }

    CString strComponentName = CString((char *)pWidget);
    HKEY hKey;
    DWORD dw;
    RegCreateKeyEx(HKEY_LOCAL_MACHINE, _T("Software\\FlightSafety\\FSISuite\\") +  strComponentName,
                 0, NULL, REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, NULL, &hKey, &dw);

    if (hKey != NULL)
    {
        UpdateData(TRUE);
        long int lDBCount = m_ctrlDBList.GetItemCount();
        long int lDBStep = 0;
        unsigned long int ulData = lDBCount;
        DWORD dwSize = sizeof (unsigned long int);
        RegSetValueEx(hKey, _T("MalfDBCount"), NULL, REG_DWORD, (BYTE*)&ulData, 
                        dwSize);

        CString strDBXXX;
        CString strDBPath;

        // Put all of the paths into the registry.
        for (; lDBStep < lDBCount; lDBStep++)
        {
            strDBXXX.Format("MalfDB%d",lDBStep+1);
            strDBPath = m_ctrlDBList.GetItemText(lDBStep,0);

            RegSetValueEx(hKey, (LPCTSTR)strDBXXX, NULL, REG_SZ, 
                          (BYTE*)(LPCTSTR)strDBPath,
                          strDBPath.GetLength() + 1);
        }

        RegCloseKey(hKey);
    }
}

void CMalfunctionsConfigPage::OnAddDb() 
{
    UpdateData(TRUE);
    
    if (m_strDatabase.GetLength() > 0)
    {
        LVFINDINFO lvfi;
        lvfi.flags = LVFI_STRING;
        lvfi.psz = (LPCTSTR)m_strDatabase;
        if (m_ctrlDBList.FindItem(&lvfi,-1) == -1)
        {
            long int lItemCount = m_ctrlDBList.GetItemCount();
            lItemCount = m_ctrlDBList.InsertItem(lItemCount, 
                                                 (LPCTSTR)m_strDatabase);
        }
        else
        {
            ::MessageBox(GetSafeHwnd(), 
                         _T("Duplicate string encountered for database path."),
                         _T("Error"), 
                         MB_OK);
        }
    }
    else
    {
        ::MessageBox(GetSafeHwnd(),
                     _T("Null string encountered for database path."),
                     _T("Error"),
                     MB_OK);
    }
}

void CMalfunctionsConfigPage::OnDeleteDb() 
{
    UpdateData(TRUE);

    if (m_strDatabase.GetLength() > 0)
    {
        LVFINDINFO lvfi;
        lvfi.flags = LVFI_STRING;
        lvfi.psz = (LPCTSTR)m_strDatabase;
        long int lDBIndex = m_ctrlDBList.FindItem(&lvfi,-1);
        if (lDBIndex > -1)
        {
            m_ctrlDBList.DeleteItem(lDBIndex);
        }
        else
        {
            ::MessageBox(GetSafeHwnd(), 
                         _T("Database path could not be found to delete."),
                         _T("Error"), 
                         MB_OK);
            return;
        }
    }
    else
    {
        ::MessageBox(GetSafeHwnd(),
                     _T("Null string encountered for database path."),
                     _T("Error"),
                     MB_OK);
    }
	
}

void CMalfunctionsConfigPage::OnMalfunctionDatabase() 
{
    CFileDialog cfd(TRUE, "mdb", NULL,
                    OFN_SHAREAWARE | OFN_PATHMUSTEXIST | OFN_HIDEREADONLY,
                    "Malfunction Databases (*.mdb)|*.mdb|All Files (*.*)|*.*||",
                    this);

    long int lRetVal = cfd.DoModal();

    if (lRetVal == IDOK)
    {
        m_strDatabase = cfd.GetPathName();
        UpdateData(FALSE);
    }
}

BOOL CMalfunctionsConfigPage::OnInitDialog() 
{
	CBasePage::OnInitDialog();
	
    m_ctrlDBList.SetExtendedStyle(m_ctrlDBList.GetExtendedStyle() & 
                                  LVS_EX_FULLROWSELECT);

    m_ctrlDBList.InsertColumn(0,"Path names", LVCFMT_LEFT, 600);
	
    _FSI_STL::list<CString>::iterator lIt = m_listDBPath.begin();
    long int lDBStep = 0;
    for (; lIt != m_listDBPath.end(); lIt++, lDBStep++)
    {
        m_ctrlDBList.InsertItem(lDBStep, (LPCTSTR)(*lIt));
    }
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CMalfunctionsConfigPage::OnClickDbList(NMHDR* pNMHDR, LRESULT* pResult) 
{
	UpdateData(TRUE);
    POSITION pos = m_ctrlDBList.GetFirstSelectedItemPosition();
    if (pos != NULL)
    {
        long int lSelectedIndex = m_ctrlDBList.GetNextSelectedItem(pos);
        CString strDBPath = m_ctrlDBList.GetItemText(lSelectedIndex, 0);

        m_strDatabase = strDBPath;

        UpdateData(FALSE);
    }

	*pResult = 0;
}
