// MalfunctionsComponentInterface.cpp: implementation of the CMalfunctionsComponentInterface class.
//
//////////////////////////////////////////////////////////////////////
#include "..\core\stdafx.h"

#include "MalfunctionsComponentInterface.h"

#include "..\comms\CommsShared.h"

#include "MalfunctionsConfigPage.h"
#include "MalfPreselectPage.h"

#include "MalfDataAction.h"
#include "MalfDataMoveAction.h"
#include "MalfChangeStateAction.h"
#include "PreselectChangeStateAction.h"
#include "MalfClearAllAction.h"
#include "MalfClearAllPreselectsAction.h"
#include "MalfFieldAction.h"
#include "MalfPreselectTriggerFillAction.h"
#include "MalfSectionFieldAction.h"
#include "MalfSectionMoveAction.h"
#include "..\fsisuite\product_version.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

// The following static members contain the date and time of the last
// compilation of this class.
const char CMalfunctionsComponentInterface::m_cRevisionDate[] = __DATE__;
const char CMalfunctionsComponentInterface::m_cRevisionTime[] = __TIME__;

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CMalfunctionsComponentInterface::CMalfunctionsComponentInterface(
                                                  _FSI_STL::string stlStrPathName) :
                CComponentInterface(_FSI_STL::string("Malfunctions"),stlStrPathName)
{
	::CoInitialize(NULL);

    _FSI_STL::string stlStrDate(m_cRevisionDate);
    _FSI_STL::string stlStrTime(m_cRevisionTime);

    m_stlStrDate = stlStrDate + " " + stlStrTime;

    m_listPropPages.push_back(CMalfunctionsConfigPage::CreateObject);
    m_listPropPages.push_back(CMalfPreselectPage::CreateObject);
                
    m_listActions.push_back(CMalfChangeStateAction::CreateObject);
    m_listActions.push_back(CPreselectChangeStateAction::CreateObject);
    m_listActions.push_back(CMalfClearAllAction::CreateObject);
    m_listActions.push_back(CMalfClearAllPreselectsAction::CreateObject);
    m_listActions.push_back(CMalfDataAction::CreateObject);
    m_listActions.push_back(CMalfFieldAction::CreateObject);
    m_listActions.push_back(CMalfPreselectTriggerFillComboAction::CreateObject);
    m_listActions.push_back(CMalfDataMoveAction::CreateObject);
    m_listActions.push_back(CMalfSectionFieldAction::CreateObject);
    m_listActions.push_back(CMalfSectionMoveAction::CreateObject);
}

CMalfunctionsComponentInterface::~CMalfunctionsComponentInterface()
{
}

/////////////////////////////////////////////////////////////////////////////
//
// void CMalfunctionsComponentInterface::CleanComponentResources()
//
// Inputs           : None.
//
// Return Values    : None.
//
// Date             : 13 July 1999
//
// Engineer         : Billy Baker
//
// Description      : CleanComponentResources() is a common framework method
//                    used to cleanup any resources that were probably created
//                    in InitializeComponentConfig().
//
/////////////////////////////////////////////////////////////////////////////
void CMalfunctionsComponentInterface::CleanComponentResources()
{
    CComponentInterface::CleanComponentResources();

    CCommsShared::DeleteUpdateCallback(CMalfunctionSystemInterface::UpdatePreselects);

    CMalfFieldAction::m_malfunction.Clean();

	::CoUninitialize();
}

void CMalfunctionsComponentInterface::InitializeComponentConfig()
{
    CComponentInterface::InitializeComponentConfig();

    HKEY hKey;
    RegOpenKeyEx(HKEY_LOCAL_MACHINE, _T("Software\\FlightSafety\\FSISuite\\") + CString(m_stlStrComponentName.c_str()), 0, KEY_READ, &hKey);

    if (hKey != NULL)
    {
        long int lDBCount = 0;
        long int lDBStep = 1;
        unsigned long int ulData = 0;
        DWORD dwSize = sizeof (unsigned long int);
        RegQueryValueEx(hKey, _T("MalfDBCount"), NULL, NULL, (BYTE*)&ulData, 
                        &dwSize);
        lDBCount = ulData;

        CString strDBXXX;
        DWORD dwType, dwCount;
        LONG lResult;

        // Get all of the malfunction database paths.
        for (; lDBStep <= lDBCount; lDBStep++)
        {
            strDBXXX.Format("MalfDB%d",lDBStep);

		    CString strValue;
		    lResult = RegQueryValueEx(hKey, (LPCTSTR)strDBXXX, 
                                           NULL, &dwType, NULL, &dwCount);
		    if (lResult == ERROR_SUCCESS)
		    {
			    ASSERT(dwType == REG_SZ);
			    lResult = RegQueryValueEx(hKey, (LPCTSTR)strDBXXX, NULL, 
                                          &dwType,
				                (LPBYTE)strValue.GetBuffer(dwCount/sizeof(TCHAR)),
                                          &dwCount);

			    strValue.ReleaseBuffer();
		    }

            CMalfFieldAction::m_malfunction.AddDBName(_FSI_STL::string((LPCTSTR)strValue));
            if (lDBStep == 1)
            {
                CMalfFieldAction::m_malfunction.CurrentDB(_FSI_STL::string((LPCTSTR)strValue));
                CMalfFieldAction::m_malfunction.LoadData(_FSI_STL::string((LPCTSTR)strValue));
            }
        }

        RegCloseKey(hKey);
    }

    // Add the UpdatePreselects function as a callback to process preselects
    // every time new data arrives.
    CCommsShared::AddUpdateCallback(CMalfunctionSystemInterface::UpdatePreselects);
}
