/////////////////////////////////////////////////////////////////////////////
//
//           F L I G H T S A F E T Y   I N T E R N A T I O N A L
//                     Simulation Systems Division
//                      2700 North Hemlock Circle
//                     Broken Arrow, Oklahoma 74012
//                          (918) 259-4000
/////////////////////////////////////////////////////////////////////////////
//
// DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
// Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
// technical or operational data or information from automatic dissemination
// under the International Exchange Program or by other means.  This protection
// covers information required solely for administrative or operational
// purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
//
// WARNING:  This document contains technical data whose export is restricted
// by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
// Executive Order 12470.  Violation of these export control laws is subject
// to severe criminal penalties.  Dissemination of this document is controlled
// under DOD Directive 5230.25
//
/////////////////////////////////////////////////////////////////////////////
//
//
// Filename         : MalfSectionMoveAction.h
//
// Date             : 27 October 1999
//
// Engineer         : Billy Baker
//
// Revision         : $Revision: 1.2 $
//
// Description      : MalfSectionMoveAction.h contains the definition of
//                    the CMalfSectionMoveAction class.  This class is
//                    used to increment or decrement the starting value
//                    for displaying the section names from the
//                    malfunction database.  
//
// Classification   : UNCLASSIFIED
//
// Requirements     : None.
//
// Components Used  : Malfunctions::CMalfunctionsSystemInterface, 
//                    Core::CIOAction, Core::CWidget, 
//                    Malfunctions::CMalfWidgetShared, Core::CXMLWidget,
//                    CWnd, _FSI_STL::string.
//
// Operational 
//    Restrictions  : Machine dependencies/restrictions
//                        None.
//                    Design dependencies/restrictions
//                        None.
//                    Operations containing dependencies/restrictions
//                        None.
//                    Compiler dependencies/restrictions
//                        None.
//                    Other conditions for proper execution
//                        None.
//
// Environment      : Operating system(s) - Microsoft Windows NT 4.0 with
//                                              NT service pack 3, 4, or 5
//                                          Microsoft Windows NT 2000
//
//                    Compiler(s) - Visual C++ 6.0
//
//                    Architechure(s) - Intel Pentium, Pentium II
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
//                              R e v i s i o n   H i s t o r y
//
/////////////////////////////////////////////////////////////////////////////
// $Log: MalfSectionMoveAction.h $                                                                   
// Revision 1.2  2000/05/26 16:42:21  billyb                                                                   
// FIrst release after major work to get malfunctions working                                                                   
// on multiple screens and within the FSISuite framework.                                                                   
// Revision 1.1  1999/10/27 17:53:38  billyb                                                                   
// Initial Revision                                                                   
/////////////////////////////////////////////////////////////////////////////
#if !defined(_MALFSECTIONMOVEACTION_H_)
#define _MALFSECTIONMOVEACTION_H_

#include "..\core\ioaction.h"
#include "..\core\Widget.h"

#include "MalfWidgetShared.h"

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

class CMalfSectionMoveAction : public CIOAction, public CWidget, 
                               public CMalfWidgetShared  
{
public:
	CMalfSectionMoveAction();
	virtual ~CMalfSectionMoveAction();

    static CWidget* CreateObject();
    virtual void    Initialize(CXMLWidget*& rpXMLWidget, CWnd* pWnd, 
                               const long int lId, bool bEditMode);
    virtual void    ResetProperties();

    virtual enum    LButtonUpReturn OnLButtonUp();
};

#endif // !defined(_MALFSECTIONMOVEACTION_H_)
