/////////////////////////////////////////////////////////////////////////////
//
//           F L I G H T S A F E T Y   I N T E R N A T I O N A L
//                     Simulation Systems Division
//                      2700 North Hemlock Circle
//                     Broken Arrow, Oklahoma 74012
//                          (918) 259-4000
/////////////////////////////////////////////////////////////////////////////
//
// DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
// Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
// technical or operational data or information from automatic dissemination
// under the International Exchange Program or by other means.  This protection
// covers information required solely for administrative or operational
// purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
//
// WARNING:  This document contains technical data whose export is restricted
// by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
// Executive Order 12470.  Violation of these export control laws is subject
// to severe criminal penalties.  Dissemination of this document is controlled
// under DOD Directive 5230.25
//
/////////////////////////////////////////////////////////////////////////////
//
//
// Filename         : MalfSectionMoveAction.h
//
// Date             : 27 October 1999
//
// Engineer         : Billy Baker
//
// Revision         : $Revision: 1.2 $
//
// Description      : MalfSectionMoveAction.h contains the definition of
//                    the CMalfSectionMoveAction class.  This class is
//                    used to increment or decrement the starting value
//                    for displaying the section names from the
//                    malfunction database.  
//
// Classification   : UNCLASSIFIED
//
// Requirements     : None.
//
// Components Used  : Malfunctions::CMalfunctionsSystemInterface, 
//                    Core::CIOAction, Core::CWidget, 
//                    Malfunctions::CMalfWidgetShared, Core::CXMLWidget,
//                    CWnd, _FSI_STL::string.
//
// Operational 
//    Restrictions  : Machine dependencies/restrictions
//                        None.
//                    Design dependencies/restrictions
//                        None.
//                    Operations containing dependencies/restrictions
//                        None.
//                    Compiler dependencies/restrictions
//                        None.
//                    Other conditions for proper execution
//                        None.
//
// Environment      : Operating system(s) - Microsoft Windows NT 4.0 with
//                                              NT service pack 3, 4, or 5
//                                          Microsoft Windows NT 2000
//
//                    Compiler(s) - Visual C++ 6.0
//
//                    Architechure(s) - Intel Pentium, Pentium II
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
//                              R e v i s i o n   H i s t o r y
//
/////////////////////////////////////////////////////////////////////////////
// $Log: MalfSectionMoveAction.cpp $                                                                   
// Revision 1.2  2000/05/26 16:42:21  billyb                                                                   
// FIrst release after major work to get malfunctions working                                                                   
// on multiple screens and within the FSISuite framework.                                                                   
/////////////////////////////////////////////////////////////////////////////
#include "..\core\stdafx.h"
#include "MalfSectionMoveAction.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CMalfSectionMoveAction::CMalfSectionMoveAction()
{
    m_stlStrWidgetName = _FSI_STL::string("Malfunction_Section_Move");
}

CMalfSectionMoveAction::~CMalfSectionMoveAction()
{
//    m_malfunction.m_listFieldActions.clear();
}


void CMalfSectionMoveAction::Initialize(CXMLWidget*& rpXMLWidget, CWnd* pWnd, 
                                const long lId, bool bEditMode)
{
    CWidget::Initialize(rpXMLWidget,pWnd, lId, bEditMode);

    m_pAction = this;
    m_pWidget = (CWidget*)this;

    if (rpXMLWidget != NULL)
    {
        m_pIOActionXMLWidget = m_pXMLWidget;
        ResetProperties();
    }
}

CWidget* CMalfSectionMoveAction::CreateObject()
{
    return new CMalfSectionMoveAction();
}

void CMalfSectionMoveAction::ResetProperties()
{
    CWidget::ResetProperties();
    CIOAction::ResetProperties();
}

enum LButtonUpReturn CMalfSectionMoveAction::OnLButtonUp()
{
    if (m_pParentWidget == NULL)
    {
        return LBU_OK;
    }

    CVariant* pVariant = m_pParentWidget->GetValue(CString("Default"));

    if ((_FSI_STL::string)*pVariant == _FSI_STL::string("Previous"))
    {
        long lNewStart = m_malfunction.SectionStart(m_hwndMainFrame) - 
                            m_malfunction.m_mapSectionActions[m_hwndMainFrame].size();
        if (lNewStart < 0)
        {
            m_malfunction.SectionStart(m_hwndMainFrame, 0);
        }
        else
        {
            m_malfunction.SectionStart(m_hwndMainFrame, lNewStart);
        }
    }
    else
    {
        long lNewStart = m_malfunction.SectionStart(m_hwndMainFrame) + 
                            m_malfunction.m_mapSectionActions[m_hwndMainFrame].size();
        if (lNewStart < m_malfunction.SectionCount())
        {
            m_malfunction.SectionStart(m_hwndMainFrame, lNewStart);
        }
    }

    return LBU_OK;
}