// MalfSectionFieldAction.cpp: implementation of the CMalfSectionFieldAction class.
//
//////////////////////////////////////////////////////////////////////
#include "..\core\stdafx.h"
#pragma warning(disable:4503) 

#include "MalfSectionFieldAction.h"
#include "MalfSectionActionPage.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CMalfSectionFieldAction::CMalfSectionFieldAction()
{
    m_stlStrWidgetName = _FSI_STL::string("Malfunction_Section_Field");

    m_listWidgetPropPages.push_back(CMalfSectionActionPage::CreateObject);
}

CMalfSectionFieldAction::~CMalfSectionFieldAction()
{
    _FSI_STL::map<HWND, _FSI_STL::list<CAction*> >::iterator mIt;
    mIt = m_malfunction.m_mapSectionActions.find(m_hwndMainFrame);

    if (mIt != m_malfunction.m_mapSectionActions.end())
    {
        _FSI_STL::list<CAction*>::iterator lIt;
        lIt = _FSI_STL::find((*mIt).second.begin(),
                             (*mIt).second.end(), this);

        if (lIt != (*mIt).second.end())
        {
            (*mIt).second.erase(lIt);
        }
    }
}

void CMalfSectionFieldAction::Initialize(CXMLWidget*& rpXMLWidget, CWnd* pWnd, 
                                const long lId, bool bEditMode)
{
    CWidget::Initialize(rpXMLWidget,pWnd, lId, bEditMode);

    m_pAction = this;
    m_pWidget = (CWidget*)this;

    if (rpXMLWidget != NULL)
    {
        m_pIOActionXMLWidget = m_pXMLWidget;
        ResetProperties();
    }

    if (CWidget::IsValidAddress(m_pParentWidget) != INVALID)
    {
        m_hwndMainFrame = m_pParentWidget->MainFrameHwnd();
    }

    m_malfunction.m_mapSectionActions[m_hwndMainFrame].push_back(this);

    OnLoad();
}

CWidget* CMalfSectionFieldAction::CreateObject()
{
    return new CMalfSectionFieldAction();
}

void CMalfSectionFieldAction::ResetProperties()
{
    CWidget::ResetProperties();
    CIOAction::ResetProperties();
}

void CMalfSectionFieldAction::OnLoad()
{
    if (m_bEditing == true)
    {
        return;
    }

    if (m_pParentWidget == NULL)
    {
        return;
    }

    m_variant.Value(_FSI_STL::string(""));

    long lSectionStart = m_malfunction.SectionStart(m_hwndMainFrame);
    long lSectionCount = m_malfunction.SectionCount();
//    long lSectionIndex = m_lElement1D + lSectionStart;
    long lSectionIndex = m_lElement + lSectionStart;
    if (lSectionIndex < lSectionCount)
    {
        _FSI_STL::map<_FSI_STL::string, _FSI_STL::map<_FSI_STL::string, CMalfunctionData*> >::iterator mIt =
                                        m_malfunction.m_mapMalfData.begin();
        _FSI_STL::map<_FSI_STL::string, _FSI_STL::map<_FSI_STL::string, CMalfunctionData*> >::iterator mendIt =
                                        m_malfunction.m_mapMalfData.end();
        long lSectionStep = 0;

        while (mIt != mendIt && lSectionStep < lSectionIndex)
        {
            mIt++;
            lSectionStep++;
        }

        if (mIt != mendIt)
        {
            m_variant.Value(_FSI_STL::string((*mIt).first));
        }
    }

    m_ChangeValue.Variant(&m_variant);
    m_pParentWidget->ChangeValue(CString("Default"), &m_ChangeValue);
    m_pParentWidget->Wnd()->Invalidate();
}

void CMalfSectionFieldAction::OnUpdate()
{
    OnLoad();
}

enum LButtonUpReturn CMalfSectionFieldAction::OnLButtonUp()
{
    if (m_bEditing == true)
    {
        return LBU_OK;
    }

    if (m_pParentWidget == NULL)
    {
        return LBU_OK;
    }

    CVariant* pVariant = m_pParentWidget->GetValue(CString("Default"));

    m_malfunction.CurrentSet(m_hwndMainFrame, (_FSI_STL::string)*pVariant);

    return LBU_OK;
}