// MalfPreselectTriggerFillComboAction.cpp: implementation of the CMalfPreselectTriggerFillComboAction class.
//
//////////////////////////////////////////////////////////////////////
#include "..\core\stdafx.h"
#pragma warning(disable:4503) 

#include "..\general\ComboWidget.h"
#include "MalfPreselectTriggerFillAction.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CMalfPreselectTriggerFillComboAction::CMalfPreselectTriggerFillComboAction()
{
    m_stlStrWidgetName = _FSI_STL::string("Malfunction_Trigger_FillCombo");
}

CMalfPreselectTriggerFillComboAction::~CMalfPreselectTriggerFillComboAction()
{
}


void CMalfPreselectTriggerFillComboAction::Initialize(CXMLWidget*& rpXMLWidget, CWnd* pWnd, 
                                const long lId, bool bEditMode)
{
    CWidget::Initialize(rpXMLWidget,pWnd, lId, bEditMode);

    m_pAction = this;
    m_pWidget = (CWidget*)this;

    if (rpXMLWidget != NULL)
    {
        m_pIOActionXMLWidget = m_pXMLWidget;
        ResetProperties();
    }

    if (CWidget::IsValidAddress(m_pParentWidget) != INVALID)
    {
        m_hwndMainFrame = m_pParentWidget->MainFrameHwnd();
    }

    OnLoad();
}

CWidget* CMalfPreselectTriggerFillComboAction::CreateObject()
{
    return new CMalfPreselectTriggerFillComboAction();
}

void CMalfPreselectTriggerFillComboAction::ResetProperties()
{
    CWidget::ResetProperties();
    CIOAction::ResetProperties();
}

void CMalfPreselectTriggerFillComboAction::OnLoad()
{
    if (CWidget::IsValidAddress(m_pParentWidget) == INVALID)
        return;

    CComboWidget* pComboWidget = dynamic_cast<CComboWidget*>(m_pParentWidget);
    if (pComboWidget != NULL)
    {
        pComboWidget->Entries(m_malfunction.m_mapTriggerEntries);
    }
}