// MalfPreselectPage.cpp : implementation file
//

#include "..\core\stdafx.h"
#include "..\core\BasePage.h"
#include "..\core\Widget.h"
#include "..\comms\CommsShared.h"

#include <map>
#include <string>

#include "resource.h"

#include "MalfPreselectPage.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CMalfPreselectPage dialog


CMalfPreselectPage::CMalfPreselectPage() : CBasePage(CMalfPreselectPage::IDD)
{
	//{{AFX_DATA_INIT(CMalfPreselectPage)
	m_strTrigger = _T("");
	//}}AFX_DATA_INIT
    m_stlStrPageName = _FSI_STL::string("Preselect Triggers");
}

CMalfPreselectPage::~CMalfPreselectPage()
{
}


void CMalfPreselectPage::DoDataExchange(CDataExchange* pDX)
{
	CBasePage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CMalfPreselectPage)
	DDX_Control(pDX, IDC_TRIGGER_LIST, m_ctrlTriggerList);
	DDX_Text(pDX, IDC_TRIGGER_NAME, m_strTrigger);
	DDX_Control(pDX, IDC_PRESELECT_HOST_COMBO, m_ctrlHostVarCombo);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CMalfPreselectPage, CBasePage)
	//{{AFX_MSG_MAP(CMalfPreselectPage)
	ON_NOTIFY(NM_CLICK, IDC_TRIGGER_LIST, OnClickTriggerList)
	ON_BN_CLICKED(IDC_ADD_TRIGGER_BUTTON, OnAddTrigger)
	ON_BN_CLICKED(IDC_DELETE_TRIGGER_BUTTON, OnDeleteTrigger)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMalfPreselectPage message handlers
CBasePage* CMalfPreselectPage::CreateObject()
{
    return new CMalfPreselectPage;
}

void CMalfPreselectPage::SetProperties(void* pWidget)
{
    HKEY hKey;
    RegOpenKeyEx(HKEY_LOCAL_MACHINE, _T("Software\\FlightSafety\\FSISuite\\Malfunctions"), 0, KEY_READ, &hKey);
    if (hKey != NULL)
    {
        long int lMalfPreselectCount = 0;
        long int lMalfPreselectStep = 1;
        unsigned long int ulData = 0;
        DWORD dwSize = sizeof (unsigned long int);
        RegQueryValueEx(hKey, _T("MalfPreselectCount"), NULL, NULL, (BYTE*)&ulData, 
                        &dwSize);
        lMalfPreselectCount = ulData;

        CString strMalfPreselectXXX;
        CString strMalfPreselectName;
        CString strMalfPreselectHostVar;

        while(lMalfPreselectStep <= lMalfPreselectCount)
        {
            strMalfPreselectXXX.Format("MalfPreselect%d",lMalfPreselectStep);

            // Get the name of the MalfPreselect.
		    CString strValue;
		    DWORD dwType, dwCount;
		    LONG lResult = RegQueryValueEx(hKey, (LPCTSTR)strMalfPreselectXXX, 
                                           NULL, &dwType, NULL, &dwCount);
		    if (lResult == ERROR_SUCCESS)
		    {
			    ASSERT(dwType == REG_SZ);
			    lResult = RegQueryValueEx(hKey, (LPCTSTR)strMalfPreselectXXX, 
                                          NULL, &dwType,
				             (LPBYTE)strValue.GetBuffer(dwCount/sizeof(TCHAR)),
                                          &dwCount);

			    strValue.ReleaseBuffer();
		    }

            strMalfPreselectName = strValue;

            // Get the RGB for the MalfPreselect
            if (strMalfPreselectName != "")
            {
                // Code copied from GetProfileString() in CWinApp 
                // implementation.
		        lResult = RegQueryValueEx(hKey, (LPCTSTR)strMalfPreselectName, 
                                               NULL, &dwType, NULL, &dwCount);
		        if (lResult == ERROR_SUCCESS)
		        {
			        ASSERT(dwType == REG_SZ);
			        lResult = RegQueryValueEx(hKey, (LPCTSTR)strMalfPreselectName, 
                                              NULL, &dwType,
				             (LPBYTE)strValue.GetBuffer(dwCount/sizeof(TCHAR)),
                                              &dwCount);

			        strValue.ReleaseBuffer();
		        }

                strMalfPreselectHostVar = strValue;

                m_mapParameters[(LPCTSTR)strMalfPreselectName] = 
                                        _FSI_STL::string((LPCTSTR)strMalfPreselectHostVar);
            }

            ++lMalfPreselectStep;

        }

        RegCloseKey(hKey);
    }
}

void CMalfPreselectPage::UpdateProperties(void* pWidget)
{
    if (GetSafeHwnd() == NULL)
    {
        return;
    }

    HKEY hKey;
    DWORD dw;
    RegCreateKeyEx(HKEY_LOCAL_MACHINE, _T("Software\\FlightSafety\\FSISuite\\Malfunctions"), 
                 0, NULL, REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, NULL, &hKey, &dw);

    if (hKey != NULL)
    {
        UpdateData(TRUE);
        long int lMalfPreselectCount = m_ctrlTriggerList.GetItemCount();
        long int lMalfPreselectStep = 0;
        unsigned long int ulData = lMalfPreselectCount;
        DWORD dwSize = sizeof (unsigned long int);
        RegSetValueEx(hKey, _T("MalfPreselectCount"), NULL, REG_DWORD, (BYTE*)&ulData, 
                        dwSize);

        CString strMalfPreselectXXX;
        CString strMalfPreselectHostVar;
        CString strMalfPreselectName;

        while(lMalfPreselectStep < lMalfPreselectCount)
        {
            strMalfPreselectXXX.Format("MalfPreselect%d",lMalfPreselectStep+1);
            strMalfPreselectName = m_ctrlTriggerList.GetItemText(lMalfPreselectStep,0);

            RegSetValueEx(hKey, (LPCTSTR)strMalfPreselectXXX, NULL, REG_SZ, 
                            (BYTE*)(LPCTSTR)strMalfPreselectName, 
                            strMalfPreselectName.GetLength() + 1);

            strMalfPreselectHostVar = m_ctrlTriggerList.GetItemText(lMalfPreselectStep,1);

            RegSetValueEx(hKey, (LPCTSTR)strMalfPreselectName, NULL, REG_SZ, 
                            (BYTE*)(LPCTSTR)strMalfPreselectHostVar, 
                            strMalfPreselectHostVar.GetLength() + 1);

            ++lMalfPreselectStep;
        }

        RegCloseKey(hKey);
    }
}

BOOL CMalfPreselectPage::OnInitDialog() 
{
	CBasePage::OnInitDialog();

    m_ctrlTriggerList.SetExtendedStyle(m_ctrlTriggerList.GetExtendedStyle() & 
                                         LVS_EX_FULLROWSELECT);

    m_ctrlTriggerList.InsertColumn(0,"Trigger", LVCFMT_LEFT, 100);
    m_ctrlTriggerList.InsertColumn(1, "Host Var", LVCFMT_LEFT, 170);
	
	// TODO: Add extra initialization here

    STRING2STRING_MAP::iterator mIt = m_mapParameters.begin();
    long int lTriggerStep = 0;
    while(mIt != m_mapParameters.end())
    {
        m_ctrlTriggerList.InsertItem(lTriggerStep, (*mIt).first.c_str());
        m_ctrlTriggerList.SetItemText(lTriggerStep, 1, (*mIt).second.c_str());

        ++mIt;

        ++lTriggerStep;
    }

    m_ctrlHostVarCombo.ResetContent();

    // Attempt to fill in the variables from the comms system.
    if (CCommsShared::m_pCommsSystemInterface != NULL)
    {
        _FSI_STL::map<_FSI_STL::string,  CVariableData*>::iterator mIt;
        mIt = CCommsShared::m_pCommsSystemInterface->m_mapVarName2Data.begin();
        _FSI_STL::map<_FSI_STL::string,  CVariableData*>::iterator mendIt;
        mendIt = CCommsShared::m_pCommsSystemInterface->m_mapVarName2Data.end();

        // Fill the combobox with the variables from the current 
        // CCommsSystemInterface derived class.
        while (mIt != mendIt)
        {
            m_ctrlHostVarCombo.AddString(CString((*mIt).first.c_str()));

            ++mIt;
        }
    }

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CMalfPreselectPage::OnClickTriggerList(NMHDR* pNMHDR, LRESULT* pResult) 
{
	UpdateData(TRUE);
    POSITION pos = m_ctrlTriggerList.GetFirstSelectedItemPosition();
    if (pos != NULL)
    {
        long int lSelectedIndex = m_ctrlTriggerList.GetNextSelectedItem(pos);
        CString strTriggerName = m_ctrlTriggerList.GetItemText(lSelectedIndex, 0);


        m_strTrigger = strTriggerName; 

        CString strHostVar = m_ctrlTriggerList.GetItemText(lSelectedIndex, 1);

        m_ctrlHostVarCombo.SelectString(-1, strHostVar);

        UpdateData(FALSE);
    }

	
	*pResult = 0;
}

void CMalfPreselectPage::OnAddTrigger() 
{
    UpdateData(TRUE);
    
    if (m_strTrigger.GetLength() > 0)
    {
        LVFINDINFO lvfi;
        lvfi.flags = LVFI_STRING;
        lvfi.psz = (LPCTSTR)m_strTrigger;
        if (m_ctrlTriggerList.FindItem(&lvfi,-1) == -1)
        {
            long int lItemCount = m_ctrlTriggerList.GetItemCount();
            lItemCount = m_ctrlTriggerList.InsertItem(lItemCount, 
													(LPCTSTR)m_strTrigger);

            CString strValue("");

            if (m_ctrlHostVarCombo.GetCurSel() != CB_ERR)
            {
                m_ctrlHostVarCombo.GetLBText(m_ctrlHostVarCombo.GetCurSel(),strValue); 
            }

            m_ctrlTriggerList.SetItemText(lItemCount, 1, strValue);
        }
        else
        {
            ::MessageBox(GetSafeHwnd(), 
                         _T("Duplicate string encountered for trigger name."),
                         _T("Error"), 
                         MB_OK);
        }
    }
    else
    {
        ::MessageBox(GetSafeHwnd(),
                     _T("Null string encountered for trigger name."),
                     _T("Error"),
                     MB_OK);
    }
}

void CMalfPreselectPage::OnDeleteTrigger() 
{
    UpdateData(TRUE);

    if (m_strTrigger.GetLength() > 0)
    {
        LVFINDINFO lvfi;
        lvfi.flags = LVFI_STRING;
        lvfi.psz = (LPCTSTR)m_strTrigger;
        long int lTriggerIndex = m_ctrlTriggerList.FindItem(&lvfi,-1);
        if (lTriggerIndex > -1)
        {
            m_ctrlTriggerList.DeleteItem(lTriggerIndex);
        }
        else
        {
            ::MessageBox(GetSafeHwnd(), 
                         _T("Trigger name could not be found to delete name "
                            "and host var name."),
                         _T("Error"), 
                         MB_OK);
            return;
        }
    }
    else
    {
        ::MessageBox(GetSafeHwnd(),
                     _T("Null string encountered for trigger name."),
                     _T("Error"),
                     MB_OK);
    }
}
