// MalfFieldActionPage.cpp: implementation of the CMalfFieldActionPage class.
//
//////////////////////////////////////////////////////////////////////

#include "..\core\stdafx.h"
#include "MalfFieldActionPage.h"

#include "MalfFieldAction.h"

#include "..\core\Widget.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CMalfFieldActionPage::CMalfFieldActionPage()
{
	//{{AFX_DATA_INIT(CMalfFieldActionPage)
	//}}AFX_DATA_INIT
    m_stlStrPageName = _FSI_STL::string("Malfunction Field Action");
    m_psp.dwFlags |= PSP_USETITLE;
    m_psp.pszTitle = _T("Malfunction Field Action");

}

CMalfFieldActionPage::~CMalfFieldActionPage()
{

}

BEGIN_MESSAGE_MAP(CMalfFieldActionPage, CIOActionPage)
	//{{AFX_MSG_MAP(CMalfFieldActionPage)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMalfFieldActionPage message handlers
CBasePage* CMalfFieldActionPage::CreateObject()
{
    return new CMalfFieldActionPage;
}

BOOL CMalfFieldActionPage::OnInitDialog() 
{
	CIOActionPage::OnInitDialog();
	
    m_ctrlVariableList.ResetContent();
    _FSI_STL::map<_FSI_STL::string,  void*>::iterator mIt;
    mIt = CMalfFieldAction::m_malfunction.m_mapMalfFields.begin();
    _FSI_STL::map<_FSI_STL::string,  void*>::iterator mendIt;
    mendIt = CMalfFieldAction::m_malfunction.m_mapMalfFields.end();

    while (mIt != mendIt)
    {
        m_ctrlVariableList.AddString(CString((*mIt).first.c_str()));

        mIt++;
    }

    m_ctrlVariableList.SelectString(-1, m_strCommVariable);

    CWnd* pWnd = GetDlgItem(IDC_ENTIRE_ARRAY);
    if (pWnd != NULL)
    {
        pWnd->ShowWindow(SW_HIDE);
    }

/*    pWnd = GetDlgItem(IDC_ENTIRE_2D);
    if (pWnd != NULL)
    {
        pWnd->ShowWindow(SW_HIDE);
    }

    pWnd = GetDlgItem(IDC_2D_INDEX_EDIT);
    if (pWnd != NULL)
    {
        pWnd->ShowWindow(SW_HIDE);
    }
*/
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

