// MalfFieldAction.cpp: implementation of the CMalfFieldAction class.
//
//////////////////////////////////////////////////////////////////////
#include "..\core\stdafx.h"
#pragma warning(disable:4503) 

#include "MalfunctionData.h"
#include "MalfFieldAction.h"
#include "MalfFieldActionPage.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CMalfFieldAction::CMalfFieldAction()
{
    m_stlStrWidgetName = _FSI_STL::string("Malfunction_Data_Field");

    m_listWidgetPropPages.push_back(CMalfFieldActionPage::CreateObject);
}

CMalfFieldAction::~CMalfFieldAction()
{
    // Find where the address of this instance is stored in
    // the m_mapFieldActions data structure.  If found, then
    // remove it.
    _FSI_STL::map<HWND, _FSI_STL::list<CAction*> >::iterator mIt;
    mIt = m_malfunction.m_mapFieldActions.find(m_hwndMainFrame);
    if (mIt != m_malfunction.m_mapFieldActions.end())
    {
        // The screen that this field action is on does have
        // a list of field action pointers.
        _FSI_STL::list<CAction*>::iterator lIt;
        lIt = _FSI_STL::find((*mIt).second.begin(),
                             (*mIt).second.end(), this);

        if (lIt != (*mIt).second.end())
        {
            // The address of this instance was found and is
            // removed.
            (*mIt).second.erase(lIt);
        }
    }

}

void CMalfFieldAction::Initialize(CXMLWidget*& rpXMLWidget, CWnd* pWnd, 
                                const long lId, bool bEditMode)
{
    CWidget::Initialize(rpXMLWidget,pWnd, lId, bEditMode);

    m_pAction = this;
    m_pWidget = (CWidget*)this;

    if (rpXMLWidget != NULL)
    {
        m_pIOActionXMLWidget = m_pXMLWidget;
        ResetProperties();
    }

    if (CWidget::IsValidAddress(m_pParentWidget) != INVALID)
    {
        m_hwndMainFrame = m_pParentWidget->MainFrameHwnd();
    }

    m_malfunction.m_mapFieldActions[m_hwndMainFrame].push_back(this);

    OnLoad();
}

CWidget* CMalfFieldAction::CreateObject()
{
    return new CMalfFieldAction();
}

void CMalfFieldAction::ResetProperties()
{
    CWidget::ResetProperties();
    CIOAction::ResetProperties();
}

void CMalfFieldAction::OnLoad()
{
    if (m_pParentWidget == NULL)
    {
        return;
    }

    // Make sure that the last selected set/section has data.  If none or not 
    // found, then just return.
    if (m_malfunction.m_mapMalfData.find(m_malfunction.LastSelectedSet(m_hwndMainFrame)) ==
        m_malfunction.m_mapMalfData.end())
    {
        return;
    }

    // Check to see if there was a malfunction selected for which field data 
    // can be displayed.
    if ((m_malfunction.m_mapMalfData[m_malfunction.LastSelectedSet(m_hwndMainFrame)]).find(m_malfunction.CurrentMalfunction(m_hwndMainFrame)) ==
        (m_malfunction.m_mapMalfData[m_malfunction.LastSelectedSet(m_hwndMainFrame)]).end())
    {
        return;
    }

    // Get a pointer to the malfunction data from the DB.
    CMalfunctionData* pData = (m_malfunction.m_mapMalfData[m_malfunction.LastSelectedSet(m_hwndMainFrame)])[m_malfunction.CurrentMalfunction(m_hwndMainFrame)];
    if (pData != NULL)
    {
        // m_stlStrVariableToWatch has the name of a field (desc, malf label, title, etc).
        m_variant.Value(pData->GetData(m_stlStrVariableToWatch));
    }
    else
    {
        m_variant.Value(_FSI_STL::string(""));
    }

    m_ChangeValue.Variant(&m_variant);
    m_pParentWidget->ChangeValue(CString(m_stlStrElementVar.c_str()),
                                 &m_ChangeValue);
    m_pParentWidget->Wnd()->Invalidate();
}

void CMalfFieldAction::OnUpdate()
{
    // Usually called when a malf button is selected to show the
    // description for the malf.
    OnLoad();
}

