// MalfDataMoveAction.cpp: implementation of the CMalfDataMoveAction class.
//
//////////////////////////////////////////////////////////////////////
#include "..\core\stdafx.h"
#include "MalfDataMoveAction.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CMalfDataMoveAction::CMalfDataMoveAction()
{
    m_stlStrWidgetName = _FSI_STL::string("Malfunction_Data_Move");
}

CMalfDataMoveAction::~CMalfDataMoveAction()
{
}

void CMalfDataMoveAction::Initialize(CXMLWidget*& rpXMLWidget, CWnd* pWnd, 
                                const long lId, bool bEditMode)
{
    CWidget::Initialize(rpXMLWidget,pWnd, lId, bEditMode);

    m_pAction = this;
    m_pWidget = (CWidget*)this;

    if (rpXMLWidget != NULL)
    {
        m_pIOActionXMLWidget = m_pXMLWidget;
        ResetProperties();
    }
}

CWidget* CMalfDataMoveAction::CreateObject()
{
    return new CMalfDataMoveAction();
}

void CMalfDataMoveAction::ResetProperties()
{
    CWidget::ResetProperties();
    CIOAction::ResetProperties();
}

enum LButtonUpReturn CMalfDataMoveAction::OnLButtonUp()
{
    if (m_pParentWidget == NULL)
    {
        return LBU_OK;
    }

    if (m_malfunction.m_mapDataActions.find(m_hwndMainFrame) ==
        m_malfunction.m_mapDataActions.end())
    {
        return LBU_OK;
    }

    CVariant* pVariant = m_pParentWidget->GetValue(CString("Default"));

    if ((_FSI_STL::string)*pVariant == _FSI_STL::string("Previous"))
    {
        long lNewStart = m_malfunction.MalfStart(m_hwndMainFrame) - 
                                m_malfunction.m_mapDataActions[m_hwndMainFrame].size();
        if (lNewStart < 0)
        {
            m_malfunction.MalfStart(m_hwndMainFrame, 0);
        }
        else
        {
            m_malfunction.MalfStart(m_hwndMainFrame, lNewStart);
        }
    }
    else
    {
        long lNewStart = m_malfunction.MalfStart(m_hwndMainFrame) + 
                                m_malfunction.m_mapDataActions[m_hwndMainFrame].size();
        if (lNewStart < m_malfunction.MalfCount(m_hwndMainFrame))
        {
            m_malfunction.MalfStart(m_hwndMainFrame, lNewStart);
        }
    }

    return LBU_OK;
}