// MalfDataAction.h: interface for the CMalfDataAction class.
//
//////////////////////////////////////////////////////////////////////
#if !defined(_MALFDATAACTION_H_)
#define _MALFDATAACTION_H_

#include "..\core\ioaction.h"
#include "..\core\Widget.h"

#include "MalfunctionData.h"
#include "MalfWidgetShared.h"

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000


class CMalfDataAction : public CIOAction, public CWidget, 
                                public CMalfWidgetShared  
{
protected:
    CMalfunctionData    m_malfData;

public:
	CMalfDataAction();
	virtual ~CMalfDataAction();

    virtual void Initialize(CXMLWidget*& rpXMLWidget, CWnd* pWnd, 
                            const long int lId, bool bEditMode);
    virtual void ResetProperties();
    static CWidget* CreateObject();

	virtual void OnLoad();
    virtual void OnUpdate();
    virtual enum LButtonUpReturn OnLButtonUp();
};

#endif // !defined(_MALFDATAACTION_H_)
