// MalfDataAction.cpp: implementation of the CMalfDataAction class.
//
//////////////////////////////////////////////////////////////////////
#include "..\core\stdafx.h"
#pragma warning(disable:4503) 

#include "MalfCommsAction.h"
#include "MalfDataAction.h"
#include "MalfDataActionPage.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CMalfDataAction::CMalfDataAction()
{
    m_stlStrWidgetName = _FSI_STL::string("Malfunction_Data");

    m_listWidgetPropPages.push_back(CMalfDataActionPage::CreateObject);
}

CMalfDataAction::~CMalfDataAction()
{
    _FSI_STL::map<HWND, _FSI_STL::list<CAction*> >::iterator mIt;
    mIt = m_malfunction.m_mapDataActions.find(m_hwndMainFrame);
    if (mIt != m_malfunction.m_mapDataActions.end())
    {
        _FSI_STL::list<CAction*>::iterator lIt;
        lIt = _FSI_STL::find((*mIt).second.begin(),
                             (*mIt).second.end(), this);

        if (lIt != (*mIt).second.end())
        {
            (*mIt).second.erase(lIt);
        }
    }

    _FSI_STL::string stlStrLabel = m_malfData.GetData(_FSI_STL::string("mfLabel"));
    if (m_malfunction.m_mapCommsActions.find(stlStrLabel) !=
        m_malfunction.m_mapCommsActions.end())
    {
        CWidget* pWidget = dynamic_cast<CWidget*>(m_malfunction.m_mapCommsActions[stlStrLabel]);
        if (pWidget != NULL)
        {
            if (CWidget::IsValidAddress(pWidget) != INVALID)
            {
                m_malfunction.m_mapCommsActions[stlStrLabel]->DeleteMalfButton(m_pParentWidget);
            }
        }
    }
}

void CMalfDataAction::Initialize(CXMLWidget*& rpXMLWidget, CWnd* pWnd, 
                                const long lId, bool bEditMode)
{
    CWidget::Initialize(rpXMLWidget,pWnd, lId, bEditMode);

    m_pAction = this;
    m_pWidget = (CWidget*)this;

    if (rpXMLWidget != NULL)
    {
        m_pIOActionXMLWidget = m_pXMLWidget;
        ResetProperties();
    }

    if (CWidget::IsValidAddress(m_pParentWidget) != INVALID)
    {
        m_hwndMainFrame = m_pParentWidget->MainFrameHwnd();
    }

    m_malfunction.m_mapDataActions[m_hwndMainFrame].push_back(this);

    OnLoad();
}

CWidget* CMalfDataAction::CreateObject()
{
    return new CMalfDataAction();
}

void CMalfDataAction::ResetProperties()
{
    CWidget::ResetProperties();
    CIOAction::ResetProperties();
}

void CMalfDataAction::OnLoad()
{
    if (m_bEditing == true)
    {
        return;
    }

    if (m_pParentWidget == NULL)
    {
        return;
    }

    if (m_malfunction.m_mapMalfData.find(m_malfunction.CurrentSet(m_hwndMainFrame)) ==
        m_malfunction.m_mapMalfData.end())
    {
        return;
    }

    m_variant.Value(_FSI_STL::string(""));

    _FSI_STL::string stlStrLabel = m_malfData.GetData(_FSI_STL::string("mfLabel"));
    if (m_malfunction.m_mapCommsActions.find(stlStrLabel) !=
        m_malfunction.m_mapCommsActions.end())
    {
        // Data action was on a button for say and engine malf.  The set/section
        // changed to say comm and the button needs to be removed from the
        // engine malf comms action.
        m_malfunction.m_mapCommsActions[stlStrLabel]->DeleteMalfButton(m_pParentWidget);
    }

    long lMalfStart = m_malfunction.MalfStart(m_hwndMainFrame);
    long lMalfCount = m_malfunction.MalfCount(m_hwndMainFrame);
    long lMalfIndex = m_lElement + lMalfStart;
    if (lMalfIndex < lMalfCount)
    {
        _FSI_STL::map<_FSI_STL::string, CMalfunctionData*> m_mapSection;
        _FSI_STL::map<_FSI_STL::string, CMalfunctionData*>::iterator mIt = NULL;
        _FSI_STL::map<_FSI_STL::string, CMalfunctionData*>::iterator mendIt = NULL;
        m_mapSection = m_malfunction.m_mapMalfData[m_malfunction.CurrentSet(m_hwndMainFrame)];
        mIt = m_mapSection.begin();
        mendIt = m_mapSection.end();
        long lMalfStep = 0;
        // Walk the data for the current set to get the data for the lMalfIndex malfunction.
        while (mIt != mendIt && lMalfStep < lMalfIndex)
        {
            mIt++;
            lMalfStep++;
        }

        if (mIt != mendIt)
        {
            // Set the data for the current malfunction.
            m_malfData = *((*mIt).second);

            // Set the name of the malfunctoin.
            m_variant.Value((*mIt).first);

            // If the label has a comms action, add the parent button to get updates.
            _FSI_STL::string stlStrLabel = m_malfData.GetData(_FSI_STL::string("mfLabel"));
            if (m_malfunction.m_mapCommsActions.find(stlStrLabel) !=
                m_malfunction.m_mapCommsActions.end())
            {
                m_malfunction.m_mapCommsActions[stlStrLabel]->AddMalfButton(m_pParentWidget);
            }
        }
    }

    m_ChangeValue.Variant(&m_variant);
    m_pParentWidget->ChangeValue(CString("Default"), &m_ChangeValue);
    m_pParentWidget->Wnd()->Invalidate();
}

void CMalfDataAction::OnUpdate()
{
    OnLoad();
}

enum LButtonUpReturn CMalfDataAction::OnLButtonUp()
{
    if (m_bEditing == true)
    {
        return LBU_OK;
    }

    if (m_pParentWidget == NULL)
    {
        return LBU_OK;
    }

    CVariant* pVariant = m_pParentWidget->GetValue(CString("Default"));

    m_malfunction.CurrentMalfunction(m_hwndMainFrame, (_FSI_STL::string)*pVariant);

    _FSI_STL::string stlStrLabel = m_malfData.GetData(_FSI_STL::string("mfLabel"));
    if (m_malfunction.m_mapCommsActions.find(stlStrLabel) !=
        m_malfunction.m_mapCommsActions.end())
    {
        CWidget* pWidget = dynamic_cast<CWidget*>(m_malfunction.m_mapCommsActions[stlStrLabel]);
        if (pWidget != NULL)
        {
            if (CWidget::IsValidAddress(pWidget) != INVALID)
            {
                m_malfunction.m_mapCommsActions[stlStrLabel]->UpdateStateOnButtonChange();
            }
        }
    }

    return LBU_OK;
}