/////////////////////////////////////////////////////////////////////////////
//
//           F L I G H T S A F E T Y   I N T E R N A T I O N A L
//                     Simulation Systems Division
//                      2700 North Hemlock Circle
//                     Broken Arrow, Oklahoma 74012
//                          (918) 259-4000
/////////////////////////////////////////////////////////////////////////////
//
// DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
// Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
// technical or operational data or information from automatic dissemination
// under the International Exchange Program or by other means.  This protection
// covers information required solely for administrative or operational
// purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
//
// WARNING:  This document contains technical data whose export is restricted
// by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
// Executive Order 12470.  Violation of these export control laws is subject
// to severe criminal penalties.  Dissemination of this document is controlled
// under DOD Directive 5230.25
//
/////////////////////////////////////////////////////////////////////////////
//
//
// Filename         : MalfCommsAction.h
//
// Date             : 08 February 1999
//
// Engineer         : Billy Baker
//
// Revision         : $Revision: 1.3 $
//
// Description      : MalfCommsAction.h contains the definition of the 
//                    CMalfCommsAction class.  This action is derived from 
//                    Core::CIOAction.  Its purpose is to distribute a 
//                    value to a graphical element in its OnUpdate 
//                    member.  This member is called from 
//                    CCommsSystemInterface::UpdateComms().  
//                    CCommsSystemInterface keeps track of all 
//                    CMalfCommsAction instances so that it may update all 
//                    of them.  Each CMalfCommsAction instance shares a 
//                    single CVariant instance.  Thus, many graphical 
//                    elements may want the value of a variable and 
//                    each graphical element will have an instance of a 
//                    CMalfCommsAction to read that variable.  However, the 
//                    value will be read from simulation once and 
//                    placed in the shared CVariant.  CMalfCommsAction will 
//                    also update simulation variables in OnLButtonUp.  
//                    This member will be called whenever an action 
//                    occurs on a graphical element.  The action might 
//                    be clicking a button or pressing the 
//                    enter/carriage return key while in an editbox.
//
// Classification   : UNCLASSIFIED
//
// Requirements     : None.
//
// Components Used  : Core::CIOAction, Core::CWidget, Comms::CCommsShared, 
//                    Core::CVariant, _FSI_STL::string, _FSI_STL::list, _FSI_STL::map, 
//                    _FSI_STL::vector, Comms::CCommsSystemInterface, 
//                    Core::CChangeValue, Core::CRange.
//
// Operational 
//    Restrictions  : Machine dependencies/restrictions
//                        None.
//                    Design dependencies/restrictions
//                        None.
//                    Operations containing dependencies/restrictions
//                        None.
//                    Compiler dependencies/restrictions
//                        None.
//                    Other conditions for proper execution
//                        None.
//
// Environment      : Operating system(s) - Microsoft Windows NT 4.0 with
//                                              NT service pack 4
//                                          Microsoft Windows NT 2000
//
//                    Compiler(s) - Visual C++ 6.0
//
//                    Architechure(s) - Intel Pentium, Pentium II
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
//                              R e v i s i o n   H i s t o r y
//
/////////////////////////////////////////////////////////////////////////////
// $Log: MalfCommsAction.h $
// Revision 1.3  2000/05/26 16:42:13  billyb
// FIrst release after major work to get malfunctions working
// on multiple screens and within the FSISuite framework.
// Revision 1.2  1999/10/20 18:49:02  billyb
// Changed OnLButtonUp to return an enum.
/////////////////////////////////////////////////////////////////////////////
#if !defined(_MALFCOMMSACTION_H_)
#define _MALFCOMMSACTION_H_

#ifdef MALFUNCTION
#define MALFUNCTIONAPI __declspec( dllexport )
#else
#define MALFUNCTIONAPI __declspec( dllimport )
#endif

#include "..\comms\CommsAction.h"
#include "MalfWidgetShared.h"

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

class MALFUNCTIONAPI CMalfCommsAction : public CCommsAction, public CMalfWidgetShared
{
protected:
    int                         m_nSizeMalfButtons;
    _FSI_STL::string            m_stlStrTitle;
    _FSI_STL::list<CWidget*>    m_listMalfButtons;
    CCriticalSection            m_syncMalfButtons;
    bool                        m_bShowAsPreselect;
    bool                        m_bDoNotShowAsPreselect;

public:
	CMalfCommsAction();
	virtual ~CMalfCommsAction();

    // Common methods for creating a CWidget derived class.
    virtual void Initialize(CXMLWidget*& rpXMLWidget, CWnd* pWnd, 
                            const long int lId, bool bEditMode);
    static CWidget* CreateObject();

	virtual void OnUpdate();
	virtual enum LButtonUpReturn OnLButtonUp();

    _FSI_STL::string MalfTitle();

    void MalfTitle(_FSI_STL::string& stlStrTitle);
    void AddVariable(_FSI_STL::string& stlStrVariable);

    void AddMalfButton(const CWidget* pWidget);
    void DeleteMalfButton(const CWidget* pWidget);

    void ClearMalf();

    void UpdateStateOnButtonChange();

    void ShowAsPreselect(bool bShow);
    void DoNotShowAsPreselect(bool bShow);
};

#endif // !defined(_MALFCOMMSACTION_H_)
