/////////////////////////////////////////////////////////////////////////////
//
//           F L I G H T S A F E T Y   I N T E R N A T I O N A L
//                     Simulation Systems Division
//                      2700 North Hemlock Circle
//                     Broken Arrow, Oklahoma 74012
//                          (918) 259-4000
/////////////////////////////////////////////////////////////////////////////
//
// DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
// Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
// technical or operational data or information from automatic dissemination
// under the International Exchange Program or by other means.  This protection
// covers information required solely for administrative or operational
// purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
//
// WARNING:  This document contains technical data whose export is restricted
// by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
// Executive Order 12470.  Violation of these export control laws is subject
// to severe criminal penalties.  Dissemination of this document is controlled
// under DOD Directive 5230.25
//
/////////////////////////////////////////////////////////////////////////////
//
//
// Filename         : MalfCommsAction.cpp
//
// Date             : 08 February 1999
//
// Engineer         : Billy Baker
//
// Revision         : $Revision: 1.4 $
//
// Description      : MalfCommsAction.cpp contains the implementation of the 
//                    CMalfCommsAction class.  This action is derived from 
//                    Core::CIOAction.  Its purpose is to distribute a 
//                    value to a graphical element in its OnUpdate 
//                    member.  This member is called from 
//                    CCommsSystemInterface::UpdateComms().  
//                    CCommsSystemInterface keeps track of all 
//                    CMalfCommsAction instances so that it may update all 
//                    of them.  Each CMalfCommsAction instance shares a 
//                    single CVariant instance.  Thus, many graphical 
//                    elements may want the value of a variable and 
//                    each graphical element will have an instance of a 
//                    CMalfCommsAction to read that variable.  However, the 
//                    value will be read from simulation once and 
//                    placed in the shared CVariant.  CMalfCommsAction will 
//                    also update simulation variable in OnLButtonUp.  
//                    This member will be called whenever an action 
//                    occurs on a graphical element.  The action might 
//                    be clicking a button or pressing the 
//                    enter/carriage return key while in an editbox.
//
// Classification   : UNCLASSIFIED
//
// Requirements     : None.
//
// Components Used  : Core::CIOAction, Core::CWidget, Comms::CCommsShared, 
//                    Core::CVariant, _FSI_STL::string, _FSI_STL::list, _FSI_STL::map, 
//                    _FSI_STL::vector, Comms::CCommsSystemInterface, 
//                    Core::CChangeValue, Core::CRange.
//
// Operational 
//    Restrictions  : Machine dependencies/restrictions
//                        None.
//                    Design dependencies/restrictions
//                        None.
//                    Operations containing dependencies/restrictions
//                        None.
//                    Compiler dependencies/restrictions
//                        None.
//                    Other conditions for proper execution
//                        None.
//
// Environment      : Operating system(s) - Microsoft Windows NT 4.0 with
//                                              NT service pack 4
//                                          Microsoft Windows NT 2000
//
//                    Compiler(s) - Visual C++ 6.0
//
//                    Architechure(s) - Intel Pentium, Pentium II
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
//                              R e v i s i o n   H i s t o r y
//
/////////////////////////////////////////////////////////////////////////////
// $Log: MalfCommsAction.cpp $
// Revision 1.4  2000/06/08 06:43:42  billyb
// Removed unneeded lock.  Restructured code in OnUpdate.
// Revision 1.3  2000/05/26 16:42:13  billyb
// FIrst release after major work to get malfunctions working
// on multiple screens and within the FSISuite framework.
// Revision 1.2  1999/10/20 18:49:01  billyb
// Changed OnLButtonUp to return an enum.
/////////////////////////////////////////////////////////////////////////////
#include "..\core\stdafx.h"
#include "MalfCommsAction.h"

#include "MalfCommsActionPage.h"
#include "..\core\RangePage.h"

#include <algorithm>

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

/////////////////////////////////////////////////////////////////////////////
//
// CCommsACtion::CMalfCommsAction
//
// Inputs           : None.
//
// Return Values    : None.
//
// Date             : 08 February 1999
//
// Engineer         : Billy Baker
//
// Description      : Default constructor.  Sets the name of the widget.
//                    Adds the CMalfCommsActionPage to the list of widget
//                    property pages.
/////////////////////////////////////////////////////////////////////////////
CMalfCommsAction::CMalfCommsAction() : m_bShowAsPreselect(false), 
                                       m_bDoNotShowAsPreselect(false),
                                       m_nSizeMalfButtons(0)
{
    m_stlStrWidgetName = _FSI_STL::string("Malf_Comms");
    m_listWidgetPropPages.push_back(CMalfCommsActionPage::CreateObject);
    m_listWidgetPropPages.push_back(CRangePage::CreateObject);

    m_bFirstDelete = true;
    m_bInitialized = false;
}

/////////////////////////////////////////////////////////////////////////////
//
// CCommsACtion::~CMalfCommsAction
//
// Inputs           : None.
//
// Return Values    : None.
//
// Date             : 08 February 1999
//
// Engineer         : Billy Baker
//
// Description      : Default destructor.  If a CCommsSystemInterface derived
//                    class has been instaniated, then an attempt is made to
//                    remove this instance of CMalfCommsAction from the list of
//                    CMalfCommsAction instances managed by the 
//                    CCommsSystemInterface derived class.
//
/////////////////////////////////////////////////////////////////////////////
CMalfCommsAction::~CMalfCommsAction()
{
}

/////////////////////////////////////////////////////////////////////////////
//
// void CCommsACtion::Initialize()
//
// Inputs           : CXMLWidget*& rpXMLWidget - pointer to return a new 
//                                               instance of a CXMLWidget.
//                    CWnd* pWnd - the parent of this widget.
//                    const long lId - the control ID.
//                    bool bEditMode - whether this widget is being created 
//                                     in the editor or the runtime.
//
// Return Values    : None.
//
// Date             : 08 February 1999
//
// Engineer         : Billy Baker
//
// Description      : Initialize() is a common framework method that must be
//                    implemented by each CWidget derived class.  Besides 
//                    standard initialization code for a CAction and CWidget
//                    derived class, the CCommsSystemInterface derived class
//                    is started if it has not already been started. 
//
/////////////////////////////////////////////////////////////////////////////
void CMalfCommsAction::Initialize(CXMLWidget*& rpXMLWidget, CWnd* pWnd, 
                                const long lId, bool bEditMode)
{
    if (m_pCommsSystemInterface != NULL && lId != 0)
    {
        // Start comms if it hasn't been started and we're not editing.
        if (m_pCommsSystemInterface->Started() == false && m_bEditing == false)
        {
            m_pCommsSystemInterface->Start();
        }
    }

    // Call the base class.
    CWidget::Initialize(rpXMLWidget,pWnd, lId, bEditMode);

    // Set the action and widget pointers.
    m_pAction = this;
    m_pWidget = (CWidget*)this;

    if (rpXMLWidget != NULL)
    {
        m_pIOActionXMLWidget = m_pXMLWidget;
        ResetProperties();
    }

    m_bInitialized = true;
}

/////////////////////////////////////////////////////////////////////////////
//
// CWidget* CCommsACtion::CreateObject()
//
// Inputs           : None.
//
// Return Values    : Address of a new instance of CMalfCommsAction.
//
// Date             : 08 February 1999
//
// Engineer         : Billy Baker
//
// Description      : CreateObject() is a common framework method that must be
//                    implemented by each CWidget derived class.  The main
//                    application associates the name of this widget with this
//                    static CreateObject method so that a new object can be
//                    created without linking against the library that contains
//                    this class.
//
/////////////////////////////////////////////////////////////////////////////
CWidget* CMalfCommsAction::CreateObject()
{
    return new CMalfCommsAction();
}

/////////////////////////////////////////////////////////////////////////////
//
// enum LButtonUpReturn CCommsACtion::OnLButtonUp()
//
// Inputs           : None.
//
// Return Values    : None.
//
// Date             : 08 February 1999
//
// Engineer         : Billy Baker
//
// Description      : OnLButtonUp() is a common framework method for CAction
//                    derived classes.  Its purpose is to perform a action 
//                    based on some user interaction with the graphical 
//                    element to which the instance of this class is attached.
//                    In this case, OnLButtonUp is used to get a value from
//                    the graphical element to then write to simulation.
//
/////////////////////////////////////////////////////////////////////////////
enum LButtonUpReturn CMalfCommsAction::OnLButtonUp()
{
    if (m_pVariant != NULL)
    {
        CVariant var;
        var = *m_pVariant;
        var.Value(!(bool)var);
        SetHostValue(var, m_stlStrVariableToWatch, 0);
    }

    return LBU_OK;
}

/////////////////////////////////////////////////////////////////////////////
//
// void CCommsACtion::OnUpdate()
//
// Inputs           : None.
//
// Return Values    : None.
//
// Date             : 08 February 1999
//
// Engineer         : Billy Baker
//
// Description      : OnUpdate() is a common framework method for CAction
//                    derived classes.  Its purpose is to send a new value
//                    to its parent graphical widget.  OnUpdate should 
//                    generally be called by some other class than the parent 
//                    graphical element.
//
/////////////////////////////////////////////////////////////////////////////
void CMalfCommsAction::OnUpdate()
{
    if (m_bDeleting == true)
        return;

    // Make sure there is a Variant will a value to send to the parent
    // graphical widget.
    if (m_pVariant == NULL)
        return;

    if (m_pVariant->WasChanged() || m_bInitialRead == true) 
    {
        // Send the new value to the parent graphical widget.
        // m_bUseRange will tell the parent whether to use the m_pVariant
        // value of the data for colors and text.
        if (m_pFailureSummarySystemInterface != NULL)
        {
            if ((bool)(*m_pVariant) == true)
            {
                m_pFailureSummarySystemInterface->AddFailure(MALFUNCTION_ACTIVE, 
                                                             m_stlStrTitle, 
                                                             _FSI_STL::string(" active."));
            }
            else
            {
                m_pFailureSummarySystemInterface->DeleteFailure(MALFUNCTION_ACTIVE, 
                                                                m_stlStrTitle, 
                                                                _FSI_STL::string(" active."));
            }
        }

        m_malfunction.CurrentMalfunctionState(m_stlStrTitle, (bool)(*m_pVariant));
    }


    if (m_nSizeMalfButtons == 0)
    {
        m_bInitialRead = false;
        return;
    }

    m_syncMalfButtons.Lock();

    _FSI_STL::list<CWidget*> listButtons = m_listMalfButtons;

    m_syncMalfButtons.Unlock();

    _FSI_STL::list<CWidget*>::iterator lIt      = listButtons.begin();
    _FSI_STL::list<CWidget*>::iterator lendIt   = listButtons.end();

    if (lIt == lendIt)
    {
        m_bInitialRead = false;
        return;
    }

    CString strElementVar(m_stlStrElementVar.c_str());
    CWidget* pParentWidget;
    CWnd* pWnd;

    m_ChangeValue.Variant(m_pVariant);
    m_ChangeValue.UseRange(m_bUseRange);

    // Show as having a preselect the malf is not active.
    if ((bool)(*m_pVariant) == false && (m_bShowAsPreselect || m_bDoNotShowAsPreselect))
    {
        _FSI_STL::string stlStrText = m_ChangeValue.Text();
        CColor color = m_ChangeValue.Foreground();

        // All of the text should be the same.  Just use the first one.
        m_ChangeValue.Text(m_vectRanges[0]->TextTrue());
        if (m_bShowAsPreselect)
            m_ChangeValue.Foreground(CColor(CColor::GlobalColor("Malf_Preselect")));
        else
            m_ChangeValue.Foreground(CColor(CColor::GlobalColor("Malf_Normal")));


        while (lIt != lendIt)
        {
            pParentWidget = (*lIt);

            // If there is a parent widget, then update it if the
            // data has changed.
            if (CWidget::IsValidAddress(pParentWidget) != INVALID )
            {
                m_ChangeValue.Background(pParentWidget->Background());

                pParentWidget->ChangeValue(strElementVar, &m_ChangeValue);

                pWnd = pParentWidget->FrameworkParent();

                if (pWnd != NULL)
                {
                    (m_pCommsSystemInterface->m_mapWidgetsToRefresh[pWnd->GetSafeHwnd()])[pParentWidget] = true;
                }

            }

            lIt++;
        }

        m_ChangeValue.Text(stlStrText);
        m_ChangeValue.Foreground(color);

        lIt      = listButtons.begin();

        // Go ahead and set to false.  The only things that should
        // happen are that the preselect gets disarmed or armed or
        // the malf becomes active.
        m_bShowAsPreselect = false;
        m_bDoNotShowAsPreselect = false;

        // For the case where the button has been added to the 
        // comms action after having been deleted once.
        m_bInitialRead = false;
    }

    // Depeinding on the read_mode--read always, read changed, read never, 
    // or read_once-- update the parent graphical widget.  Also, if a read
    // has not been performed once and the read_mode is not read never, then
    // go ahead and get an initial value. 
    if (((m_bReadOnce    == true   && m_bRead == false) || 
         (m_bReadChanged == true   && m_pVariant->WasChanged() == true) || 
         (m_bReadAlways  == true)  || 
         (m_bInitialRead == true)) && 
         (m_bReadOnce    == true   || m_bReadChanged == true || m_bReadAlways == true))
    {
        if (m_pVariant->Type() != VAR_BOOL)
            m_pVariant->Value(false);

        // Run through any attached ranges to see if the current value is
        // in one of the ranges.
        if (m_vectRanges.size() > 0 && m_bUseGenericRange == true)
        {
            unsigned long int ulRangeStep = 0;
            bool bDone = false;
            while (ulRangeStep < m_vectRanges.size())
            {
                // Evaluate the range for the value pointed to by m_pVariant.
                if (m_vectRanges[ulRangeStep]->Evaluate(*m_pVariant) == true)
                {
                    // The range evaluated to true.  Reset m_ChangeValue to 
                    // match the range that was true.
                    m_ChangeValue.Text(m_vectRanges[ulRangeStep]->TextTrue());
                    m_ChangeValue.Foreground(m_vectRanges[ulRangeStep]->ForegroundTrue());
                    bDone = true;
                    break;
                }

                ulRangeStep++;
            }

            m_ChangeValue.TrueOrFalseValue(bDone);
        }
        else if (m_bUseSpecificRange == true && m_pRange != NULL)
        {
            if (m_pRange->Evaluate(*m_pVariant) == true)
            {
                // The range evaluated to true.  Reset m_ChangeValue to 
                // match the range that was true.
                m_ChangeValue.Text(m_pRange->TextTrue());
                m_ChangeValue.Foreground(m_pRange->ForegroundTrue());
                m_ChangeValue.TrueOrFalseValue(true);
            }
            else
            {
                // The range evaluated to true.  Reset m_ChangeValue to 
                // match the range that was true.
                m_ChangeValue.Text(m_pRange->TextFalse());
                m_ChangeValue.Foreground(m_pRange->ForegroundFalse());
                m_ChangeValue.TrueOrFalseValue(false);
            }
        }

        while (lIt != lendIt)
        {
            pParentWidget = (*lIt);

            // If there is a parent widget, then update it if the
            // data has changed.
            if (CWidget::IsValidAddress(pParentWidget) != INVALID )
            {
                m_ChangeValue.Background(pParentWidget->Background());

                pParentWidget->ChangeValue(strElementVar, &m_ChangeValue);

                pWnd = pParentWidget->FrameworkParent();

                if (pWnd != NULL)
                {
                    (m_pCommsSystemInterface->m_mapWidgetsToRefresh[pWnd->GetSafeHwnd()])[pParentWidget] = true;
                }

            }

            lIt++;
        }
    }


    // If this is a read once initializer, then mark as being read.
    if (m_bReadOnce == true)
        m_bRead = true;

    m_bInitialRead = false;
}


void CMalfCommsAction::AddVariable(_FSI_STL::string& stlStrVariable)
{
    if (m_pCommsSystemInterface == NULL)
    {
        return;
    }

    CVariableData varData;

    varData.SimVarName(stlStrVariable);
    varData.Type(VAR_BOOL);
    varData.Debrief(true);

    _FSI_STL::list<CRange> listRanges;

    CRange range;

    // First range for malf off.
    CVariant var;
    var.Value(false);

    range.ID(0);

    range.Lower(var);
    range.Upper(var);

    range.BackgroundTrue(Background());

    CColor colorF;
    colorF = CColor::GlobalColor("Malf_Normal");
    range.ForegroundTrue(colorF);

    range.TextTrue(m_stlStrTitle);
    range.TextFalse(m_stlStrTitle);

    range.LowerConditional(EQUAL_TO);
    range.UpperConditional(EQUAL_TO);

    listRanges.push_back(range);

    // Second range for malf on.
    var.Value(true);

    range.ID(1);

    range.Lower(var);
    range.Upper(var);

    colorF = CColor::GlobalColor("Malf_Active");
    range.ForegroundTrue(colorF);

    listRanges.push_back(range);

    m_pCommsSystemInterface->AddVariable(stlStrVariable, varData, listRanges);
}


void CMalfCommsAction::AddMalfButton(const CWidget* pWidget)
{
    m_syncMalfButtons.Lock();

    _FSI_STL::list<CWidget*>::iterator lIt = _FSI_STL::find(m_listMalfButtons.begin(),
                                                            m_listMalfButtons.end(),
                                                            pWidget);

    if (lIt == m_listMalfButtons.end())
        m_listMalfButtons.push_back(const_cast<CWidget*>(pWidget));

    m_nSizeMalfButtons = m_listMalfButtons.size();

    m_bInitialRead = true;

    m_bShowAsPreselect = m_malfunction.LabelHasPreselect(m_stlStrVariableToWatch);

    m_syncMalfButtons.Unlock();
}

void CMalfCommsAction::DeleteMalfButton(const CWidget* pWidget)
{
    m_syncMalfButtons.Lock();

    _FSI_STL::list<CWidget*>::iterator lIt = _FSI_STL::find(m_listMalfButtons.begin(),
                                                            m_listMalfButtons.end(),
                                                            pWidget);

    if (lIt != m_listMalfButtons.end())
        m_listMalfButtons.erase(lIt);

    m_nSizeMalfButtons = m_listMalfButtons.size();

    m_syncMalfButtons.Unlock();
}

void CMalfCommsAction::ClearMalf()
{
    if (m_pVariant != NULL)
    {
        if ((bool)(*m_pVariant) == true)
        {
            CVariant var;
            var.Value(false);
            SetHostValue(var, m_stlStrVariableToWatch, 0);
        }
    }
}

// To allow for the malf comms action to work as read
// changed rather than read always, this function was
// added to update the state of the currently selected
// malfunction whenever one of the malfunction buttons
// is clicked.  OnUpdate will still update the state
// when the value of the currently selected malfunction
// changes.
void CMalfCommsAction::UpdateStateOnButtonChange()
{
    m_malfunction.CurrentMalfunctionState(m_stlStrTitle, (bool)(*m_pVariant));
}

//////////////////////////////////////////////////////////////////////
// Accessors
//////////////////////////////////////////////////////////////////////

_FSI_STL::string CMalfCommsAction::MalfTitle()
{
    return m_stlStrTitle;
}

//////////////////////////////////////////////////////////////////////
// Mutators
//////////////////////////////////////////////////////////////////////

void CMalfCommsAction::MalfTitle(_FSI_STL::string& stlStrTitle)
{
    m_stlStrTitle = stlStrTitle;
}

void CMalfCommsAction::ShowAsPreselect(bool bShow)
{
    m_bShowAsPreselect = bShow;
}

void CMalfCommsAction::DoNotShowAsPreselect(bool bShow)
{
    m_bDoNotShowAsPreselect = bShow;
}