// MalfClearAllAction.cpp: implementation of the CMalfClearAllAction class.
//
//////////////////////////////////////////////////////////////////////
#include "..\core\stdafx.h"
#pragma warning(disable:4503) 

#include "MalfClearAllAction.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CMalfClearAllAction::CMalfClearAllAction()
{
    m_stlStrWidgetName = _FSI_STL::string("Malfunction_Clear_All");
}

CMalfClearAllAction::~CMalfClearAllAction()
{
}


void CMalfClearAllAction::Initialize(CXMLWidget*& rpXMLWidget, CWnd* pWnd, 
                                const long lId, bool bEditMode)
{
    CWidget::Initialize(rpXMLWidget,pWnd, lId, bEditMode);

    m_pAction = this;
    m_pWidget = (CWidget*)this;

    if (rpXMLWidget != NULL)
    {
        m_pIOActionXMLWidget = m_pXMLWidget;
        ResetProperties();
    }

    if (CWidget::IsValidAddress(m_pParentWidget) != INVALID)
    {
        m_hwndMainFrame = m_pParentWidget->MainFrameHwnd();
    }
}

CWidget* CMalfClearAllAction::CreateObject()
{
    return new CMalfClearAllAction();
}

void CMalfClearAllAction::ResetProperties()
{
    CWidget::ResetProperties();
    CIOAction::ResetProperties();
}

enum LButtonUpReturn CMalfClearAllAction::OnLButtonUp()
{
    if (m_bEditing == true)
    {
        return LBU_OK;
    }

    if (m_pParentWidget == NULL)
    {
        return LBU_OK;
    }

    m_malfunction.ClearAll();

    return LBU_OK;
}