// MalfChangeStateAction.cpp: implementation of the CMalfChangeStateAction class.
//
//////////////////////////////////////////////////////////////////////
#include "..\core\stdafx.h"
#pragma warning(disable:4503) 

#include "MalfChangeStateAction.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CMalfChangeStateAction::CMalfChangeStateAction()
{
    m_stlStrWidgetName = _FSI_STL::string("Malfunction_Change_State");
}

CMalfChangeStateAction::~CMalfChangeStateAction()
{
}

void CMalfChangeStateAction::Initialize(CXMLWidget*& rpXMLWidget, CWnd* pWnd, 
                                const long lId, bool bEditMode)
{
    CWidget::Initialize(rpXMLWidget,pWnd, lId, bEditMode);

    m_pAction = this;
    m_pWidget = (CWidget*)this;

    if (rpXMLWidget != NULL)
    {
        m_pIOActionXMLWidget = m_pXMLWidget;
        ResetProperties();
    }

    if (CWidget::IsValidAddress(m_pParentWidget) != INVALID)
    {
        m_hwndMainFrame = m_pParentWidget->MainFrameHwnd();
    }
}

CWidget* CMalfChangeStateAction::CreateObject()
{
    return new CMalfChangeStateAction();
}

void CMalfChangeStateAction::ResetProperties()
{
    CWidget::ResetProperties();
    CIOAction::ResetProperties();
}

enum LButtonUpReturn CMalfChangeStateAction::OnLButtonUp()
{
    if (m_bEditing == true)
    {
        return LBU_OK;
    }

    if (m_pParentWidget == NULL)
    {
        return LBU_OK;
    }

    m_malfunction.ChangeMalfState(m_hwndMainFrame);

    return LBU_OK;
}