/////////////////////////////////////////////////////////////////////////////
//
//           F L I G H T S A F E T Y   I N T E R N A T I O N A L
//                     Simulation Systems Division
//                      2700 North Hemlock Circle
//                     Broken Arrow, Oklahoma 74012
//                          (918) 259-4000
/////////////////////////////////////////////////////////////////////////////
//
// DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
// Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
// technical or operational data or information from automatic dissemination
// under the International Exchange Program or by other means.  This protection
// covers information required solely for administrative or operational
// purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
//
// WARNING:  This document contains technical data whose export is restricted
// by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
// Executive Order 12470.  Violation of these export control laws is subject
// to severe criminal penalties.  Dissemination of this document is controlled
// under DOD Directive 5230.25
//
/////////////////////////////////////////////////////////////////////////////
//
//
// Filename         : MalfEditorComponentInterface.cpp
//
// Date             : 19 October 1998
//
// Engineer         : Billy Baker
//
// Revision         :
//
// Description      : CMalfEditorComponentInterface is derived from 
//                    CComponentInterface.  CComponentInterface is the 
//                    contract that all plugin components to the 
//                    framework must implement in the form of a derived 
//                    class.  See the information in 
//                    CComponentInterface for more information.  
//                    CMalfEditorComponentInterface is used for the Malfunction
//                    editor library of controls and option pages.
//
// Classification   : UNCLASSIFIED
//
// Requirements     : None.
//
// Components Used  : None.
//
// Operational 
//    Restrictions  : Machine dependencies/restrictions
//                        None.
//                    Design dependencies/restrictions
//                        None.
//                    Operations containing dependencies/restrictions
//                        None.
//                    Compiler dependencies/restrictions
//                        None.
//                    Other conditions for proper execution
//                        None.
//
// Environment      : Operating system(s) - Microsoft Windows NT 4.0 with
//                                              NT service pack 3
//                                          Microsoft Windows NT 5.0
//
//                    Compiler(s) - Visual C++ 5.0 with VisC++ service pack 3
//                                  Visual C++ 6.0
//
//                    Architechure(s) - Intel Pentium, Pentium II
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
//                              R e v i s i o n   H i s t o r y
//
/////////////////////////////////////////////////////////////////////////////
#include "..\core\stdafx.h"
#include "MalfEditorComponentInterface.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

// The following static members contain the date and time of the last
// compilation of this class.
const char CMalfEditorComponentInterface::m_cRevisionDate[] = __DATE__;
const char CMalfEditorComponentInterface::m_cRevisionTime[] = __TIME__;

/////////////////////////////////////////////////////////////////////////////
//
// CMalfEditorComponentInterface::CMalfEditorComponentInterface()
//
// Inputs           : None.
//
// Return Values    : None.
//
// Date             : 19 October 1998
//
// Engineer         : Billy Baker
//
// Description      : This is the default constuctor for this class.  It 
//                    initializes the map of option pages, initializes 
//                    the string with the date and time of compilation, 
//                    and initializes the name of the component.
//
/////////////////////////////////////////////////////////////////////////////
CMalfEditorComponentInterface::CMalfEditorComponentInterface(
                                                  _FSI_STL::string stlStrPathName) :
                    CComponentInterface(_FSI_STL::string("Malfunction Editor"),
                                        stlStrPathName)
{
    _FSI_STL::string stlStrDate(m_cRevisionDate);
    _FSI_STL::string stlStrTime(m_cRevisionTime);

    m_stlStrDate = stlStrDate + " " + stlStrTime;

}

/////////////////////////////////////////////////////////////////////////////
//
// CMalfEditorComponentInterface::~CMalfEditorComponentInterface()
//
// Inputs           : None.
//
// Return Values    : None.
//
// Date             : 19 October 1998
//
// Engineer         : Billy Baker
//
// Description      : This is the default destructor for this class.  It 
//                    does not need to delete the option pages since 
//                    they are attached to a window when they are 
//                    created and will be delete when that window is 
//                    destroyed.  The pointers in the map, though, are 
//                    freed with a call to the map clear() method in the
//                    base class destructor.
//
/////////////////////////////////////////////////////////////////////////////
CMalfEditorComponentInterface::~CMalfEditorComponentInterface()
{
}
