/////////////////////////////////////////////////////////////////////////////
//
//           F L I G H T S A F E T Y   I N T E R N A T I O N A L
//                     Simulation Systems Division
//                      2700 North Hemlock Circle
//                     Broken Arrow, Oklahoma 74012
//                          (918) 259-4000
/////////////////////////////////////////////////////////////////////////////
//
// DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
// Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
// technical or operational data or information from automatic dissemination
// under the International Exchange Program or by other means.  This protection
// covers information required solely for administrative or operational
// purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
//
// WARNING:  This document contains technical data whose export is restricted
// by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
// Executive Order 12470.  Violation of these export control laws is subject
// to severe criminal penalties.  Dissemination of this document is controlled
// under DOD Directive 5230.25
//
/////////////////////////////////////////////////////////////////////////////
//
//
// Filename         : IosComponentInterface.cpp
//
// Date             : 19 October 1998
//
// Engineer         : Billy Baker
//
// Revision         :
//
// Description      : CIosComponentInterface is derived from 
//                    CComponentInterface.  CComponentInterface is the 
//                    contract that all plugin components to the 
//                    framework must implement in the form of a derived 
//                    class.  See the information in 
//                    CComponentInterface for more information.  
//                    CIosComponentInterface is used for the Ios 
//                    library of controls and option pages.
//
// Classification   : UNCLASSIFIED
//
// Requirements     : None.
//
// Components Used  : None.
//
// Operational 
//    Restrictions  : Machine dependencies/restrictions
//                        None.
//                    Design dependencies/restrictions
//                        None.
//                    Operations containing dependencies/restrictions
//                        None.
//                    Compiler dependencies/restrictions
//                        None.
//                    Other conditions for proper execution
//                        None.
//
// Environment      : Operating system(s) - Microsoft Windows NT 4.0 with
//                                              NT service pack 3
//                                          Microsoft Windows NT 5.0
//
//                    Compiler(s) - Visual C++ 5.0 with VisC++ service pack 3
//                                  Visual C++ 6.0
//
//                    Architechure(s) - Intel Pentium, Pentium II
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
//                              R e v i s i o n   H i s t o r y
//
/////////////////////////////////////////////////////////////////////////////
#include "..\core\stdafx.h"

#include "IosComponentInterface.h"

#include "CBWidget.h"
#include "GeoChart.h"

#include "CmmsAccountPage.h"
#include "CmmsVcrPage.h"
#include "..\fsisuite\product_version.h"

// The following static members contain the date and time of the last
// compilation of this class.
const char CIosComponentInterface::m_cRevisionDate[] = __DATE__;
const char CIosComponentInterface::m_cRevisionTime[] = __TIME__;

/////////////////////////////////////////////////////////////////////////////
//
// CIosComponentInterface::CIosComponentInterface()
//
// Inputs           : None.
//
// Return Values    : None.
//
// Date             : 19 October 1998
//
// Engineer         : Billy Baker
//
// Description      : CIosComponentInterface::CIosComponentInterface is 
//                    the default constuctor for this class.  It 
//                    initializes the map of option pages, initializes 
//                    the string with the date and time of compilation, 
//                    and initializes the name of the component.
//
/////////////////////////////////////////////////////////////////////////////
CIosComponentInterface::CIosComponentInterface(_FSI_STL::string stlStrPathName) :
            CComponentInterface(_FSI_STL::string("IOS"),stlStrPathName)
{
    _FSI_STL::string stlStrDate(m_cRevisionDate);
    _FSI_STL::string stlStrTime(m_cRevisionTime);

    //m_listPropPages.push_back(CCmmsAccountPage::CreateObject);
    //m_listPropPages.push_back(CCmmsVcrPage::CreateObject);

    m_stlStrDate = stlStrDate + " " + stlStrTime;

    m_listWidgetCtrls.push_back(CCBWidget::CreateObject);
    CBitmap* pBmp = new CBitmap;
    pBmp->LoadBitmap(CCBWidget::IDB);
    m_listWidgetImages.push_back(pBmp);

    m_listWidgetCtrls.push_back(CGeoChart1::CreateObject);
    pBmp = new CBitmap;
    pBmp->LoadBitmap(CGeoChart1::IDB);
    m_listWidgetImages.push_back(pBmp);

    m_listWidgetCtrls.push_back(CGeoChart2::CreateObject);
    pBmp = new CBitmap;
    pBmp->LoadBitmap(CGeoChart2::IDB);
    m_listWidgetImages.push_back(pBmp);

    m_listWidgetCtrls.push_back(CComboWidgetEx::CreateObject);
    pBmp = new CBitmap;
    pBmp->LoadBitmap(CComboWidgetEx::IDB);
    m_listWidgetImages.push_back(pBmp);


    m_listActions.push_back(CPickGeoChartAreaCommsAction::CreateObject);
    m_listActions.push_back(CPickGeoChartAreaCommsAction2::CreateObject);

    m_listActions.push_back(CPickGeoChartCommsAction::CreateObject);
    m_listActions.push_back(CPickGeoChartCommsAction2::CreateObject);

    m_listActions.push_back(CPickGeoChartIdentFilterCommsAction::CreateObject);
    m_listActions.push_back(CPickGeoChartIdentFilterCommsAction2::CreateObject);

	m_listActions.push_back(CPickHazardAirportCommsAction::CreateObject);
	m_listActions.push_back(CPickHazardPathCommsAction::CreateObject);

}

/////////////////////////////////////////////////////////////////////////////
//
// CIosComponentInterface::~CIosComponentInterface()
//
// Inputs           : None.
//
// Return Values    : None.
//
// Date             : 19 October 1998
//
// Engineer         : Billy Baker
//
// Description      : CIosComponentInterface::~CIosComponentInterface 
//                    is the default destructor for this class.  It 
//                    does not need to delete the option pages since 
//                    they are attached to a window when they are 
//                    created and will be delete when that window is 
//                    destroyed.  The pointers in the map, though, are 
//                    freed with a call to the map clear() method in the
//                    base destructor.
//
/////////////////////////////////////////////////////////////////////////////
CIosComponentInterface::~CIosComponentInterface()
{
}

void CIosComponentInterface::InitializeComponentConfig()
{
   CComponentInterface::InitializeComponentConfig();
   
   CGeoChartDataManager* pGeoChartDataManager   =  CPickGeoChartAreaCommsAction::GeoChartDataManager();
   if (pGeoChartDataManager != NULL)
      delete pGeoChartDataManager;

   pGeoChartDataManager    =  new CGeoChartDataManager;
   CPickGeoChartAreaCommsAction::GeoChartDataManager(pGeoChartDataManager);
   CPickGeoChartCommsAction::GeoChartDataManager(pGeoChartDataManager);
   CPickGeoChartIdentFilterCommsAction::GeoChartDataManager(pGeoChartDataManager);
   CGeoChart1::GeoChartDataManager(pGeoChartDataManager);


   CGeoChartDataManager* pGeoChartDataManager2  =  CPickGeoChartAreaCommsAction2::GeoChartDataManager();
   if (pGeoChartDataManager2 != NULL)
      delete pGeoChartDataManager2;

   pGeoChartDataManager2   =  new CGeoChartDataManager;
   CPickGeoChartAreaCommsAction2::GeoChartDataManager(pGeoChartDataManager2);
   CPickGeoChartCommsAction2::GeoChartDataManager(pGeoChartDataManager2);
   CPickGeoChartIdentFilterCommsAction2::GeoChartDataManager(pGeoChartDataManager2);
   CGeoChart2::GeoChartDataManager(pGeoChartDataManager2);

   CHazardPathDataManager* pHazardPathDataManager   =  CPickHazardAirportCommsAction::HazardPathDataManager();
   if (pHazardPathDataManager != NULL)
      delete pHazardPathDataManager;

   pHazardPathDataManager    =  new CHazardPathDataManager;
   CPickHazardAirportCommsAction::HazardPathDataManager(pHazardPathDataManager);
   CPickHazardPathCommsAction::HazardPathDataManager(pHazardPathDataManager);
}
