// ChecklistAction.h: interface for the CChecklistAction class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(_CHECKLISTACTION_H_)
#define _CHECKLISTACTION_H_

#include "..\core\action.h"
#include "..\core\Widget.h"
#include "..\core\XMLPage.h"

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

class CChecklistAction : public CAction, public CWidget 
{
private:
    struct ChecklistData 
    {
        _FSI_STL::string         m_stlStrItemName;
        _FSI_STL::string         m_stlStrDesiredValue;
    };    

    _FSI_STL::map<_FSI_STL::string, _FSI_STL::list<ChecklistData*> > m_mapChecklist;
    _FSI_STL::string             m_stlStrChecklistFile;
    CXMLPage*               m_pXMLChecklistPage;

    void LoadChecklistFile();

public:
	CChecklistAction();
	virtual ~CChecklistAction();

    virtual void Initialize(CXMLWidget*& rpXMLWidget, CWnd* pWnd, 
                            const long int lId, bool bEditMode);
    virtual void ResetProperties();
    static CWidget* CreateObject();

	virtual void OnLoad();
	virtual void OnUnload();
	virtual void OnUpdate();
	virtual void OnLButtonUp();
};

#endif // !defined(_CHECKLISTACTION_H_)
