// ChecklistAction.cpp: implementation of the CChecklistAction class.
//
//////////////////////////////////////////////////////////////////////
#include "..\core\stdafx.h"
#include "ChecklistAction.h"

#include "..\core\XMLParser5.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CChecklistAction::CChecklistAction()
{
    m_stlStrWidgetName = _FSI_STL::string("Checklist");
    m_pXMLChecklistPage = NULL;
}

CChecklistAction::~CChecklistAction()
{
    if (m_pXMLChecklistPage != NULL)
    {
        delete m_pXMLChecklistPage;
    }

    _FSI_STL::map<_FSI_STL::string, _FSI_STL::list<ChecklistData*> >::iterator mIt = NULL;
    mIt = m_mapChecklist.begin();
    for (; mIt != m_mapChecklist.end(); mIt++)
    {
//        delete (*mIt).second;
    }
    m_mapChecklist.clear();
}

void CChecklistAction::Initialize(CXMLWidget*& rpXMLWidget, CWnd* pWnd, 
                                const long lId, bool bEditMode)
{
    if (rpXMLWidget == NULL)
    {
        m_stlStrHelpText = "The " + m_stlStrName + " " + 
                           m_stlStrWidgetName.c_str() + 
                           " action serves as the method for reading a"\
                           " checklist data file, filling a graphical"\
                           " element with the data, and monitoring"\
                           " simulation values.";
        m_stlStrName = m_stlStrName + " " + m_stlStrWidgetName.c_str();
        m_stlStrHelpKeywords = m_stlStrName;
    }

    CWidget::Initialize(rpXMLWidget,pWnd, lId, bEditMode);

    if (rpXMLWidget != NULL)
    {
        ResetProperties();
    }

    m_pAction = this;
    m_pWidget = (CWidget*)this;
}

CWidget* CChecklistAction::CreateObject()
{
    return new CChecklistAction();
}

void CChecklistAction::ResetProperties()
{
    CWidget::ResetProperties();

    CXMLElement* pXMLElement = NULL;
    POSITION pos = NULL;
    if (m_pXMLWidget->FindElement(pXMLElement, pos, _FSI_STL::string("CHECKLIST")) == true)
    {
        m_stlStrChecklistFile = pXMLElement->ElementValue();
    }
    else
    {
        m_pXMLWidget->AddElement(_FSI_STL::string("CHECKLIST"), m_stlStrName,
                                 NULL);
    }

    LoadChecklistFile();
}

void CChecklistAction::OnLButtonUp()
{
}

void CChecklistAction::OnLoad()
{
}

void CChecklistAction::OnUnload()
{
}

void CChecklistAction::OnUpdate()
{
}

void CChecklistAction::LoadChecklistFile()
{
    if (m_stlStrChecklistFile != _FSI_STL::string(""))
    {
        CXMLParser5 xmlParser(m_stlStrChecklistFile.c_str());

        if (m_pXMLChecklistPage != NULL)
        {
            delete m_pXMLChecklistPage;
            m_pXMLChecklistPage = NULL;
        }

        m_pXMLChecklistPage = new CXMLPage;
        xmlParser.ParseFile(m_pXMLChecklistPage);
        ELEMENT_LIST::iterator elIt = NULL;
        while (m_pXMLChecklistPage->FindElement(elIt, 
                                        _FSI_STL::string("CHECKLIST_ITEM")) == true)
        {
            _FSI_STL::string stlStrChecklist((*elIt)->ElementValue().c_str());
            ChecklistData* pChecklistData = new ChecklistData;
            if (pChecklistData != NULL)
            {
                pChecklistData->m_stlStrItemName = _FSI_STL::string("unknown");
                pChecklistData->m_stlStrDesiredValue = _FSI_STL::string("unknown");
            }

            STRING2STRING_MAP::iterator s2sIt = NULL;
            if ((*elIt)->FindAttribute(s2sIt,_FSI_STL::string("NAME")) == true)
            {
                if (pChecklistData != NULL)
                {
                    pChecklistData->m_stlStrItemName = (*s2sIt).second;
                }
            }

            if ((*elIt)->FindAttribute(s2sIt,_FSI_STL::string("VALUE")) == true)
            {
                if (pChecklistData != NULL)
                {
                    pChecklistData->m_stlStrDesiredValue = (*s2sIt).second;
                }
            }

            if (m_mapChecklist.find(stlStrChecklist) != m_mapChecklist.end())
            {
//                delete (*(m_mapChecklist.find(stlStrChecklist))).second;
            }

            m_mapChecklist[stlStrChecklist].push_back(pChecklistData);

            elIt++;
        }
    }
}
