#if !defined(_CBWIDGET_H_)
#define _CBWIDGET_H_

#include "..\general\TextWidget.h"

#include "resource.h"

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

enum
{
    CB_NORMAL,
    CB_POPPED
};

class CCBWidget : public CTextWidget
{
// Construction
public:
	CCBWidget();

// Attributes
protected:
    CVariant    m_varCBCommand;
    CVariant    m_varCBStatus;
    CVariant    m_varCBCommand_cv;
    CVariant    m_varCBStatus_cv;

    CPen        penNN;
    CPen        penNP;
    CPen        pen;
    CBrush      brushNN;
    CBrush      brushNP;
    CBrush      brush;

    CPen        penBlackie;
    CPen        penUL;
    CPen        penLR;

    CRect       rectText;
    CSize       sizeText;

    CPoint      ptRectCenter;
    CPoint      ptLLOffset1;
    CPoint      ptUROffset1;
    CPoint      ptLLOffset2;
    CPoint      ptUROffset2;
    CPoint      ptLLOffset3;
    CPoint      ptUROffset3;

    CRect       rOver;
    CRect       rOver2;
    CRect       rUnder;

    virtual void InitReinit();

public:
  	enum { IDB = IDB_CB_WIDGET };

// Operations
public:
    static CWidget* CreateObject();
    virtual void    Initialize(CXMLWidget*& rpXMLWidget, CWnd* pWnd, 
                               const long int lId, bool bEditMode);

	virtual CVariant* GetValue(const CString &rstrValue);

    virtual void    ChangeValue(const CString& rstrElementVar, CChangeValue* pCV);
    virtual bool    UpdateRenderVariables();

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CCBWidget)
	public:
	virtual void DrawItem(LPDRAWITEMSTRUCT lpDrawItemStruct);
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CCBWidget();

	// Generated message map functions
protected:
	//{{AFX_MSG(CCBWidget)
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
	//}}AFX_MSG

	DECLARE_MESSAGE_MAP()
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(_CBWIDGET_H_)
