#include "..\core\stdafx.h"
#include "CBWidget.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif
 
/////////////////////////////////////////////////////////////////////////////
//
// CCBWidget::CCBWidget()
//
// Inputs           : None.
//
// Return Values    : None.
//
// Date             : 29 October 1999
//
// Engineer         : Billy Baker
//
// Description      : Default constructor.  Set the name of the widget which
//                    is used in the XML data and under the icons in the 
//                    editor.  Exposes only the Command and Status variables.
//                    Creates a number of pens that may be used to draw.
//
/////////////////////////////////////////////////////////////////////////////
CCBWidget::CCBWidget()
{
    m_stlStrWidgetName = _FSI_STL::string("Circuit_Breaker");

    m_listGraphicalElementVars.clear();
    m_listGraphicalElementVars.push_back("Command");
    m_listGraphicalElementVars.push_back("Status");

	penNN.CreatePen(PS_SOLID, 1, RGB(255, 128, 0));
    brushNN.CreateSolidBrush(RGB(255, 128, 0));

    penNP.CreatePen(PS_SOLID, 1, RGB(20, 20, 20));
    brushNP.CreateSolidBrush(RGB(20, 20, 20));

    pen.CreatePen(PS_SOLID, 1, RGB(255, 0, 0));
    brush.CreateSolidBrush(RGB(255, 0, 0));

    penBlackie.CreatePen(PS_SOLID, 2, RGB(0, 0, 0));
    penUL.CreatePen(PS_SOLID, 2, RGB(192, 192, 192));
    penLR.CreatePen(PS_SOLID, 2, RGB(64, 64, 64));

    m_exPtUpperLeft     =  CExtentsPoint(CPoint(0,0));
    m_exPtLowerRight    =  CExtentsPoint(CPoint(32,32));

    CCBWidget::InitReinit();
}

void CCBWidget::InitReinit()
{
    m_varCBCommand.Value((long)CB_NORMAL);
    m_varCBCommand_cv   = m_varCBCommand;

    // Note: this appears incorrect logically, but the polarity of the Status
    // coming in from the host is backwards, where the Status is true iff the
	// CB is "IN".    
    m_varCBStatus.Value((long)CB_POPPED);		
    m_varCBStatus_cv    = m_varCBStatus;

}

/////////////////////////////////////////////////////////////////////////////
//
// CCheckBoxWidget::~CCheckBoxWidget()
//
// Inputs           : None.
//
// Return Values    : None.
//
// Date             : 29 October 1999
//
// Engineer         : Billy Baker
//
// Description      : Default destructor.  Cleans up all of the pens and 
//                    brushes.
//
/////////////////////////////////////////////////////////////////////////////
CCBWidget::~CCBWidget()
{
	penNN.DeleteObject();
    penNP.DeleteObject();
    pen.DeleteObject();
    penBlackie.DeleteObject();
    penUL.DeleteObject();
    penLR.DeleteObject();

    brushNN.DeleteObject();
    brushNP.DeleteObject();
    brush.DeleteObject();
}


BEGIN_MESSAGE_MAP(CCBWidget, CButtonWidget)
	//{{AFX_MSG_MAP(CCBWidget)
	ON_WM_LBUTTONDOWN()
	ON_WM_LBUTTONUP()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
//
// CWidget* CCBWidget::CreateObject()
//
// Inputs           : None.
//
// Return Values    : A pointer to a new instance of CCBWidget.
//
// Date             : 29 October 1999
//
// Engineer         : Billy Baker
//
// Description      : CCBWidget::CreateObject() is a common 
//                    framework method used to create a new instance of 
//                    CCBWidget.  It is a static member.  The 
//                    address of this method is stored in a map of 
//                    widget name to CreateObject address in the 
//                    component interface for the DLL that contains the 
//                    CCBWidget.  Using this data structure, a 
//                    new instance of CCBWidget can be created 
//                    when one is encountered in the XML page 
//                    description file.
//
/////////////////////////////////////////////////////////////////////////////
CWidget* CCBWidget::CreateObject()
{
    return new CCBWidget();
}

/////////////////////////////////////////////////////////////////////////////
//
// void CCBWidget::Initialize()
//
// Inputs           : CXMLWidget*& rpXMLWidget - reference to a pointer 
//                                               that holds the data to 
//                                               create a CCBWidget.
//                    CWnd* pWnd               - the parent CWnd object.
//                    const long lId           - identifier.
//                    bool bEditMode           - whether editing is taking 
//                                               place.
//
// Return Values    : None.
//
// Date             : 29 October 1999
//
// Engineer         : Billy Baker
//
// Description      : CCBWidget::Initialize() is a common 
//                    framework method.  It is called after an instance 
//                    of CCBWidget has been created.  It is 
//                    responsible for initializing most of the internal 
//                    data members with data from the XMLWidget.  This 
//                    is done using the call to ResetProperties.  If 
//                    the XMLWidget pointer is NULL, a new XMLWidget 
//                    instance is created with default settings.  
//                    Generic help text is set here and any CWnd 
//                    derived Create() calls are made to create the 
//                    Windows object that allows for the use of the MFC 
//                    messages.  The HWND for the CWnd derived object 
//                    that is created is then added to a map in CWidget 
//                    that keeps track of what CWidget derived pointers 
//                    are valid.  This is to make sure that all of the 
//                    threads do not try to dereference bad pointers.
//
/////////////////////////////////////////////////////////////////////////////
void CCBWidget::Initialize(CXMLWidget*& rpXMLWidget, CWnd* pWnd, 
                               const long lId, bool bEditMode)
{
    CWidget::Initialize(rpXMLWidget,pWnd, lId, bEditMode);

    CCBWidget::InitReinit();

    if (rpXMLWidget != NULL)
    {
        ResetProperties();
    }

    if (GetSafeHwnd() == NULL)
    {
        Create("",WS_CHILD | WS_VISIBLE | WS_CLIPCHILDREN | BS_OWNERDRAW | CS_OWNDC,
               CRect(m_exPtUpperLeft, m_exPtLowerRight),
               (CWnd*)pWnd, lId);
    }
    else
    {
        SetParent(pWnd);
        MoveWindow(m_exPtUpperLeft.X(), m_exPtUpperLeft.Y(),
                   m_exPtLowerRight.X() - m_exPtUpperLeft.X(),
                   m_exPtLowerRight.Y() - m_exPtUpperLeft.Y(), FALSE);
        ShowWindow(SW_NORMAL);
    }

    CDC* pDCur = GetDC();
    if (m_pDC->GetSafeHdc() != NULL)
    {
        m_pDC->DeleteDC();
    }
    m_pDC->CreateCompatibleDC(pDCur);

    if (m_pBMP->GetSafeHandle() != NULL)
    {
        m_pBMP->DeleteObject();
    }
    m_pBMP->CreateCompatibleBitmap(pDCur, m_exPtLowerRight.X() - m_exPtUpperLeft.X(),
                                    m_exPtLowerRight.Y() - m_exPtUpperLeft.Y());
    ReleaseDC(pDCur);

    m_pDC->SelectObject(m_pBMP);
    m_pDC->SetBkMode(TRANSPARENT);
    m_pDC->SelectObject(&m_font);

    m_pWnd = this;
    m_mapValidAddresses[this] = m_pWnd->GetSafeHwnd();
}

/////////////////////////////////////////////////////////////////////////////
//
// void CCBWidget::OnLButtonDown()
//
// Inputs           : UINT nFlags  - flags that tell what other keys may 
//                                   have been pressed when the click 
//                                   occurred.
//                    CPoint point - the position of the click.
//
// Return Values    : None.
//
// Date             : 29 October 1999
//
// Engineer         : Billy Baker
//
// Description      : CCBWidget::OnLButtonDown() is an override of 
//                    the standard MFC method for CWnd derived classes. 
//                    Here, it is used to showing a tracking rectangle in
//                    the editor or to show any focus or push down states
//                    in the runtime.
//
/////////////////////////////////////////////////////////////////////////////
void CCBWidget::OnLButtonDown(UINT nFlags, CPoint point) 
{
    if (m_bEditing == true)
    {
        CWidget::Track(point);
    }
    else
    {
        m_bRedraw = false;

        CButtonWidget::OnLButtonDown(nFlags, point);
    }
}

/////////////////////////////////////////////////////////////////////////////
//
// void CCBWidget::OnLButtonUp()
//
// Inputs           : UINT nFlags  - flags that tell what other keys may 
//                                   have been pressed when the click 
//                                   occurred.
//                    CPoint point - the position of the click.
//
// Return Values    : None.
//
// Date             : 29 October 1999
//
// Engineer         : Billy Baker
//
// Description      : CCBWidget::OnLButtonUp() is an override of 
//                    the standard MFC method for CWnd derived classes. 
//                    Here, it is used to flip the state of the 
//                    CB and to tell all comms actions to update 
//                    via the call to CButtonWidget::OnLButtonUp().
//
/////////////////////////////////////////////////////////////////////////////
void CCBWidget::OnLButtonUp(UINT nFlags, CPoint point) 
{
    if (m_bEditing == true)
    {
    }
    else
    {
        // Create a filled region.
        m_bRedraw = false;

 		if ((long)m_varCBCommand == CB_NORMAL)
		{
            m_variant.Value((long)CB_POPPED);
        }
        else
        {
            m_variant.Value((long)CB_NORMAL);
        }

  	    CButtonWidget::OnLButtonUp(nFlags, point);
    }
}

/////////////////////////////////////////////////////////////////////////////
//
// void CCBWidget::DrawItem()
//
// Inputs           : LPDRAWITEMSTRUCT lpDrawItemStruct - pointer to a 
//                                                        Win32 structure
//                    .
//
// Return Values    : None.
//
// Date             : 29 October 1999
//
// Engineer         : Billy Baker
//
// Description      : CCBWidget::DrawItem() is an override of a 
//                    standard MFC method for use with owner drawn 
//                    controls.  It is overriden here to draw a circular
//                    3D button with the appearance of a circuit breaker.
//
/////////////////////////////////////////////////////////////////////////////
void CCBWidget::DrawItem(LPDRAWITEMSTRUCT lpDrawItemStruct) 
{
    CRect rect(&(lpDrawItemStruct->rcItem));

    CDC *pDCur  = CDC::FromHandle(lpDrawItemStruct->hDC);
    CDC *pDC    = m_pDC;

    long int lSavedDC = pDC->SaveDC();

    // fill the extents rectangle with the color for the background
    pDC->SetBkColor(m_clrBack);
    pDC->SetTextColor(m_clrFore);

    ::ExtTextOut(pDC->GetSafeHdc(), 0, 0, ETO_OPAQUE, (LPRECT)rect, NULL, 0, NULL);

    rect.DeflateRect(2,2);

    // Note: this appears incorrect logically, but the polarity of the Status
	// coming in from the host is backwards, where the Status is true iff the
	// CB is "IN".    
    if (((long)m_varCBCommand == CB_NORMAL) && 
        ((long)m_varCBStatus  == CB_NORMAL))		
    {
        pDC->SelectObject(&penNN);
        pDC->SelectObject(&brushNN);
    }
    else if (((long)m_varCBCommand == CB_NORMAL) && 
             ((long)m_varCBStatus  == CB_POPPED)) 
    {
        // Note: this appears incorrect logically, but the polarity of the 
        // Status coming in from the host is backwards, where the Status is 
        // true iff the  CB is "IN". 		
        pDC->SelectObject(&penNP);
        pDC->SelectObject(&brushNP);
    }
    else
    {
        pDC->SelectObject(&pen);
        pDC->SelectObject(&brush);
    }

    CString strValue;
    strValue.Format("%s",m_stlStrValue.c_str());
    if (m_strValue != strValue || m_rectLastDraw != rect)
    {
        m_strValue      = strValue;
        m_rectLastDraw  = rect;

        sizeText        = pDC->GetOutputTextExtent(strValue);

        rectText.left   = rect.left + (long)(rect.Width()/2.0f + 0.5f)  - 
                                        (long)(sizeText.cx/2.0f + 0.5f);
        rectText.top    = rect.top  + (long)(rect.Height()/2.0f + 0.5f) - 
                                        (long)(sizeText.cy/2.0f + 0.5f);

        ptRectCenter    = CPoint(rect.CenterPoint());
        ptLLOffset1     = CPoint(ptRectCenter.x - 10, ptRectCenter.y +  7);
        ptUROffset1     = CPoint(ptRectCenter.x +  7, ptRectCenter.y - 10);
        ptLLOffset2     = CPoint(ptRectCenter.x - 10, ptRectCenter.y + 10);
        ptUROffset2     = CPoint(ptRectCenter.x + 10, ptRectCenter.y - 10);
        ptLLOffset3     = CPoint(ptRectCenter.x -  7, ptRectCenter.y + 10);
        ptUROffset3     = CPoint(ptRectCenter.x + 10, ptRectCenter.y -  7);

        rOver           = CRect(rect);
        rOver2          = CRect(rect);
        rUnder          = CRect(rect);

        rOver.InflateRect(1,  1);
        rOver2.InflateRect(2, 2);
        rUnder.DeflateRect(1, 1);
    }

    pDC->Ellipse(rect);

    pDC->SelectObject(&penBlackie);
    pDC->Ellipse(&rOver2);

    pDC->SelectObject(&penUL);
    pDC->Arc(&rOver,  ptUROffset3, ptLLOffset3);
    pDC->Arc(&rect,   ptUROffset2, ptLLOffset2);
    pDC->Arc(&rUnder, ptUROffset1, ptLLOffset1);

    pDC->SelectObject(&penLR);
    pDC->Arc(&rOver,  ptLLOffset1, ptUROffset1);
    pDC->Arc(&rect,   ptLLOffset2, ptUROffset2);
    pDC->Arc(&rUnder, ptLLOffset3, ptUROffset3);

    pDC->TextOut(rectText.left, rectText.top, strValue);

    rect.InflateRect(2,2);
    pDCur->BitBlt(rect.left, rect.top, rect.Width(), rect.Height(), pDC, rect.left, rect.top, SRCCOPY);
    pDC->RestoreDC(lSavedDC);

    // Move and invalidate the children for the different states.
    if (m_bLButtonDown != m_bLButtonDownLastPass)
    {
        m_bLButtonDownLastPass = m_bLButtonDown;

        // Make sure that only the base widget updates all of the children.
        if (m_bTraverseUpdate == false)
        {
            TraverseBaseWidgets((CWidget*)this, true);
        }
    }
    else
    {
        if (m_bTraverseUpdate == false)
        {
            TraverseBaseWidgets((CWidget*)this, false);
        }
    }

    m_bTraverseUpdate = false;
}

/////////////////////////////////////////////////////////////////////////////
//
// CVariant* CCBWidget::GetValue()
//
// Inputs           : CString& rstrValue - the name of the internal 
//                                         variable whose value is needed
//                    .
//
// Return Values    : A pointer to CVariant instance that holds the 
//                    value for the requested internal variable.
//
// Date             : 29 October 1999
//
// Engineer         : Billy Baker
//
// Description      : CCBWidget::GetValue() is a common framework 
//                    method.  It is used when ever a user performs an 
//                    action like a button click or pressing a 
//                    return/enter key. These actions are performed on 
//                    the graphical element and signal that data needs 
//                    to go from the graphical element to somewhere 
//                    else.  Here, the somewhere else would either be a 
//                    local comms variable or a host variable.  Here, the
//                    value being sent is the status of the CB.
//
/////////////////////////////////////////////////////////////////////////////
CVariant* CCBWidget::GetValue(const CString &rstrValue)
{
   if (rstrValue == "Command")
   {
       return &m_variant;
   }

   return NULL;
}

//////////////////////////////////////////////////////////////////////
// Methods called from Comms thread
//////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
// void CCBWidget::ChangeValue()
//
// Inputs           : CString& rstrElementVar - the internal name of a 
//                                              variable that needs to be 
//                                              updated.
//                    CChangeValue* pCV       - pointer to data used to 
//                                              update an internal 
//                                              variable.
//
// Return Values    : None.
//
// Date             : 29 October 1999
//
// Engineer         : Billy Baker
//
// Description      : CCB::ChangeValue() is a common framework 
//                    method that is used by the Comms thread to send 
//                    new data to the graphical elements.  Since it is 
//                    called from another thread, the special internal 
//                    variables are used to store the updates.  Before 
//                    the graphical element is redrawn, 
//                    UpdateRenderVariables is called to copy the 
//                    updated values to the values used for rendering.  
//                    This causes more memory to be used but prevents 
//                    the use of synchronization objects that may stall 
//                    the Comms thread.
//
/////////////////////////////////////////////////////////////////////////////
void CCBWidget::ChangeValue(const CString& rstrElementVar, CChangeValue* pCV)
{
    if (pCV == NULL)
    {
        return;
    }

    if (rstrElementVar   == "Command")
    {
        m_varCBCommand_cv.Value((long)*(pCV->Variant()));
    }
    else if (rstrElementVar   == "Status")
    {
        m_varCBStatus_cv.Value((long)*(pCV->Variant()));
    }
    else
    {
        CWidget::ChangeValue(rstrElementVar, pCV);
    }
}

/////////////////////////////////////////////////////////////////////////////
//
// bool CCBWidget::UpdateRenderVariables()
//
// Inputs           : None.
//
// Return Values    : true  - all of the render variables were updated.
//                    false - a problem occurred updating the render 
//                            variables.
//
// Date             : 29 October 1999
//
// Engineer         : Billy Baker
//
// Description      : CCBWidget::UpdateRenderVariables is a 
//                    common framework method that is called by the 
//                    Comms thread to make sure that all of the 
//                    variables used for rendering have the most up to 
//                    date data.
//
/////////////////////////////////////////////////////////////////////////////
bool CCBWidget::UpdateRenderVariables()
{
    bool bRetVal = CWidget::UpdateRenderVariables();

    if (bRetVal == true)
    {
        m_varCBCommand = m_varCBCommand_cv;
        m_varCBStatus  = m_varCBStatus_cv;
    }

    return bRetVal;
}