#include "..\core\stdafx.h"
#include "Track_Point.h"

//************************************************************************************************
//************************************************************************************************
// PUBLIC METHODS
//************************************************************************************************
//************************************************************************************************

//Method:		CTrackPoint
//Purpose:		Default Constructor
//Parameters:	NONE
//Returns:		NONE
CTrackPoint::CTrackPoint():
m_dLat(0.0),
m_dLon(0.0),
m_dAlt(0.0)
{
}


//Method:		CTrackPoint
//Purpose:		Allows construction of point by taking Lat&Lon parameters.
//Parameters:	dLat - Desired latitude.
//				dLon - Desired longitude.
//				dAlt - Desired altitide.
//Returns:		NONE
CTrackPoint::CTrackPoint(double dLat, double dLon, double dAlt):
m_dLat(dLat),
m_dLon(dLon),
m_dAlt(dAlt)
{
}


//Method:		CTrackPoint
//Purpose:		Copy Constructor
//Parameters:	Object that you wish to copy.
//Returns:		NONE
CTrackPoint::CTrackPoint(const CTrackPoint& rhs):
m_dLat(rhs.GetLat()),
m_dLon(rhs.GetLon()),
m_dAlt(rhs.GetAlt())
{
}


//Method:		operator=
//Purpose:		Override assignment operator
//Parameters:	rhs = Right Hand Side object in equation
//Returns:		pointer to the current instance.
CTrackPoint& CTrackPoint::operator=(const CTrackPoint& rhs)
{
	//Prevent assignment to self.
	if(this == &rhs)
		return *this;

	m_dLat = rhs.GetLat();
	m_dLon = rhs.GetLon();
	m_dAlt = rhs.GetAlt();

	return *this;
}


//Method:		~CTrackPoint
//Purpose:		Default Destructor
//Parameters:	NONE
//Returns:		NONE
CTrackPoint::~CTrackPoint()
{
}


//Method:		GetLat
//Purpose:		Returns the current value of longitude
//Parameters:	NONE
//Returns:		a copy of the current value of longitude.
double CTrackPoint::GetLat()const
{
	return m_dLat;
}


//Method:		GetLon
//Purpose:		Returns the current value of longitude.
//Parameters:	NONE
//Returns:		a copy of the current value of longitude.
double CTrackPoint::GetLon()const
{
	return m_dLon;
}


//Method:		GetAlt
//Purpose:		Returns the current value of altitude.
//Parameters:	NONE
//Returns:		a copy of the current value of altitude.
double CTrackPoint::GetAlt()const
{
	return m_dAlt;
}


//Method:		SetLat
//Purpose:		Allows calling code the set the value of latitude.
//Parameters:	dValue - Desired value for latitude.
//Returns:		True if the operation was successful.
bool CTrackPoint::SetLat(double dValue)
{
	m_dLat = dValue;
	return true;
}


//Method:		SetLon
//Purpose:		Allows calling code the set the value of longitude.
//Parameters:	dValue - Desired value for longitude.
//Returns:		True if the operation was successful.
bool CTrackPoint::SetLon(double dValue)
{
	m_dLon = dValue;
	return true;
}


//Method:		SetAlt
//Purpose:		Allows calling code the set the value of altitude.
//Parameters:	dValue - Desired value for altitude.
//Returns:		True if the operation was successful.
bool CTrackPoint::SetAlt(double dValue)
{
	m_dAlt = dValue;
	return true;
}


//************************************************************************************************
//************************************************************************************************
// PRIVATE METHODS
//************************************************************************************************
//************************************************************************************************
