#ifndef PLUGINMANAGER_H_
#define PLUGINMANAGER_H_
#include <string>
#include <vector>

class InterfaceInfo
{
public:
	std::string		strInterface;
	std::string		strImplementation;

	InterfaceInfo():
	strInterface(""),
	strImplementation("")
	{
	}
};

class PlugInInfo
{
public:
	HMODULE					hDll;
	std::vector<InterfaceInfo*>	InterfaceInfoArray;

	PlugInInfo():
	hDll(NULL)
	{
	}
};

class CPlugInManager
{
public:
	//Attributes

	//Methods
	~CPlugInManager();
	static CPlugInManager& GetInstance();
	HMODULE FindModule(std::string& strInterface);
	HMODULE FindNextModule(std::string& strInterface);
	void LoadPlugins();

private:
	//Attributes
	static CPlugInManager*					s_pInstance;
	std::vector<PlugInInfo*>				m_PlugIns;
	std::vector<PlugInInfo*>::iterator		m_itFindModule;


	//Methods
	CPlugInManager();
   void UnloadAll(void);
	bool LoadPlugin(const std::string& strFilename);
};


#endif