#include "..\core\stdafx.h"
#include "..\general\ComboWidget.h"
#include "PickHazardAirportCommsAction.h"


#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif


CHazardPathDataManager*        CPickHazardAirportCommsAction::m_pHazardPathDataManager = NULL;


/////////////////////////////////////////////////////////////////////////////
//
// CPickHazardAirportCommsAction::CPickHazardAirportCommsAction
//
// Inputs           : None.
//
// Return Values    : None.
//
// Date             : 
//
// Engineer         : 
//
// Description      : Default constructor.  Sets the name of the widget.
//                    Adds the CPickHazardAirportCommsActionPage to the list of widget
//                    property pages.
/////////////////////////////////////////////////////////////////////////////
CPickHazardAirportCommsAction::CPickHazardAirportCommsAction()
{
   m_stlStrWidgetName   =  _FSI_STL::string("Pick_Hazard_Airport_Comms");
   m_listWidgetPropPages.pop_back();  // CLocalCommsAction pushes a CFormatPage and a
   m_listWidgetPropPages.pop_back();  // CRangePage that are not needed with this object so pop them off the list.
   m_ChangeInternally   =  false;
   m_JustInitialized    =  true;
}

/////////////////////////////////////////////////////////////////////////////
//
// CWidget* CPickHazardAirportCommsAction::CreateObject()
//
// Inputs           : None.
//
// Return Values    : Address of a new instance of CPickHazardAirportCommsAction.
//
// Date             : 
//
// Engineer         : 
//
// Description      : CreateObject() is a common framework method that must be
//                    implemented by each CWidget derived class.  The main
//                    application associates the name of this widget with this
//                    static CreateObject method so that a new object can be
//                    created without linking against the library that contains
//                    this class.
//
/////////////////////////////////////////////////////////////////////////////
CWidget* CPickHazardAirportCommsAction::CreateObject()
{
   return   new   CPickHazardAirportCommsAction();
}


/////////////////////////////////////////////////////////////////////////////
//
// void CPickHazardAirportCommsAction::OnUpdate()
//
// Inputs           : None.
//
// Return Values    : None.
//
// Date             : 13 September 2013
//
// Engineer         : 
//
// Description      : OnUpdate() is a common framework method for CAction
//                    derived classes.  Its purpose is to send a new value
//                    to its parent graphical widget.  OnUpdate should 
//                    generally be called by some other class than the parent 
//                    graphical element.
//
/////////////////////////////////////////////////////////////////////////////
void CPickHazardAirportCommsAction::OnUpdate()
{
   m_sync.Lock();

   if (m_bDeleting == true)
   {
      m_sync.Unlock();
      return;
   }

   // Make sure there is a Variant will a value to send to the parent
   // graphical widget.
   if (m_pVariant == NULL)
   {
      m_sync.Unlock();
      return;
   }

   // Make sure this instance is attached to a graphical element.
   if (CWidget::IsValidAddress(m_pParentWidget) != VALID )
   {
      m_sync.Unlock();
      return;
   }


   // Depending on the read_mode--read always, read changed, read never, 
   // or read_once-- update the parent graphical widget.  Also, if a read
   // has not been performed once and the read_mode is not read never, then
   // go ahead and get an initial value. 
   if (  (  (m_bReadOnce      == true  && m_bRead  == false)   || 
            (m_bReadChanged   == true  && m_pVariant->WasChanged(m_lElement)  == true) || 
            (m_bReadAlways    == true) || (m_bInitialRead   == true))   && 
         (m_bReadOnce   == true  || m_bReadChanged == true  || m_bReadAlways  == true)
      )
   {
      if (m_pHazardPathDataManager)
      {
         ((CComboWidget *)m_pParentWidget)->Entries(m_pHazardPathDataManager->m_list_of_airports);
         if (m_pHazardPathDataManager->m_airport_list_changed)
         {
			m_pHazardPathDataManager->m_airport_list_changed = false;
            if (m_pVariant)
            {
               m_ChangeValue.Variant(m_pVariant);
               m_ChangeValue.UseRange(false);
               m_pParentWidget->ChangeValue("Default", &m_ChangeValue);
               m_pParentWidget->Wnd()->Invalidate();
            }
         }
         else if (!m_ChangeInternally)
         {
            if (m_pVariant)
            {
               long  selection   =  (long)*m_pVariant;
               m_ChangeValue.Variant(m_pVariant);
               m_ChangeValue.UseRange(false);
               m_pParentWidget->ChangeValue("Default", &m_ChangeValue);
               m_pParentWidget->Wnd()->Invalidate();
               m_JustInitialized    =  false;
            }
         }
      }

      CWnd* pWnd = m_pParentWidget->FrameworkParent();

      if (pWnd != NULL && m_pCommsSystemInterface != NULL)
      {
         (m_pCommsSystemInterface->m_mapWidgetsToRefresh[pWnd->GetSafeHwnd()])[m_pParentWidget] = true;
      }

      // If this is a read once initializer, then mark as being read.
      if (m_bReadOnce == true)
      {
         m_bRead = true;
      }

      m_bInitialRead = false;
   }

   m_ChangeInternally   =  false;

   m_sync.Unlock();
}


enum LButtonUpReturn CPickHazardAirportCommsAction::OnLButtonUp()
{
   m_sync.Lock();

   if (m_bCanWrite == false)
   {
      m_sync.Unlock();
      return LBU_CAN_NOT_WRITE;
   }

   if (m_bDeleting == true)
   {
      // Since memory is going away, the parent is probably going away as well.  Let the parent think that
      // everything went ok.  Or, no write can take place
      m_sync.Unlock();
      return LBU_OK;
   }

   if (m_pCommsSystemInterface == NULL)
   {
      m_sync.Unlock();
      return LBU_NO_COMMS;
   }

   // Make sure this instance is attached to a graphical element.
   if (CWidget::IsValidAddress(m_pParentWidget) != VALID )
   {
      m_sync.Unlock();
      return LBU_OK;
   }

   CVariant *pVarSelection =  ((CComboWidget *)m_pParentWidget)->GetValue("Default");
   long     selection      =  (long)*pVarSelection;

   m_ChangeValue.Variant(pVarSelection);
   m_ChangeValue.UseRange(false);

   m_pParentWidget->ChangeValue("Default", &m_ChangeValue);
   m_pParentWidget->Wnd()->Invalidate();
   
   UpdateDependencies(selection);

   m_ChangeInternally   =  true;

   CLocalCommsAction::OnLButtonUp();

   m_sync.Unlock();

   return LBU_OK;
}


CHazardPathDataManager* CPickHazardAirportCommsAction::HazardPathDataManager()
{
    return m_pHazardPathDataManager;
}


void CPickHazardAirportCommsAction::HazardPathDataManager(const CHazardPathDataManager* pHazardPathDataManager)
{
    m_pHazardPathDataManager =  const_cast<CHazardPathDataManager*>(pHazardPathDataManager);
}


void  CPickHazardAirportCommsAction::UpdateDependencies(int selection)
{
   
   if (selection == 0) // No filter
   {
      m_pHazardPathDataManager->CreateFilteredPathList("NONE");
   }
   else if (selection == 1) // Current active airport
   {
	   _FSI_STL::string  ident;

	   // Lookup current active airport ident
	  {
         CVariant var;
         CCommsShared::GetHostValue(var, _FSI_STL::string("Active_Airport"));
	     ident = (std::string)var;
	  }

	  // Find active airport ident position in sorted airport list and set airport dropdown selection
	  // to that position if found. If not found, set ident to: "NO PATHS".
	  long nAirportIndex(0);
	  std::list<std::string>::iterator it;
	  bool found = false;
      for (it = m_pHazardPathDataManager->m_sorted_list_of_airports.begin(); it != m_pHazardPathDataManager->m_sorted_list_of_airports.end(); ++it)
	  {
          if (*it == ident)
		  {
			  {
                 CVariant var;
                 CCommsShared::GetLocalValue(var, _FSI_STL::string("hazard_airport_list"));
                 long  old_type =  var.Type();
                 var.Value(nAirportIndex);
                 var.ChangeType(old_type);
                 CCommsShared::SetLocalValue(var, _FSI_STL::string("hazard_airport_list"), 0);
			  }
			  found = true;
              break;
		  }
		  nAirportIndex += 1;
	  }
	  if (!found)
		  ident = "NO PATHS";

	  m_pHazardPathDataManager->CreateFilteredPathList(ident);
   }
   else // Go find the airport ident based on airport dropdown selection position
   {
	  _FSI_STL::string  identFiltered;
      _FSI_STL::map<long, _FSI_STL::list<_FSI_STL::string> >::iterator  mIt;
      mIt =  m_pHazardPathDataManager->m_list_of_airports.find(selection);

      if (mIt !=  m_pHazardPathDataManager->m_list_of_airports.end())
	  {
         identFiltered =  mIt->second.front().c_str();
	  }
	  m_pHazardPathDataManager->CreateFilteredPathList(identFiltered);
   }
   
}
