/////////////////////////////////////////////////////////////////////////////
//
//           F L I G H T S A F E T Y   I N T E R N A T I O N A L
//                     Simulation Systems Division
//                      2700 North Hemlock Circle
//                     Broken Arrow, Oklahoma 74012
//                          (918) 259-4000
/////////////////////////////////////////////////////////////////////////////
//
// DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
// Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
// technical or operational data or information from automatic dissemination
// under the International Exchange Program or by other means.  This protection
// covers information required solely for administrative or operational
// purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
//
// WARNING:  This document contains technical data whose export is restricted
// by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
// Executive Order 12470.  Violation of these export control laws is subject
// to severe criminal penalties.  Dissemination of this document is controlled
// under DOD Directive 5230.25
//
/////////////////////////////////////////////////////////////////////////////
//
//
// Filename         : PickGeoChartIdentFilterCommsAction.h
//
// Date             : 18 September 2013
//
// Engineer         : Charles Brissey
//
// Revision         : $Revision$
//
// Description      : PickGeoChartIdentFilterCommsAction.h contains the definition of the 
//                    CPickGeoChartIdentFilterCommsAction class.  This action is derived from 
//                    Core::CIOAction.  Its purpose is to distribute a 
//                    value to a graphical element in its OnUpdate 
//                    member.  This member is called from 
//                    CCommsSystemInterface::UpdateComms().  
//                    CCommsSystemInterface keeps track of all 
//                    CPickGeoChartIdentFilterCommsAction instances so that it may update all 
//                    of them.  Each CPickGeoChartIdentFilterCommsAction instance shares a 
//                    single CVariant instance.  Thus, many graphical 
//                    elements may want the value of a variable and 
//                    each graphical element will have an instance of a 
//                    CPickGeoChartIdentFilterCommsAction to read that variable.  However, the 
//                    value will be read from simulation once and 
//                    placed in the shared CVariant.  CPickGeoChartIdentFilterCommsAction will 
//                    also update simulation variables in OnLButtonUp.  
//                    This member will be called whenever an action 
//                    occurs on a graphical element.  The action might 
//                    be clicking a button or pressing the 
//                    enter/carriage return key while in an editbox.
//
// Classification   : UNCLASSIFIED
//
// Requirements     : None.
//
// Components Used  : Core::CIOAction, Core::CWidget, Comms::CCommsShared, 
//                    Core::CVariant, _FSI_STL::string, _FSI_STL::list, _FSI_STL::map, 
//                    _FSI_STL::vector, Comms::CCommsSystemInterface, 
//                    Core::CChangeValue, Core::CRange.
//
// Operational 
//    Restrictions  : Machine dependencies/restrictions
//                        None.
//                    Design dependencies/restrictions
//                        None.
//                    Operations containing dependencies/restrictions
//                        None.
//                    Compiler dependencies/restrictions
//                        None.
//                    Other conditions for proper execution
//                        None.
//
// Environment      : Operating system(s) - Microsoft Windows NT 4.0 with
//                                              NT service pack 4
//                                          Microsoft Windows NT 2000
//
//                    Compiler(s) - Visual C++ 6.0
//
//                    Architechure(s) - Intel Pentium, Pentium II
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
//                              R e v i s i o n   H i s t o r y
//
/////////////////////////////////////////////////////////////////////////////
// $Log$
// Revision 1.1  1999/04/02 19:41:28  billyb
/////////////////////////////////////////////////////////////////////////////
#if !defined(_PickGeoChartIdentFilterCommsAction_H_)
#define _PickGeoChartIdentFilterCommsAction_H_

#include "../comms/localcommsaction.h"
#include "GeoChartDataManager.h"

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

class CGeoChartDataManager;

class CPickGeoChartIdentFilterCommsAction : public CLocalCommsAction
{
protected:
   static   CGeoChartDataManager   *m_pGeoChartDataManager;

public:
	CPickGeoChartIdentFilterCommsAction();

   static CWidget* CreateObject();

   virtual void OnUpdate();
   virtual  enum     LButtonUpReturn   OnLButtonUp();

   static   CGeoChartDataManager*   GeoChartDataManager();
   static   void GeoChartDataManager(const CGeoChartDataManager* pGeoChartDataManager);

private:
   bool  m_ChangeInternally;
   bool  m_JustInitialized;

   void  UpdateDependencies(int selection);
};

#endif // !defined(_PickGeoChartIdentFilterCommsAction_H_)
