#include "..\core\stdafx.h"
#include "..\general\ComboWidget.h"
#include "PickGeoChartCommsAction2.h"


#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif


CGeoChartDataManager*        CPickGeoChartCommsAction2::m_pGeoChartDataManager = NULL;


/////////////////////////////////////////////////////////////////////////////
//
// CPickGeoChartCommsAction2::CPickGeoChartCommsAction2
//
// Inputs           : None.
//
// Return Values    : None.
//
// Date             : 13 September 2013
//
// Engineer         : Charles Brissey
//
// Description      : Default constructor.  Sets the name of the widget.
//                    Adds the CPickGeoChartCommsAction2Page to the list of widget
//                    property pages.
/////////////////////////////////////////////////////////////////////////////
CPickGeoChartCommsAction2::CPickGeoChartCommsAction2()
{
   m_stlStrWidgetName = _FSI_STL::string("Pick_Geo_Chart_Comms_2");
   m_listWidgetPropPages.pop_back();  // CLocalCommsAction pushes a CFormatPage and a
   m_listWidgetPropPages.pop_back();  // CRangePage that are not needed with this object so pop them off the list.
   m_ChangeInternally   =  false;
}

/////////////////////////////////////////////////////////////////////////////
//
// CWidget* CPickGeoChartCommsAction2::CreateObject()
//
// Inputs           : None.
//
// Return Values    : Address of a new instance of CPickGeoChartCommsAction2.
//
// Date             : 13 September 2013
//
// Engineer         : Charles Brissey
//
// Description      : CreateObject() is a common framework method that must be
//                    implemented by each CWidget derived class.  The main
//                    application associates the name of this widget with this
//                    static CreateObject method so that a new object can be
//                    created without linking against the library that contains
//                    this class.
//
/////////////////////////////////////////////////////////////////////////////
CWidget* CPickGeoChartCommsAction2::CreateObject()
{
   return   new   CPickGeoChartCommsAction2();
}


/////////////////////////////////////////////////////////////////////////////
//
// void CPickGeoChartCommsAction2::OnUpdate()
//
// Inputs           : None.
//
// Return Values    : None.
//
// Date             : 13 September 2013
//
// Engineer         : Charles Brissey
//
// Description      : OnUpdate() is a common framework method for CAction
//                    derived classes.  Its purpose is to send a new value
//                    to its parent graphical widget.  OnUpdate should 
//                    generally be called by some other class than the parent 
//                    graphical element.
//
/////////////////////////////////////////////////////////////////////////////
void CPickGeoChartCommsAction2::OnUpdate()
{
   m_sync.Lock();

   if (m_bDeleting == true)
   {
      m_sync.Unlock();
      return;
   }

   // Make sure there is a Variant will a value to send to the parent
   // graphical widget.
   if (m_pVariant == NULL)
   {
      m_sync.Unlock();
      return;
   }

   // Make sure this instance is attached to a graphical element.
   if (CWidget::IsValidAddress(m_pParentWidget) != VALID )
   {
      m_sync.Unlock();
      return;
   }

   if (m_pGeoChartDataManager)
   {
      ((CComboWidget *)m_pParentWidget)->Entries(m_pGeoChartDataManager->m_list_of_charts);
      if (m_pGeoChartDataManager->m_chart_list_changed)
      {
         m_pGeoChartDataManager->m_chart_list_changed =  false;
         if (m_pVariant)      // List changed - force selection to 0
         {
            m_pVariant->Value(0L);
            m_ChangeValue.Variant(m_pVariant);
            m_ChangeValue.UseRange(false);
            m_pParentWidget->ChangeValue("Default", &m_ChangeValue);
            m_pParentWidget->Wnd()->Invalidate();
         }
      }
      else if (!m_ChangeInternally && !m_pGeoChartDataManager->m_ident_list_changed)
      {
         if (m_pVariant)
         {
            m_ChangeValue.Variant(m_pVariant);
            m_ChangeValue.UseRange(false);
            m_pParentWidget->ChangeValue("Default", &m_ChangeValue);
            m_pParentWidget->Wnd()->Invalidate();
         }
      }

      // Depending on the read_mode--read always, read changed, read never, 
      // or read_once-- update the parent graphical widget.  Also, if a read
      // has not been performed once and the read_mode is not read never, then
      // go ahead and get an initial value. 
      if (  (  (m_bReadOnce      == true  && m_bRead  == false)   || 
               (m_bReadChanged   == true  && m_pVariant->WasChanged(m_lElement)  == true) || 
               (m_bReadAlways    == true) || (m_bInitialRead   == true))   && 
            (m_bReadOnce   == true  || m_bReadChanged == true  || m_bReadAlways  == true) ||
            m_pGeoChartDataManager->m_chart_list_changed
         )
      {
         CWnd* pWnd = m_pParentWidget->FrameworkParent();

         if (pWnd != NULL && m_pCommsSystemInterface != NULL)
         {
            (m_pCommsSystemInterface->m_mapWidgetsToRefresh[pWnd->GetSafeHwnd()])[m_pParentWidget] = true;
         }

         // If this is a read once initializer, then mark as being read.
         if (m_bReadOnce == true)
         {
            m_bRead = true;
         }
         m_bInitialRead = false;
      }

      m_ChangeInternally   =  false;
   }

   m_sync.Unlock();
}


enum LButtonUpReturn CPickGeoChartCommsAction2::OnLButtonUp()
{
   m_sync.Lock();

   if (m_bCanWrite == false)
   {
      m_sync.Unlock();
      return LBU_CAN_NOT_WRITE;
   }

   if (m_bDeleting == true)
   {
      // Since memory is going away, the parent is probably going away as well.  Let the parent think that
      // everything went ok.  Or, no write can take place
      m_sync.Unlock();
      return LBU_OK;
   }

   if (m_pCommsSystemInterface == NULL)
   {
      m_sync.Unlock();
      return LBU_NO_COMMS;
   }

   // Make sure this instance is attached to a graphical element.
   if (CWidget::IsValidAddress(m_pParentWidget) != VALID )
   {
      m_sync.Unlock();
      return LBU_OK;
   }

   CVariant *pVarSelection =  ((CComboWidget *)m_pParentWidget)->GetValue("Default");
   long     selection      =  (long)*pVarSelection;

   m_ChangeValue.Variant(pVarSelection);
   m_ChangeValue.UseRange(false);
   m_pParentWidget->ChangeValue("Default", &m_ChangeValue);
   m_pParentWidget->Wnd()->Invalidate();

   m_ChangeInternally   =  true;

   CLocalCommsAction::OnLButtonUp();

   if (selection)
   {
      CVariant var;
      CCommsShared::GetLocalValue(var, _FSI_STL::string("geochart_change_state_1"));
      long  old_type =  var.Type();
      var.Value(1L);                 // set the new value 
      var.ChangeType(old_type);
      CCommsShared::SetLocalValue(var, _FSI_STL::string("geochart_change_state_1"), 0);
   }
   else
   {
      CVariant var;
      CCommsShared::GetLocalValue(var, _FSI_STL::string("geochart_change_state_1"));
      long  old_type =  var.Type();
      var.Value(0L);                 // set the new value 
      var.ChangeType(old_type);
      CCommsShared::SetLocalValue(var, _FSI_STL::string("geochart_change_state_1"), 0);
   }

   m_sync.Unlock();

   return LBU_OK;
}


CGeoChartDataManager* CPickGeoChartCommsAction2::GeoChartDataManager()
{
    return m_pGeoChartDataManager;
}


void CPickGeoChartCommsAction2::GeoChartDataManager(const CGeoChartDataManager* pGeoChartDataManager)
{
    m_pGeoChartDataManager =  const_cast<CGeoChartDataManager*>(pGeoChartDataManager);
}

