#include "..\core\stdafx.h"
#include "..\general\ComboWidget.h"
#include "PickGeoChartAreaCommsAction.h"


#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif


CGeoChartDataManager*        CPickGeoChartAreaCommsAction::m_pGeoChartDataManager = NULL;


/////////////////////////////////////////////////////////////////////////////
//
// CPickGeoChartAreaCommsAction::CPickGeoChartAreaCommsAction
//
// Inputs           : None.
//
// Return Values    : None.
//
// Date             : 13 September 2013
//
// Engineer         : Charles Brissey
//
// Description      : Default constructor.  Sets the name of the widget.
//                    Adds the CPickGeoChartAreaCommsActionPage to the list of widget
//                    property pages.
/////////////////////////////////////////////////////////////////////////////
CPickGeoChartAreaCommsAction::CPickGeoChartAreaCommsAction()
{
   m_stlStrWidgetName   =  _FSI_STL::string("Pick_Geo_Chart_Area_Comms");
   m_listWidgetPropPages.pop_back();  // CLocalCommsAction pushes a CFormatPage and a
   m_listWidgetPropPages.pop_back();  // CRangePage that are not needed with this object so pop them off the list.
   m_ChangeInternally   =  false;
   m_JustInitialized    =  true;
}

/////////////////////////////////////////////////////////////////////////////
//
// CWidget* CPickGeoChartAreaCommsAction::CreateObject()
//
// Inputs           : None.
//
// Return Values    : Address of a new instance of CPickGeoChartAreaCommsAction.
//
// Date             : 13 September 2013
//
// Engineer         : Charles Brissey
//
// Description      : CreateObject() is a common framework method that must be
//                    implemented by each CWidget derived class.  The main
//                    application associates the name of this widget with this
//                    static CreateObject method so that a new object can be
//                    created without linking against the library that contains
//                    this class.
//
/////////////////////////////////////////////////////////////////////////////
CWidget* CPickGeoChartAreaCommsAction::CreateObject()
{
   return   new   CPickGeoChartAreaCommsAction();
}


/////////////////////////////////////////////////////////////////////////////
//
// void CPickGeoChartAreaCommsAction::OnUpdate()
//
// Inputs           : None.
//
// Return Values    : None.
//
// Date             : 13 September 2013
//
// Engineer         : Charles Brissey
//
// Description      : OnUpdate() is a common framework method for CAction
//                    derived classes.  Its purpose is to send a new value
//                    to its parent graphical widget.  OnUpdate should 
//                    generally be called by some other class than the parent 
//                    graphical element.
//
/////////////////////////////////////////////////////////////////////////////
void CPickGeoChartAreaCommsAction::OnUpdate()
{
   m_sync.Lock();

   if (m_bDeleting == true)
   {
      m_sync.Unlock();
      return;
   }

   // Make sure there is a Variant will a value to send to the parent
   // graphical widget.
   if (m_pVariant == NULL)
   {
      m_sync.Unlock();
      return;
   }

   // Make sure this instance is attached to a graphical element.
   if (CWidget::IsValidAddress(m_pParentWidget) != VALID )
   {
      m_sync.Unlock();
      return;
   }


   // Depending on the read_mode--read always, read changed, read never, 
   // or read_once-- update the parent graphical widget.  Also, if a read
   // has not been performed once and the read_mode is not read never, then
   // go ahead and get an initial value. 
   if (  (  (m_bReadOnce      == true  && m_bRead  == false)   || 
            (m_bReadChanged   == true  && m_pVariant->WasChanged(m_lElement)  == true) || 
            (m_bReadAlways    == true) || (m_bInitialRead   == true))   && 
         (m_bReadOnce   == true  || m_bReadChanged == true  || m_bReadAlways  == true)
      )
   {
      if (m_pGeoChartDataManager)
      {
         ((CComboWidget *)m_pParentWidget)->Entries(m_pGeoChartDataManager->m_list_of_areas);
         if (m_pGeoChartDataManager->m_chart_list_changed)
         {
            if (m_pVariant)
            {
               long  selection   =  (long)*m_pVariant;
               m_pGeoChartDataManager->m_selected_area  =  selection;
               m_ChangeValue.Variant(m_pVariant);
               m_ChangeValue.UseRange(false);
               m_pParentWidget->ChangeValue("Default", &m_ChangeValue);
               m_pParentWidget->Wnd()->Invalidate();
               UpdateDependencies(selection);
            }
         }
         else if (!m_ChangeInternally)
         {
            if (m_pVariant)
            {
               long  selection   =  (long)*m_pVariant;
               m_pGeoChartDataManager->m_selected_area  =  selection;
               m_ChangeValue.Variant(m_pVariant);
               m_ChangeValue.UseRange(false);
               m_pParentWidget->ChangeValue("Default", &m_ChangeValue);
               m_pParentWidget->Wnd()->Invalidate();
               if (!m_JustInitialized)
                  UpdateDependencies(selection);
               m_JustInitialized    =  false;
            }
         }
      }

      CWnd* pWnd = m_pParentWidget->FrameworkParent();

      if (pWnd != NULL && m_pCommsSystemInterface != NULL)
      {
         (m_pCommsSystemInterface->m_mapWidgetsToRefresh[pWnd->GetSafeHwnd()])[m_pParentWidget] = true;
      }

      // If this is a read once initializer, then mark as being read.
      if (m_bReadOnce == true)
      {
         m_bRead = true;
      }

      m_bInitialRead = false;
   }

   m_ChangeInternally   =  false;

   m_sync.Unlock();
}


enum LButtonUpReturn CPickGeoChartAreaCommsAction::OnLButtonUp()
{
   m_sync.Lock();

   if (m_bCanWrite == false)
   {
      m_sync.Unlock();
      return LBU_CAN_NOT_WRITE;
   }

   if (m_bDeleting == true)
   {
      // Since memory is going away, the parent is probably going away as well.  Let the parent think that
      // everything went ok.  Or, no write can take place
      m_sync.Unlock();
      return LBU_OK;
   }

   if (m_pCommsSystemInterface == NULL)
   {
      m_sync.Unlock();
      return LBU_NO_COMMS;
   }

   // Make sure this instance is attached to a graphical element.
   if (CWidget::IsValidAddress(m_pParentWidget) != VALID )
   {
      m_sync.Unlock();
      return LBU_OK;
   }

   CVariant *pVarSelection =  ((CComboWidget *)m_pParentWidget)->GetValue("Default");
   long     selection      =  (long)*pVarSelection;
   m_pGeoChartDataManager->m_selected_area  =  selection;

   m_ChangeValue.Variant(pVarSelection);
   m_ChangeValue.UseRange(false);

   m_pParentWidget->ChangeValue("Default", &m_ChangeValue);
   m_pParentWidget->Wnd()->Invalidate();
   
   UpdateDependencies(selection);

   m_ChangeInternally   =  true;

   CLocalCommsAction::OnLButtonUp();

   m_sync.Unlock();

   return LBU_OK;
}


CGeoChartDataManager* CPickGeoChartAreaCommsAction::GeoChartDataManager()
{
    return m_pGeoChartDataManager;
}


void CPickGeoChartAreaCommsAction::GeoChartDataManager(const CGeoChartDataManager* pGeoChartDataManager)
{
    m_pGeoChartDataManager =  const_cast<CGeoChartDataManager*>(pGeoChartDataManager);
}


void  CPickGeoChartAreaCommsAction::UpdateDependencies(int selection)
{
   bool  filtered =  m_pGeoChartDataManager->m_area_filtered[selection];

   CVariant var;
   CCommsShared::GetLocalValue(var, _FSI_STL::string("geochart_ident_filter_state"));
   long  old_type =  var.Type();
   var.Value(filtered);                 // set the new value 
   var.ChangeType(old_type);
   CCommsShared::SetLocalValue(var, _FSI_STL::string("geochart_ident_filter_state"), 0);

   if (filtered)
   {
      m_pGeoChartDataManager->CreateIdentList();
      m_pGeoChartDataManager->ResetChartList();
   }
   else if (selection == 0)      // Sortie - Referenced is selected
   {
      m_pGeoChartDataManager->CreateSortieChartList();
   }
   else if (selection == 1)      // Nearby is selected
   {
      m_pGeoChartDataManager->CreateLocalChartList();
   }
   else
   {
      m_pGeoChartDataManager->CreateChartList("");
   }

   // Force reset of the Chart List Combo Box to the zeroth item.
   {
      CVariant var;
      CCommsShared::GetLocalValue(var, _FSI_STL::string("geochart_list"));
      long  old_type =  var.Type();
      var.Value(0L);
      var.ChangeType(old_type);
      CCommsShared::SetLocalValue(var, _FSI_STL::string("geochart_list"), 0);
   }

   // Force reset of the Ident Combo Box to the "Pick..." option
   {
      CVariant var;
      CCommsShared::GetLocalValue(var, _FSI_STL::string("geochart_list_idents"));
      long  old_type =  var.Type();
      var.Value(0L);
      var.ChangeType(old_type);
      CCommsShared::SetLocalValue(var, _FSI_STL::string("geochart_list_idents"), 0);
   }

   // Always disable the Change button
   {
      CVariant var;
      CCommsShared::GetLocalValue(var, _FSI_STL::string("geochart_change_state"));
      long  old_type =  var.Type();
      var.Value(0L);
      var.ChangeType(old_type);
      CCommsShared::SetLocalValue(var, _FSI_STL::string("geochart_change_state"), 0);
   }
}
