#include "..\core\stdafx.h"
#include "MyRect.h"


CMyRect::CMyRect()
:left(0.0)
,top(0.0)
,right(0.0)
,bottom(0.0)
{
}

CMyRect::CMyRect(const CMyRect& rhs)
:left(rhs.left)
,top(rhs.top)
,right(rhs.right)
,bottom(rhs.bottom)
{
}

CMyRect::CMyRect(double l, double t, double r, double b)
:left(l)
,top(t)
,right(r)
,bottom(b)
{
}

void  CMyRect::InflateRect(double x, double y)
{
   left     -= x;
   top      -= y;
   right    += x;
   bottom   += y;
}

void  CMyRect::InflateRect(double l, double t, double r, double b)
{
   left     -= l;
   top      -= t;
   right    += r;
   bottom   += b;
}

void  CMyRect::OffsetRect(double x, double y)
{
   left     += x;
   top      += y;
   right    += x;
   bottom   += y;
}

bool  CMyRect::PtInRect(CPoint pt)
{
   return   (pt.x >= left  && pt.x  <  right && pt.y  >= top   && pt.y  <  bottom);
}
