#ifndef IMAGETYPEMANAGER_H_
#define IMAGETYPEMANAGER_H_

#include <vector>
#include <string>

class IImageType;


class CImageTypeManager
{
public:
	//Attributes
	//Methods
	CImageTypeManager();
	~CImageTypeManager();
	void LoadPlugins();
    void UnloadPlugins(void);
	const std::string& GetFileFilters();
	bool Open(const std::string&);
	int GetImageHeight();
	int GetImageWidth();
	void Draw(HDC, RECT);
	void Draw(	HDC in_DeviceContextHandle, 
			long in_XMapPx,
			long in_YMapPx,
			double in_scale,
			long in_LeftScreenPx,
			long RightScreenPx,
			long in_TopScreenPx,
			long in_BottomScreenPx);
    bool HasGeoRefData();

private:
	//Attributes
	std::vector<IImageType*>				m_ImageTypeArray;
	std::vector<IImageType*>::iterator		m_it;
	std::string								m_strFileFilters;
	bool									m_bImageOpen;

	//Methods
	void GetFilenames(const std::string& strDirectory, std::vector<std::string>& vFilenames) const;
};


#endif