#include "..\core\stdafx.h"
#include "ImageTypeManager.h"
#include "IImageType.h"
#include <io.h>
#include "PlugInManager.h"


//Method:		CImageTypeManager
//Purpose:		Default Constructor
//Parameters:	NONE
//Returns:		NONE
CImageTypeManager::CImageTypeManager():
m_bImageOpen(false)
,m_it(0)
{
}


//Method:		~CImageTypeManager
//Purpose:		Destructor
//Parameters:	NONE
//Returns:		NONE
CImageTypeManager::~CImageTypeManager()
{
	UnloadPlugins();
}


//Method:		LoadPlugins
//Purpose:		Called by the application to load all plugins into memory at once.
//Parameters:	NONE
//Returns:		NONE
void CImageTypeManager::LoadPlugins()
{
	//Load all plugins into memory.
	CPlugInManager::GetInstance().LoadPlugins();

	//Find all dlls that support the IImageType interface and add them to our array.
	std::string strInterface("IImageType");
	HMODULE hDll(NULL);
	hDll = CPlugInManager::GetInstance().FindModule(strInterface);
	if(hDll != NULL)
	{
		do
		{
			//Check to see if the interface is supported.
			IImageType* (*pCreateImageType)();
			pCreateImageType = (IImageType* (*)())::GetProcAddress(hDll,"CreateImageType");
			if(pCreateImageType != NULL)
			{
				IImageType* pImageType;
				pImageType = pCreateImageType();
				if ( pImageType != NULL )				
					m_ImageTypeArray.push_back(pImageType);
			}

			hDll = CPlugInManager::GetInstance().FindNextModule(strInterface);

		}while(hDll != NULL);
	}
}


//Method:		UnloadPlugins
//Purpose:		Called by the application to unload all plugins from memory.
//Parameters:	NONE
//Returns:		NONE
void CImageTypeManager::UnloadPlugins()
{
	std::vector<IImageType*>::iterator it;
	for (it=m_ImageTypeArray.begin(); it!=m_ImageTypeArray.end(); ++it)
	{
		delete (*it);
	}
	m_ImageTypeArray.clear();
	m_bImageOpen = false;
}


//Method:		GetFileFilters
//Purpose:		Called by the application to query for all supported file types.
//Parameters:	NONE
//Returns:		Reference to string that contains all supported filetypes.
const std::string&  CImageTypeManager::GetFileFilters()
{
	m_strFileFilters = "";
	bool bFirstPass(true);
	std::vector<IImageType*>::iterator it;
	for (it=m_ImageTypeArray.begin(); it!=m_ImageTypeArray.end(); ++it)
	{
		if(!bFirstPass)
			m_strFileFilters += "|";
		else
			bFirstPass = false;

		std::string strFilter((*it)->GetFileFilter());
		m_strFileFilters += strFilter; 
	}

	return m_strFileFilters;
}


//Method:		Open
//Purpose:		Called by the application to open the file indicated by the supplied parameter.
//Parameters:	strFilename - Path and name of file to open.
//Returns:		True if the open was successfull.
bool CImageTypeManager::Open(const std::string& strFilename)
{
	for (m_it=m_ImageTypeArray.begin(); m_it!=m_ImageTypeArray.end(); ++m_it)
	{
		if((*m_it)->Open(strFilename.c_str()))
		{
			m_bImageOpen = true;
			return true;
		}
	}

	m_bImageOpen = false;
	return false;
}


//Method:		GetImageHeight
//Purpose:		Returns the current image's height in pixels.
//Parameters:	NONE
//Returns:		Integer containing the height in pixels.
int CImageTypeManager::GetImageHeight()
{
	if(!m_bImageOpen)
		return 0;

	return (*m_it)->GetImageHeight();
}


//Method:		GetImageWidth
//Purpose:		Returns the current image's width in pixels.
//Parameters:	NONE
//Returns:		Integer containing the width in pixels.
int CImageTypeManager::GetImageWidth()
{
	if(!m_bImageOpen)
		return 0;

	return (*m_it)->GetImageWidth();
}


//Method:		Draw
//Purpose:		Calls the current image plugin's draw routine.
//Parameters:	NONE
//Returns:		NONE
void CImageTypeManager::Draw(HDC hDC, RECT rExtents)
{
	if(!m_bImageOpen)
		return;

   SetLastError(0);                                // Clear any existing errors
   (*m_it)->Draw(hDC,rExtents);
   int   drawError(GetLastError());                // Check to see if the Draw code produced an error.

	return;
}

void CImageTypeManager::Draw(	HDC in_DeviceContextHandle, 
						   long in_XMapPx,
						   long in_YMapPx,
						   double in_scale,
						   long in_LeftScreenPx,
						   long RightScreenPx,
						   long in_TopScreenPx,
						   long in_BottomScreenPx)
{
    if(m_bImageOpen)
    {
      SetLastError(0);                                // Clear any existing errors
		bool  retval   =  (*m_it)->Draw( in_DeviceContextHandle, 
						                     in_XMapPx,
						                     in_YMapPx,
						                     in_scale,
						                     in_LeftScreenPx,
						                     RightScreenPx,
						                     in_TopScreenPx,
						                     in_BottomScreenPx);

      if (retval  == false)            // Give it another chance.
      {
		   bool  retval   =  (*m_it)->Draw( in_DeviceContextHandle, 
						                        in_XMapPx,
						                        in_YMapPx,
						                        in_scale,
						                        in_LeftScreenPx,
						                        RightScreenPx,
						                        in_TopScreenPx,
						                        in_BottomScreenPx);
      }
      int   drawError(GetLastError());                // Check to see if the Draw code produced an error.
	}
}//end Draw(...)


bool CImageTypeManager::HasGeoRefData(void)
{
    if(m_bImageOpen)
    {
        return (*m_it)->HasGeoRefData();
    }
    return false;
}