#if !defined(AFX_HAZARDPATHDATAMANAGER_H)
#define AFX_HAZARDPATHDATAMANAGER_H

#include <afxtempl.h>
#include "..\core\stdafx.h"
#include "..\core\stltypes.h"
#include "..\comms\CommsShared.h"

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

class CHazardPathDataManager
{
public:

   CHazardPathDataManager();

   virtual ~CHazardPathDataManager()
   {
   };
 
   void  Initialize(void);
   void  CreatePathList(void);
   void  CreateAirportList(void);
   void  CreateFilteredPathList(std::string airport);
   void  ProcessFilteredPathSelection(std::string path);

   typedef  struct   pathInfo
   {
      long           value;
      CString        airport;
      CString        name;

	  bool operator < (const pathInfo& str) const
	  {
        return (name < str.name);
	  }

   }  PathInfo;



   HANDLE   m_mutex;
   PathInfo        m_pathInfo;
   CList <PathInfo,PathInfo>  m_pathList;
   _FSI_STL::map<long, _FSI_STL::list<_FSI_STL::string> >   m_list_of_airports;
   _FSI_STL::map<long, _FSI_STL::list<_FSI_STL::string> >   m_filtered_list_of_paths;
   std::list<std::string> m_sorted_list_of_airports;

   bool     m_path_list_changed;
   bool     m_filtered_path_list_changed;
   bool     m_airport_list_changed;

};

#endif // !defined(AFX_HAZARDPATHDATAMANAGER_H)
