#include "..\core\stdafx.h"
#include "HazardPathDataManager.h"

CHazardPathDataManager::CHazardPathDataManager()
{
   m_mutex  =  CreateMutex(NULL, FALSE, NULL);
   CreatePathList();
   CreateAirportList();
   Initialize();
}

void CHazardPathDataManager::CreatePathList(void)
{

   //** This code to be used if we set the file path in the registry instead of hard-coding.
    CString  fullProfilePath("hazardpaths.ini");
    HKEY  hKey;
    RegOpenKeyEx(HKEY_LOCAL_MACHINE, _T("Software\\FlightSafety\\FSISuite\\Radio Database\\"), 0, KEY_READ, &hKey);
    if (hKey != NULL)
    {
       CString  strValue;
       DWORD    dwType,  dwCount;

       LONG  lResult  =  RegQueryValueEx(hKey, _T("HazardPathsCustomDataFile"), NULL, &dwType, NULL, &dwCount);
       if (lResult == ERROR_SUCCESS)
       {
          ASSERT(dwType  == REG_SZ);
          lResult  =  RegQueryValueEx(hKey, _T("HazardPathsCustomDataFile"), NULL, &dwType, (LPBYTE)strValue.GetBuffer(dwCount/sizeof(TCHAR)), &dwCount);
          strValue.ReleaseBuffer();
       }
       fullProfilePath   =  strValue;

       RegCloseKey(hKey);
    }
	//**

   //$$ Hardcoded file path
   //$$CString  filePath("C:\\Program Files\\FlightSafety\\JPATS-IOS\\FSISuite\\data\\hazardpaths.ini");

   long     number_of_paths   =  0;
   int      count =  0;
   char     buffer[2048];
   int      ii, zz;
   char     delimeters[]   =  "=,";
   char     *token;

   DWORD retcode  =  WaitForSingleObject(m_mutex, INFINITE);
   m_pathList.RemoveAll();

   //**  Use this for registry file path
   count =  GetPrivateProfileSection("HEADER",  buffer,  sizeof(buffer), fullProfilePath);

   //$$Use this for Hardcoded file path
   //$$count =  GetPrivateProfileSection("HEADER",  buffer,  sizeof(buffer), filePath);

   for (zz = 0; zz < count; zz++)
   {
      if (buffer[zz] == 0)
         buffer[zz]  =  ',';
   }

   token =  strtok(buffer, delimeters);                                 // Get the first string.
   while (token)
   {
      if (stricmp(token,      "Number of Paths")   == 0)
      {
         token =  strtok(NULL, delimeters);                             // Get the next string.
         number_of_paths   =  atoi(token);
      }
      token =  strtok(NULL, delimeters);                                // Get the next string.
   }

   if (number_of_paths  >  0)
   {
      CString  CStr_paths;

      for (ii = 0; ii < number_of_paths; ii++)
      {
         CStr_paths.Format("Path %d", ii + 1);
         count =  GetPrivateProfileSection(CStr_paths,  buffer,  sizeof(buffer),   fullProfilePath);
		 //$$count =  GetPrivateProfileSection(CStr_paths,  buffer,  sizeof(buffer),   filePath);
         for (int zz = 0; zz < count; zz++)
         {
            if (buffer[zz] == 0)
               buffer[zz]  =  ',';
         }

         bool  got_value = false, got_airport = false, got_name = false;

         token =  strtok(buffer, delimeters);                                 // Get the first string.
         while (token)
         {
            if (stricmp(token, "Value") == 0)
            {
               token =  strtok(NULL, delimeters);                             // Get the next string.
               m_pathInfo.value =  atoi(token);
               got_value                               =  true;
            }
            else if (stricmp(token, "Airport")       == 0)
            {
               token =  strtok(NULL, delimeters);                             // Get the next string.
               m_pathInfo.airport.Format("%s", token);
               got_airport                           =  true;
            }
            else if (stricmp(token, "Name")      == 0)
            {
               token =  strtok(NULL, delimeters);                             // Get the next string.
               m_pathInfo.name.Format("%s", token);
               got_name                          =  true;
            }

            if (got_value && got_airport && got_name)
            {
               m_pathList.AddTail(m_pathInfo);
            }
            token =  strtok(NULL, delimeters);                                // Get the next string.
         }
      }
   }
   
   // Copy paths to an array, sort, and copy back to path list
   CArray<pathInfo,pathInfo> tempArray;
   for (int i=0; i < m_pathList.GetCount(); i++)
      tempArray.Add(m_pathList.GetAt(m_pathList.FindIndex(i)));
   std::sort(tempArray.GetData(), tempArray.GetData() + tempArray.GetSize());
   m_pathList.RemoveAll();
   for (int j=0; j < tempArray.GetSize(); j++)
		m_pathList.AddTail(tempArray.GetAt(j));

   //CString str;
   //str.Format("Paths: %d",m_pathList.GetCount());
   //AfxMessageBox(str);

   ReleaseMutex(m_mutex);
}

// This procedure is called when the user selects a path from the filtered path list.
// The Host Ground Hazard Path variable is set accordingly.
void CHazardPathDataManager::ProcessFilteredPathSelection(std::string path)
{
   DWORD retcode  =  WaitForSingleObject(m_mutex, INFINITE);

   for (POSITION pos = m_pathList.GetHeadPosition(); pos != NULL;)
   {
	  PathInfo   info = m_pathList.GetNext(pos);
	  CString cstr(path.c_str());
      if (stricmp(info.name, cstr) == 0)
      {
		 {
            CVariant var;
            CCommsShared::GetHostValue(var, _FSI_STL::string("Ground Hazard Path"));
            long  old_type =  var.Type();
            var.Value(info.value);
            var.ChangeType(old_type);
            CCommsShared::SetHostValue(var, _FSI_STL::string("Ground Hazard Path"), 0);
		 }
		 break;
      }
   }
   
   ReleaseMutex(m_mutex);
}

// This procedure creates a filtered list of paths based on the airport selected by the user.
void CHazardPathDataManager::CreateFilteredPathList(std::string airport)
{
   DWORD retcode  =  WaitForSingleObject(m_mutex, INFINITE);

   m_filtered_list_of_paths.clear();
   int nPathIndex(0);

   if (airport == "NONE")
   {
      for (POSITION pos = m_pathList.GetHeadPosition(); pos != NULL;)
	  {
	     PathInfo   info = m_pathList.GetNext(pos);
         
		 // If this is the first path, set Host value since we want the first path selected
		 // by default.
		 if (nPathIndex == 0)
		 {
			{
               CVariant var;
               CCommsShared::GetHostValue(var, _FSI_STL::string("Ground Hazard Path"));
               long  old_type =  var.Type();
               var.Value(info.value);
               var.ChangeType(old_type);
               CCommsShared::SetHostValue(var, _FSI_STL::string("Ground Hazard Path"), 0);
			}
		 }
		 std::string strName(info.name);
		 _FSI_STL::list<_FSI_STL::string> listAll;
         listAll.push_back(strName);
         m_filtered_list_of_paths[nPathIndex++] =  listAll;
	  }
   }
   else if (airport == "NO PATHS")
   {
	   {
          CVariant var1;
          CCommsShared::GetHostValue(var1, _FSI_STL::string("Ground Hazard Path"));
          long  old_type =  var1.Type();
          var1.Value(0L);
          var1.ChangeType(old_type);
          CCommsShared::SetHostValue(var1, _FSI_STL::string("Ground Hazard Path"), 0);
	   }
	   std::string strNoPath = "NONE AVAILABLE";
	   _FSI_STL::list<_FSI_STL::string> listNone;
       listNone.push_back(strNoPath);
       m_filtered_list_of_paths[nPathIndex++] =  listNone;
   }
   else
   {
      // Run the entire list of PathInfo elements looking for paths for this airport.
      for (POSITION p = m_pathList.GetHeadPosition(); p != NULL;)
	  {
	     PathInfo   i = m_pathList.GetNext(p);
	     CString cstr(airport.c_str());

	     // If this path is for this airport, add it to the filtered list to be displayed
	     // in the combobox.
         if (stricmp(i.airport, cstr) == 0)
		 {
		     // If this is the first path, set Host value since we want the first path selected
		     // by default.
		    if (nPathIndex == 0)
			{
			   {
                  CVariant var2;
                  CCommsShared::GetHostValue(var2, _FSI_STL::string("Ground Hazard Path"));
                  long  old_type =  var2.Type();
                  var2.Value(i.value);
                  var2.ChangeType(old_type);
                  CCommsShared::SetHostValue(var2, _FSI_STL::string("Ground Hazard Path"), 0);
			   }
			}
		    std::string strPathName(i.name);
		    _FSI_STL::list<_FSI_STL::string> list;
            list.push_back(strPathName);
            m_filtered_list_of_paths[nPathIndex++] =  list;
		 }
	  }
   }
   

   // Select the first path in the combobox
   {
      CVariant var3;
      CCommsShared::GetLocalValue(var3, _FSI_STL::string("hazard_path_list"));
      long  old_type =  var3.Type();
      var3.Value(0L);
      var3.ChangeType(old_type);
      CCommsShared::SetLocalValue(var3, _FSI_STL::string("hazard_path_list"), 0);
   }
   m_filtered_path_list_changed =  true;
   
   ReleaseMutex(m_mutex);
}

// This procedure adds an entry to the airport list for all airports having
// one or more hazard paths.
void CHazardPathDataManager::CreateAirportList(void)
{
   DWORD retcode  =  WaitForSingleObject(m_mutex, INFINITE);

   m_list_of_airports.clear();
   m_sorted_list_of_airports.clear();

   // Use a simple list of strings for fast sorting and searching.
   CString sortAirport = "";
   for (POSITION ptn = m_pathList.GetHeadPosition(); ptn != NULL;)
   {
	  PathInfo   info = m_pathList.GetNext(ptn);
      if (stricmp(info.airport, sortAirport) != 0)
      {
		  std::string strAirportName(info.airport);
          m_sorted_list_of_airports.push_back(strAirportName);
		  sortAirport = info.airport;
      }
   }
   m_sorted_list_of_airports.sort();
   std::string strActive("CURRENT ACTIVE");
   m_sorted_list_of_airports.push_front(strActive);
   std::string strNone("NONE");
   m_sorted_list_of_airports.push_front(strNone);
   std::list<std::string>::iterator it;

   // Use the simple sorted list to build the airport list.
   int nAirportIndex(0);
   for (it = m_sorted_list_of_airports.begin(); it != m_sorted_list_of_airports.end(); ++it)
   {
	   _FSI_STL::list<_FSI_STL::string> list;
       list.push_back(*it);
       m_list_of_airports[nAirportIndex++] =  list;
   }
   m_airport_list_changed =  true;

   ReleaseMutex(m_mutex);
}

// This procedure sets the default selection in the airport list and creates the
// associated filtered list of paths.
void CHazardPathDataManager::Initialize(void)
{
   DWORD retcode  =  WaitForSingleObject(m_mutex, INFINITE);

   {
      CVariant var;
      CCommsShared::GetLocalValue(var, _FSI_STL::string("hazard_airport_list"));
      long  old_type =  var.Type();
      var.Value(0L);
      var.ChangeType(old_type);
      CCommsShared::SetLocalValue(var, _FSI_STL::string("hazard_airport_list"), 0);
   }
   CreateFilteredPathList("NONE");

   ReleaseMutex(m_mutex);
}