#if !defined(AFX_GEOCHARTDATAMANAGER_H)
#define AFX_GEOCHARTDATAMANAGER_H

#include "..\core\stdafx.h"
#include "..\core\stltypes.h"
#include "IChartInfoV2.h"

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

using namespace ChartInfoV2;

class CGeoChartDataManager
{
public:
   CGeoChartDataManager():
      m_pChartInfo(NULL)
      ,m_number_of_areas(0)
      ,m_ac_lat(0.0)
      ,m_ac_lon(0.0)
      ,m_chart_list_changed(false)
      ,m_ident_list_changed(false)
      ,m_selected_area(0)
      ,m_bInitialUpdate(true)
   {
      m_list_of_areas.clear();
      m_list_of_idents.clear();
      m_list_of_charts.clear();
      m_mutex  =  CreateMutex(NULL, FALSE, NULL);
   };

   virtual ~CGeoChartDataManager()
   {
   };

   IChartInfoV2*  m_pChartInfo;

   _FSI_STL::map<long, _FSI_STL::list<_FSI_STL::string> >   m_list_of_areas;
   _FSI_STL::map<long, _FSI_STL::list<_FSI_STL::string> >   m_list_of_idents;
   _FSI_STL::map<long, _FSI_STL::list<_FSI_STL::string> >   m_list_of_charts;

   typedef  struct   local_charts
   {
      int   area;
      int   chart;
   };

   _FSI_STL::vector<bool> m_area_filtered;
   _FSI_STL::vector<local_charts> m_local_charts;

   bool     m_chart_list_changed;
   bool     m_ident_list_changed;
   int      m_selected_area;

   int      m_number_of_areas;
   double   m_ac_lat;
   double   m_ac_lon;

   std::string m_chart_names;

   HANDLE   m_mutex;
   bool     m_bInitialUpdate;

   void  ResetChartList(void);
   void  CreateChartList(std::string filter);
   void  CreateIdentList(void);
   void  CreateLocalChartList(void);
   void  CreateSortieChartList(void);

   bool GetLatLonFromPixel(int nAreaIndex, int nChartIndex, double& dPixelX, double& dPixelY)
   {
      DWORD retcode  =  WaitForSingleObject(m_mutex, INFINITE);
      bool  retval(false);
      try 
      {
         retval   =  m_pChartInfo->GetLatLonFromPixel(nAreaIndex,nChartIndex,dPixelX,dPixelY);
      }
      catch (...)
      {
         OutputDebugString("Unexpected exception in GetLatLonFromPixel\n");
      }

      ReleaseMutex(m_mutex);
      return   retval;
   };

   bool GetPixelFromLatLon(int nAreaIndex, int nChartIndex, double& dLatitude, double& dLongitude)
   {
      DWORD retcode  =  WaitForSingleObject(m_mutex, INFINITE);
      bool  retval(false);
      try 
      {
         retval   =  m_pChartInfo->GetPixelFromLatLon(nAreaIndex, nChartIndex, dLatitude, dLongitude);
      }
      catch (...)
      {
         OutputDebugString("Unexpected exception in GetPixelFromLatLon\n");
      }
      ReleaseMutex(m_mutex);
      return   retval;
   }

   bool GetNumberOfCharts(int in_AreaIndex, int &out_ChartCount)
   {
      DWORD retcode  =  WaitForSingleObject(m_mutex, INFINITE);
      bool  retval(false);
      try 
      {
         retval   =  m_pChartInfo->GetNumberOfCharts(in_AreaIndex, out_ChartCount);
      }
      catch (...)
      {
         OutputDebugString("Unexpected exception in GetNumberOfCharts\n");
      }
      ReleaseMutex(m_mutex);
      return   retval;
   }

   const char* GetChartFile(int nAreaIndex,int nChartIndex, bool bFullPath = false)
   {
      DWORD retcode  =  WaitForSingleObject(m_mutex, INFINITE);
      const char *filename;
      try 
      {
         filename =  m_pChartInfo->GetChartFile(nAreaIndex, nChartIndex, bFullPath);
      }
      catch (...)
      {
         OutputDebugString("Unexpected exception in GetChartFile\n");
      }
      ReleaseMutex(m_mutex);
      return   filename;
   }

   bool GetMapRotationAngle(int in_AreaIndex, int in_ChartIndex, double &out_degrees)
   {
      DWORD retcode  =  WaitForSingleObject(m_mutex, INFINITE);
      bool  retval(false);
      try 
      {
         retval   =  m_pChartInfo->GetMapRotationAngle(in_AreaIndex, in_ChartIndex, out_degrees);
      }
      catch (...)
      {
         OutputDebugString("Unexpected exception in GetMapRotationAngle\n");
      }
      ReleaseMutex(m_mutex);
      return   retval;
   }

   bool SetChartPath(const char* pPath)
   {
      DWORD retcode  =  WaitForSingleObject(m_mutex, INFINITE);
      bool  retval(false);
      try 
      {
         retval   =  m_pChartInfo->SetChartPath(pPath);
      }
      catch (...)
      {
         OutputDebugString("Unexpected exception in SetChartPath\n");
      }
      ReleaseMutex(m_mutex);
      return   retval;
   }

   bool Read(const char* filename)
   {
      DWORD retcode  =  WaitForSingleObject(m_mutex, INFINITE);
      bool  retval(false);
      try 
      {
         retval   =  m_pChartInfo->Read(filename);
      }
      catch (...)
      {
         OutputDebugString("Unexpected exception in Read\n");
      }
      ReleaseMutex(m_mutex);
      return   retval;
   }

   bool GetNumberOfAreas(int &out_AreaCount)
   {
      DWORD retcode  =  WaitForSingleObject(m_mutex, INFINITE);
      bool  retval(false);
      try 
      {
         retval   =  m_pChartInfo->GetNumberOfAreas(out_AreaCount);
      }
      catch (...)
      {
         OutputDebugString("Unexpected exception in GetNumberOfAreas\n");
      }
      ReleaseMutex(m_mutex);
      return   retval;
   }

   const char* GetAreaName(int nAreaIndex)
   {
      DWORD retcode  =  WaitForSingleObject(m_mutex, INFINITE);
      const char *areaName;
      try 
      {
         areaName =  m_pChartInfo->GetAreaName(nAreaIndex);
      }
      catch (...)
      {
         OutputDebugString("Unexpected exception in GetAreaName\n");
      }
      ReleaseMutex(m_mutex);
      return   areaName;
   }

   bool GetGeoReferenceType(int in_AreaIndex, int in_ChartIndex, GeoReferenceType_T &out_GeoReferenceType)
   {
      DWORD retcode  =  WaitForSingleObject(m_mutex, INFINITE);
      bool  retval(false);
      try 
      {
         retval   =  m_pChartInfo->GetGeoReferenceType(in_AreaIndex, in_ChartIndex, out_GeoReferenceType);
      }
      catch (...)
      {
         OutputDebugString("Unexpected exception in GetGeoReferenceType\n");
      }
      ReleaseMutex(m_mutex);
      return   retval;
   }
private:
   bool  IdentAlreadyFound(std::string &ident);
};

#endif // !defined(AFX_GEOCHARTDATAMANAGER_H)
