#include "..\core\stdafx.h"
#include "GeoChartDataManager.h"


void  CGeoChartDataManager::ResetChartList(void)
{
   m_list_of_charts.clear();
   int nChartIndex(0);
   _FSI_STL::list<_FSI_STL::string> list;
   list.push_back("<-- Pick Airfield First...");
   m_list_of_charts[nChartIndex++]  =  list;
   m_chart_list_changed =  true;
}


void CGeoChartDataManager::CreateChartList(std::string filter)
{
   DWORD retcode  =  WaitForSingleObject(m_mutex, INFINITE);

   m_list_of_charts.clear();

   // How many charts in this area?
   int   numberOfCharts(-1);
   m_pChartInfo->GetNumberOfCharts(m_selected_area-2, numberOfCharts);
   if (numberOfCharts > 0)
   {
      int nChartIndex(0);
      _FSI_STL::list<_FSI_STL::string> list;
      list.push_back("Pick Chart...");
      m_list_of_charts[nChartIndex++]  =  list;

      // Get the name of the next chart in the area.
      std::string strChartName(m_pChartInfo->GetChartName(m_selected_area-2, nChartIndex-1));
      while (strChartName.length())
      {
         // Get the ident (without the brackets)
         int   bracketStart   =  strChartName.find("[");
         int   bracketEnd     =  strChartName.find("]");
         int   length         =  (bracketEnd - bracketStart) - 1;
         std::string ident    =  strChartName.substr(bracketStart + 1, length);

         // if the chart name has a bracketed ident and we are trying to filter the list
         if (bracketStart > 0 && filter.length() > 0)
         {
            // strip the bracketed ident off of the chart name
            strChartName   =  strChartName.substr(0, bracketStart - 1);
            if (ident   == filter)
            {
               _FSI_STL::list<_FSI_STL::string> list;
               list.push_back(strChartName.c_str());
               m_list_of_charts[nChartIndex] =  list;
            }
         }
         else
         {
            _FSI_STL::list<_FSI_STL::string> list;
            list.push_back(strChartName.c_str());
            m_list_of_charts[nChartIndex] =  list;
         }
         nChartIndex++;
         strChartName   =  m_pChartInfo->GetChartName(m_selected_area-2, nChartIndex-1);
      }
   }
   else
   {
      _FSI_STL::list<_FSI_STL::string> list;
      list.push_back("None");
      m_list_of_charts[0]  =  list;
   }
   m_chart_list_changed =  true;
   ReleaseMutex(m_mutex);
}


void CGeoChartDataManager::CreateIdentList()
{
   DWORD retcode  =  WaitForSingleObject(m_mutex, INFINITE);

   m_list_of_idents.clear();

   // How many charts in this area?
   int   numberOfCharts(-1);
   m_pChartInfo->GetNumberOfCharts(m_selected_area-2, numberOfCharts);
   if (numberOfCharts > 0)
   {
      int nChartIndex(0);
      _FSI_STL::list<_FSI_STL::string> list;
      list.push_back("Pick...");
      m_list_of_idents[nChartIndex++]  =  list;

      // Get the name of the next chart in the area.
      std::string strChartName(m_pChartInfo->GetChartName(m_selected_area-2, nChartIndex-1));
      while (strChartName.length())
      {
         // Get the ident (without the brackets)
         int   bracketStart   =  strChartName.find("[");
         int   bracketEnd     =  strChartName.find("]");
         int   length         =  (bracketEnd - bracketStart) - 1;
         std::string ident    =  strChartName.substr(bracketStart + 1, length);

         // See if the ident is already found - don't add it again
         if (!IdentAlreadyFound(ident))         // if not found - add it to the combo box
         {
            _FSI_STL::list<_FSI_STL::string> list;
            list.push_back(ident.c_str());
            m_list_of_idents[nChartIndex] =  list;
         }
         nChartIndex++;
         strChartName   =  m_pChartInfo->GetChartName(m_selected_area-2, nChartIndex-1);
      }
   }
   else
   {
      _FSI_STL::list<_FSI_STL::string> list;
      list.push_back("None");
      m_list_of_idents[0]  =  list;
   }
   m_ident_list_changed =  true;
   ReleaseMutex(m_mutex);
}



bool  CGeoChartDataManager::IdentAlreadyFound(std::string &ident)
{
   // See if the ident is already in the list - don't add it again
   bool  found(false);
   _FSI_STL::map<long, _FSI_STL::list<_FSI_STL::string> >::iterator  MapIt;
   for (MapIt = m_list_of_idents.begin(); MapIt != m_list_of_idents.end(); MapIt++)
   {
      _FSI_STL::list<_FSI_STL::string> &list  =  MapIt->second;
      _FSI_STL::list<_FSI_STL::string>::iterator   ListIt;
      for (ListIt = list.begin(); ListIt != list.end(); ListIt++)
      {
         std::string test  =  *ListIt;    // finally down to the string we want to test
         if (test == ident)               // if it is already in the list
         {
            found =  true;                // mark as found
            break;                        // quit looping through the list
         }
      }
      if (found)                          // quit looping through the map
         break;
   }
   return   found;
}


void CGeoChartDataManager::CreateLocalChartList(void)
{
   DWORD retcode  =  WaitForSingleObject(m_mutex, INFINITE);

   m_list_of_charts.clear();
   m_local_charts.clear();

   int   chartCount(0);
   m_pChartInfo->GetNumberOfChartsAt(m_ac_lat, m_ac_lon, chartCount);

   int nChartIndex(0);
   _FSI_STL::list<_FSI_STL::string> list;
   list.push_back("Pick Chart...");
   m_list_of_charts[nChartIndex++]  =  list;

   for (int ii(0); ii < chartCount; ii++)
   {
      int   area(-1);
      int   chart(-1);
      if (m_pChartInfo->GetChartAt(m_ac_lat, m_ac_lon, ii, area, chart))
      {
         local_charts   info;
         info.area   =  area;
         info.chart  =  chart;
         m_local_charts.push_back(info);

         // Get the name of the next chart in the area.
         std::string strChartName(m_pChartInfo->GetChartName(area, chart));
         if (strChartName.length())
         {
            _FSI_STL::list<_FSI_STL::string> list;
            list.push_back(strChartName.c_str());
            m_list_of_charts[nChartIndex] =  list;
            nChartIndex++;
         }
      }
   }
   m_chart_list_changed =  true;
   m_ident_list_changed =  true;
   ReleaseMutex(m_mutex);
}


void  CGeoChartDataManager::CreateSortieChartList(void)
{
   DWORD retcode  =  WaitForSingleObject(m_mutex, INFINITE);

   m_list_of_charts.clear();
   m_local_charts.clear();

   int nChartIndex(0);
   _FSI_STL::list<_FSI_STL::string> list;
   list.push_back("Pick Chart...");
   m_list_of_charts[nChartIndex++]  =  list;

   char  delimeters[]   =  ",";
   char  *token;
   std::string chart_names(m_chart_names);                  // Make a copy of the original then tokenize the copy
   token =  strtok((char*)chart_names.c_str(), delimeters); // Get the first string.
   while (token)
   {
      CString  temp(token);                                 // Make it easier to trim...
      temp.TrimLeft(" ");                                   // Trim leading spaces
      temp.TrimRight(" ");                                  // Trim trailing spaces
      std::string name(temp);
      int   area(-1), chart(-1);
      if (m_pChartInfo->GetChartByName(name.c_str(), true, 0, area, chart))
      {
         local_charts   info;
         info.area   =  area;
         info.chart  =  chart;
         m_local_charts.push_back(info);

         _FSI_STL::list<_FSI_STL::string> list;
         list.push_back(name.c_str());
         m_list_of_charts[nChartIndex++] =  list;
      }
      token =  strtok(NULL, delimeters);                    // Get the next string.
   }

   m_chart_list_changed =  true;
   m_ident_list_changed =  true;
   ReleaseMutex(m_mutex);
}
