// GeoChart2.h: interface for the CGeoChart2 class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_GEOCHART2_H__81DA41F7_1A92_428F_A8E1_BD69D1AA1877__INCLUDED_)
#define AFX_GEOCHART2_H__81DA41F7_1A92_428F_A8E1_BD69D1AA1877__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "GeoChart.h"

class CGeoChart2 : public CGeoChart  
{
public:
	CGeoChart2();
	virtual ~CGeoChart2();

   static   CGeoChartDataManager*   GeoChartDataManager();
   static   void  GeoChartDataManager(const CGeoChartDataManager* pGeoChartDataManager);

   virtual  void  Initialize(CXMLWidget*& rpXMLWidget, CWnd* pWnd, const long int lId, bool bEditMode);
   static   CWidget* CreateObject();

   virtual  void  ChangeValue(const CString& rstrElementVar, CChangeValue* pCV);

   void SynchronizeZoom();
   void WriteZoomLevel();
   void ReadZoomLevel();
   void WriteScreenPositions();
   void ReadScreenPositions();
   void WriteAreaChartIndexes();
   bool ChartChanged();
   void WriteScreenOrigins();
   void UpdateChartCenterAtAircraftState(bool active);
   void UpdateChartCenterAtAircraftRequested(bool active);
   void UpdateChartCenterLatitude();
   void UpdateChartCenterLongitude();

protected:
   static   CGeoChartDataManager *m_pGeoChartDataManager;
};

#endif // !defined(AFX_GEOCHART2_H__81DA41F7_1A92_428F_A8E1_BD69D1AA1877__INCLUDED_)
