// GeoChart2.cpp: implementation of the CGeoChart2 class.
//
//////////////////////////////////////////////////////////////////////

#include "..\core\stdafx.h"
#include "ios.h"
#include "GeoChart2.h"
#include "..\comms\CommsShared.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

CGeoChartDataManager*        CGeoChart2::m_pGeoChartDataManager = NULL;

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CGeoChart2::CGeoChart2()
{
   m_stlStrWidgetName = _FSI_STL::string("GeoChart2");
}

CGeoChart2::~CGeoChart2()
{
}

CGeoChartDataManager* CGeoChart2::GeoChartDataManager()
{
   return m_pGeoChartDataManager;
}


void CGeoChart2::GeoChartDataManager(const CGeoChartDataManager* pGeoChartDataManager)
{
   m_pGeoChartDataManager =  const_cast<CGeoChartDataManager*>(pGeoChartDataManager);
}

void CGeoChart2::Initialize(CXMLWidget*& rpXMLWidget, CWnd* pWnd, const long lId, bool bEditMode)
{
   CGeoChart::m_pGeoChartDataManager  =  m_pGeoChartDataManager;
   CGeoChart::Initialize(rpXMLWidget,pWnd, lId, bEditMode);
}

CWidget* CGeoChart2::CreateObject()
{
   return new CGeoChart2();
}

/////////////////////////////////////////////////////////////////////////////
//
// void CGeoChart::ChangeValue()
//
// Inputs           : CString& rstrElementVar - the internal name of a 
//                                              variable that needs to be 
//                                              updated.
//                    CChangeValue* pCV       - pointer to data used to 
//                                              update an internal 
//                                              variable.
//
// Return Values    : None.
//
// Description      : CCB::ChangeValue() is a common framework 
//                    method that is used by the Comms thread to send 
//                    new data to the graphical elements.  Since it is 
//                    called from another thread, the special internal 
//                    variables are used to store the updates.  Before 
//                    the graphical element is redrawn, 
//                    UpdateRenderVariables is called to copy the 
//                    updated values to the values used for rendering.  
//                    This causes more memory to be used but prevents 
//                    the use of synchronization objects that may stall 
//                    the Comms thread.
//
/////////////////////////////////////////////////////////////////////////////
void CGeoChart2::ChangeValue(const CString& rstrElementVar, CChangeValue* pCV)
{

   if (pCV == NULL)
   {
      return;
   }
   CVariant* pVariant = pCV->Variant();

   if (rstrElementVar   == "Sortie Load Count")
   {
      CString  tmp(m_pGeoChartDataManager->m_chart_names.c_str());
      if (tmp  !=  m_ChartMapName)     // Only trigger a change if the chart_names have changed.
      {

		  m_pGeoChartDataManager->m_chart_names =  m_ChartMapName;
		 
         {
            CVariant var;
            CCommsShared::GetLocalValue(var, _FSI_STL::string("geochart_area_1"));
            long  old_type =  var.Type();
            var.Value(0L);                 // set the new value 
            var.ChangeType(old_type);
            CCommsShared::SetLocalValue(var, _FSI_STL::string("geochart_area_1"), 0);
         }
      }
   }
   else
   {
      CGeoChart::ChangeValue(rstrElementVar, pCV);
   }

}

// The following methods implement abstractions from the parent class

// Method:      SynchronizeZoom
// Use this to synchronize mouse wheel and/or slider zoom level values
// Returns:     
void CGeoChart2::SynchronizeZoom()
{
   float fPercentage((m_fZoomOutLimit - m_fZoomFactor) / m_fZoomSliderStep);
   if (fPercentage > 100.0f)
      fPercentage = 100.0f;
   else if (fPercentage < 1.0f)
	  fPercentage = 1.0f;
   {
      CVariant var;
      CCommsShared::GetLocalValue(var, _FSI_STL::string("chart_scale_1"));
      float old_type =  var.Type();
      var.Value(fPercentage);
      var.ChangeType(old_type);
      CCommsShared::SetLocalValue(var, _FSI_STL::string("chart_scale_1"), 0);
   }   
}

void CGeoChart2::WriteZoomLevel()
{
   {
      CVariant var;
      CCommsShared::GetLocalValue(var, _FSI_STL::string("geochart_zoom_level_1"));
      float old_type =  var.Type();
      var.Value(m_fZoomFactor);
      var.ChangeType(old_type);
      CCommsShared::SetLocalValue(var, _FSI_STL::string("geochart_zoom_level_1"), 0);
   }
}

void CGeoChart2::ReadZoomLevel()
{
	{
		CVariant *pVariant = CCommsShared::FindLocalVariant("geochart_zoom_level_1");
        ASSERT(pVariant != NULL);
        if (pVariant != NULL)
           m_fZoomFactor = (float)(*pVariant);
	}
}

void CGeoChart2::WriteScreenOrigins()
{
	{
       CVariant var;
       CCommsShared::GetLocalValue(var, _FSI_STL::string("geochart_screen_origin_x_1"));
       float old_type =  var.Type();
       var.Value(m_ScreenOrigin.x);
       var.ChangeType(old_type);
       CCommsShared::SetLocalValue(var, _FSI_STL::string("geochart_screen_origin_x_1"), 0);
    }
    {
       CVariant var;
       CCommsShared::GetLocalValue(var, _FSI_STL::string("geochart_screen_origin_y_1"));
       float old_type =  var.Type();
       var.Value(m_ScreenOrigin.y);
       var.ChangeType(old_type);
       CCommsShared::SetLocalValue(var, _FSI_STL::string("geochart_screen_origin_y_1"), 0);
    }
}

void CGeoChart2::WriteScreenPositions()
{
   {
      CVariant var;
      CCommsShared::GetLocalValue(var, _FSI_STL::string("geochart_map_origin_x_1"));
      float old_type =  var.Type();
      var.Value(m_MapOrigin.x);
      var.ChangeType(old_type);
      CCommsShared::SetLocalValue(var, _FSI_STL::string("geochart_map_origin_x_1"), 0);
   }
   {
      CVariant var;
      CCommsShared::GetLocalValue(var, _FSI_STL::string("geochart_map_origin_y_1"));
      float old_type =  var.Type();
      var.Value(m_MapOrigin.y);
      var.ChangeType(old_type);
      CCommsShared::SetLocalValue(var, _FSI_STL::string("geochart_map_origin_y_1"), 0);
   }
   {
      CVariant var;
      CCommsShared::GetLocalValue(var, _FSI_STL::string("geochart_screen_origin_x_1"));
      float old_type =  var.Type();
      var.Value(m_ScreenOrigin.x);
      var.ChangeType(old_type);
      CCommsShared::SetLocalValue(var, _FSI_STL::string("geochart_screen_origin_x_1"), 0);
	}
    {
      CVariant var;
      CCommsShared::GetLocalValue(var, _FSI_STL::string("geochart_screen_origin_y_1"));
      float old_type =  var.Type();
      var.Value(m_ScreenOrigin.y);
      var.ChangeType(old_type);
      CCommsShared::SetLocalValue(var, _FSI_STL::string("geochart_screen_origin_y_1"), 0);
	}
}

void CGeoChart2::ReadScreenPositions()
{
    {
       CVariant *pVariant = CCommsShared::FindLocalVariant("geochart_map_origin_x_1");
       ASSERT(pVariant != NULL);
       if (pVariant != NULL)
          m_MapOrigin.x = (float)(*pVariant);
	}
	{
       CVariant *pVariant = CCommsShared::FindLocalVariant("geochart_map_origin_y_1");
       ASSERT(pVariant != NULL);
       if (pVariant != NULL)
          m_MapOrigin.y = (float)(*pVariant);
	}
	{
       CVariant *pVariant = CCommsShared::FindLocalVariant("geochart_screen_origin_x_1");
       ASSERT(pVariant != NULL);
       if (pVariant != NULL)
          m_ScreenOrigin.x = (float)(*pVariant);
	}
	{
       CVariant *pVariant = CCommsShared::FindLocalVariant("geochart_screen_origin_y_1");
       ASSERT(pVariant != NULL);
       if (pVariant != NULL)
          m_ScreenOrigin.y = (float)(*pVariant);
	}
}

void CGeoChart2::WriteAreaChartIndexes()
{
   {
      CVariant var;
      CCommsShared::GetLocalValue(var, _FSI_STL::string("geochart_last_area_1"));
      long old_type =  var.Type();
      var.Value((long)m_nAreaIndex);
      var.ChangeType(old_type);
      CCommsShared::SetLocalValue(var, _FSI_STL::string("geochart_last_area_1"), 0);
	}
    {
      CVariant var;
      CCommsShared::GetLocalValue(var, _FSI_STL::string("geochart_last_chart_1"));
      long old_type =  var.Type();
      var.Value((long)m_nChartIndex);
      var.ChangeType(old_type);
      CCommsShared::SetLocalValue(var, _FSI_STL::string("geochart_last_chart_1"), 0);
	}
}

bool CGeoChart2::ChartChanged()
{
   int lastArea(0);
   int lastChart(0);
   long areaTemp(0);
   long chartTemp(0);

   // Find out if we just changed charts
   {
      CVariant *pVariant = CCommsShared::FindLocalVariant("geochart_last_area_1");
      ASSERT(pVariant != NULL);
      if (pVariant != NULL)
         areaTemp = (long)(*pVariant);
   }
   lastArea = areaTemp;
   {
      CVariant *pVariant = CCommsShared::FindLocalVariant("geochart_last_chart_1");
      ASSERT(pVariant != NULL);
      if (pVariant != NULL)
         chartTemp = (long)(*pVariant);
   }
   lastChart = chartTemp;
   return (m_nAreaIndex   != lastArea || m_nChartIndex != lastChart);
}

void CGeoChart2::UpdateChartCenterAtAircraftState(bool active)
{
   {
	  long go;
	  if (active)
		  go = 1;
	  else
		  go = 0;
      CVariant var;
      CCommsShared::GetLocalValue(var, _FSI_STL::string("geochart_center_aircraft_state_1"));
      long old_type =  var.Type();
      var.Value(go);
      var.ChangeType(old_type);
      CCommsShared::SetLocalValue(var, _FSI_STL::string("geochart_center_aircraft_state_1"), 0);
	}
}

void CGeoChart2::UpdateChartCenterAtAircraftRequested(bool active)
{
   {
	  long go;
	  if (active)
		  go = 1;
	  else
		  go = 0;
      CVariant var;
      CCommsShared::GetLocalValue(var, _FSI_STL::string("geochart_center_aircraft_1"));
      long old_type =  var.Type();
      var.Value(go);
      var.ChangeType(old_type);
      CCommsShared::SetLocalValue(var, _FSI_STL::string("geochart_center_aircraft_1"), 0);
	}
}

void CGeoChart2::UpdateChartCenterLatitude()
{
	{
      CVariant var;
      CCommsShared::GetLocalValue(var, _FSI_STL::string("geochart_latitude_center_1"));
      float old_type =  var.Type();
      var.Value(float(m_varChartCenterLat_cv));
      var.ChangeType(old_type);
      CCommsShared::SetLocalValue(var, _FSI_STL::string("geochart_latitude_center_1"), 0);
	}
}

void CGeoChart2::UpdateChartCenterLongitude()
{
	{
      CVariant var;
      CCommsShared::GetLocalValue(var, _FSI_STL::string("geochart_longitude_center_1"));
      float old_type =  var.Type();
      var.Value(float(m_varChartCenterLon_cv));
      var.ChangeType(old_type);
      CCommsShared::SetLocalValue(var, _FSI_STL::string("geochart_longitude_center_1"), 0);
	}
}