#if !defined(AFX_GEOCHART_H)
#define AFX_GEOCHART_H

#include "..\general\ButtonWidget.h"
#include "resource.h"

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
// GeoChart.h : header file
//

#include "IChartInfoV2.h"
#include "ImageTypeManager.h"
#include "Track_Point.h"
#include "AcBitmap.h"
#include "GeoChartDataManager.h"
#include "AircraftTrackRaw.h"
#include "MyRect.h"

class CDib;

using namespace ChartInfoV2;


/////////////////////////////////////////////////////////////////////////////
// CGeoChart window

class CGeoChart : public CButtonWidget, public ITrackCallback
{
private:
    CDib*       m_pDib;
    CString     m_strImage;
    CString     m_strComponent;
    CString     m_strSubComponent;

// Construction
public:
   CGeoChart();

// Attributes
public:
      enum { IDB = IDB_GEOCHART };

protected:

    virtual void InitReinit();

// Operations
public:
   virtual  void  Initialize(CXMLWidget*& rpXMLWidget, CWnd* pWnd, 
                           const long int lId, bool bEditMode);
   virtual  void  ResetProperties();

   virtual  void  ChangeValue(const CString& rstrElementVar, CChangeValue* pCV);
   virtual  CVariant* GetValue(const CString &rstrValue);
   virtual  bool UpdateRenderVariables();

   // Since we can have two instances of this class instantiated on
   // the left and right screens, force the child classes to manage
   // their separate local variables. The following abstract definitions
   // defer implemention to child classes 1 and 2.
   virtual  void SynchronizeZoom() = 0;
   virtual  void WriteZoomLevel() = 0;
   virtual  void ReadZoomLevel() = 0;
   virtual  void WriteScreenPositions() = 0;
   virtual  void ReadScreenPositions() = 0;
   virtual  void WriteAreaChartIndexes() = 0;
   virtual  bool ChartChanged() = 0;
   virtual  void WriteScreenOrigins() = 0;
   virtual  void UpdateChartCenterAtAircraftState(bool active) = 0;
   virtual  void UpdateChartCenterAtAircraftRequested(bool active) = 0;
   virtual  void UpdateChartCenterLatitude() = 0;
   virtual  void UpdateChartCenterLongitude() = 0;

// Overrides
   // ClassWizard generated virtual function overrides
   //{{AFX_VIRTUAL(CGeoChart)
   public:
   virtual void DrawItem(LPDRAWITEMSTRUCT lpDrawItemStruct);
   //}}AFX_VIRTUAL

// Implementation
public:
   virtual ~CGeoChart();

   // Generated message map functions
protected:
   //{{AFX_MSG(CGeoChart)
   afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
   afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
   afx_msg BOOL OnMouseWheel(UINT nFlags, short zDelta, CPoint pt);
   afx_msg void OnMouseMove(UINT nFlags, CPoint point);
   //}}AFX_MSG
   afx_msg LRESULT OnMouseLeave(WPARAM,LPARAM);
   afx_msg LRESULT OnMouseHover(WPARAM,LPARAM);
   afx_msg LRESULT OnKillFocus(WPARAM,LPARAM);

   DECLARE_MESSAGE_MAP()

   CGeoChartDataManager *m_pGeoChartDataManager;

   HMODULE     m_hChartInfoDll;
   bool        m_bChartInfoIsLoaded;
   bool        m_bChartLoaded;

   CVariant    m_varWingShipLatitude_cv;
   CVariant    m_varWingShipLongitude_cv;
   CVariant    m_varWingShipHeading_cv;
   CVariant    m_varLeadShipLatitude_cv;
   CVariant    m_varLeadShipLongitude_cv;
   CVariant    m_varLeadShipHeading_cv;
   CVariant    m_varChartArea;
   CVariant    m_varChartArea_cv;
   CVariant    m_varChartList;
   CVariant    m_varChartList_cv;
   CVariant    m_varChartCenterAtAircraftRequest_cv;
   CVariant    m_varChartCenterAtAircraftState_cv;
   CVariant    m_varChartCenterAtLatLonRequest_cv;
   CVariant    m_varChartCenterLat_cv;
   CVariant    m_varChartCenterLon_cv;
   CVariant    m_varChartZoomLevel_cv;
   CString     m_ChartMapName;
   CVariant    m_varChartChangeState_cv;
   CVariant    m_varChartScale_cv;

   CImageTypeManager m_ImageTypeManager;
   int               m_nAreaIndex;
   int               m_nChartIndex;

   //Draw coordinate variables
   CMyRect        m_rChart;

   //Panning variables.
   bool           m_bLeftMouseDown;
   bool           m_bMouseOverWindow;
   CPoint         m_ptMoveStart;
   CPoint         m_ptPanOffset;
   CPoint         m_CursorPoint;
   CPoint         m_ScreenOrigin;
   CPoint         m_MapOrigin;

   
   //Zoom variables
   float          m_fZoomFactor;
   float          m_fZoomInLimit;
   float          m_fZoomOutLimit;
   float          m_fZoomStep;
   float          m_fZoomSliderStep;
   float          m_DefaultDiameter;
   int            m_ChartFitToScreenAreaIndex;

   // Wing Ship variables
   double         m_dWingShipLatitude;
   double         m_dWingShipLongitude;
   float          m_fWingShipHeading;
   CPoint         m_ptWingShipCenter;
	CPoint         m_ptLastPassWingShipCenter;
   CAcBitmap      m_bmpWingShipInBounds;
   CAcBitmap      m_bmpWingShipOutOfBounds;

   // Lead Ship variables
   double         m_dLeadShipLatitude;
   double         m_dLeadShipLongitude;
   float          m_fLeadShipHeading;
   CPoint         m_ptLeadShipCenter;
	CPoint         m_ptLastPassLeadShipCenter;
   CAcBitmap      m_bmpLeadShipInBounds;
   CAcBitmap      m_bmpLeadShipOutOfBounds;

   double         m_map_rotation;
   bool           m_ChartChange;
   bool           m_MapToScale;
   bool           m_Initial;
   CRect          m_winRect;


   _FSI_STL::vector<_FSI_STL::string> m_vecAreas;

   bool  m_chart_center_at_aircraft_requested;
   bool  m_chart_center_at_aircraft_state;
   
   CAircraftTrackRaw m_aircraftLeadTrack;
   CAircraftTrackRaw m_aircraftWingTrack;
   bool              m_bClearLead;
   bool              m_bClearWing;
   bool              m_bShowLeadTrack;
   bool              m_bShowWingTrack;
   bool              m_bDeleting;

   typedef std::map<TolDataClients, std::vector<CPoint> >  MapTrackTypeToPointsInTrack;
   MapTrackTypeToPointsInTrack   m_mapTrackTypeToPointsInTrack;

   LARGE_INTEGER  t_last_pass;

   CDC*     m_pChartDC;
   CBitmap* m_pChartBitmap;


   void CalculateZoomPanRect();
   bool GetTrackPoint(const CTrackPoint ptWorld,CTrackPoint& ptScreen);
   bool GetTrackPointNoOffsets(const CTrackPoint ptWorld,CTrackPoint& ptScreen);
   bool LookupChart(void);
   void PrepTrack(CAircraftTrackRaw&, bool bChartChanged);
   void DrawTrack(HDC, CAircraftTrackRaw&);
   void PrepareChart(void);
   void ChangeScale();
   void UpdateChartSelectionControls();
};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_GEOCHART_H)
