// ComboWidgetEx.cpp: implementation of the CComboWidgetEx class.
//
//////////////////////////////////////////////////////////////////////

#include "..\core\stdafx.h"
#include "ios.h"
#include "ComboWidgetEx.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CComboWidgetEx::CComboWidgetEx()
{
   m_stlStrWidgetName   = _FSI_STL::string("ComboBoxEx");

   m_listWidgetPropPages.pop_back();  // CComboWidget pushes a CComboPage that we don't really need

   CComboWidgetEx::InitReinit();
}

CComboWidgetEx::~CComboWidgetEx()
{

}


void CComboWidgetEx::InitReinit()
{
   m_lOptions                  = DROPLIST;
   m_stlStrSelection           = _FSI_STL::string("");
   m_stlStrTextForSelection    = _FSI_STL::string("");
   m_bDataChanged              = false;
   m_mapEntries.clear();
}


CWidget* CComboWidgetEx::CreateObject()
{
    return new CComboWidgetEx();
}

BEGIN_MESSAGE_MAP(CComboWidgetEx, CComboWidget)
	//{{AFX_MSG_MAP(CComboWidgetEx)
	ON_CONTROL_REFLECT(CBN_CLOSEUP,   OnCloseup)
	ON_CONTROL_REFLECT(CBN_SELCHANGE, OnSelChange)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


void CComboWidgetEx::OnCloseup() 
{
   CComboWidget::OnCloseup();
}

void CComboWidgetEx::OnSelChange()
{
   if (m_bEditing == false)
   {
      // Get the highlighted text under the mouse.
      int n       = 0;
      long lValue = 0;
      n = GetCurSel();
      lValue = GetItemData(n);

      m_variant.Value(lValue);

      _FSI_STL::list<CAction*>::iterator lIt = m_listActions.begin();
      _FSI_STL::list<CAction*>::iterator lendIt = m_listActions.end();
      while (lIt != lendIt)
      {
         (*lIt)->OnLButtonUp();
         lIt++;
      }
   }
}