// AircraftTrackRaw.h: interface for the CAircraftTrackRaw class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_AIRCRAFTTRACKRAW_H__A227C9B9_B46B_4894_BD12_3FFA653CE972__INCLUDED_)
#define AFX_AIRCRAFTTRACKRAW_H__A227C9B9_B46B_4894_BD12_3FFA653CE972__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include <vector>
#include "..\radiodatabase\aircrafttrack.h"
#include "Track_Point.h"

class ITrackCallback
{
public:
	virtual  ~ITrackCallback(){};
	virtual  bool  GetTrackPointNoOffsets(const CTrackPoint ptWorld, CTrackPoint& ptScreen)=0;
};


typedef  struct
{
   double   lat;
   double   lon;
}  LatLon;

class __declspec(dllexport) CAircraftTrackRaw : public CAircraftTrack  
{
public:
	CAircraftTrackRaw();
	virtual ~CAircraftTrackRaw();

   void  Clear();
   void  UpdateData();
   void  AddVertice(struct TolData& td, unsigned long ulCurIndex);

   void  SetTrackCallback(ITrackCallback *pTrackCallback);
   ITrackCallback *m_pTrackCallback;

   std::vector<LatLon>  m_vecLatLon;

   void  Recalculate(void);
};

#endif // !defined(AFX_AIRCRAFTTRACKRAW_H__A227C9B9_B46B_4894_BD12_3FFA653CE972__INCLUDED_)
