// VerticalSpeedGauge.cpp: implementation of the CVerticalSpeedGauge class.
//
//////////////////////////////////////////////////////////////////////

#include "..\core\stdafx.h"
#include "..\core\dataconversion.h"
#include "VerticalSpeedGauge.h"
#include "winbase.h"


#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CVerticalSpeedGauge::CVerticalSpeedGauge()
{
   m_stlStrWidgetName   =  _FSI_STL::string("Vertical_Speed");
   m_exPtUpperLeft      =  CExtentsPoint(CPoint(0,0));
   m_exPtLowerRight     =  CExtentsPoint(CPoint(200,200));

   m_listGraphicalElementVars.clear();
   m_listGraphicalElementVars.push_back("Vertical Speed");
   m_listGraphicalElementVars.push_back("Power");

   m_float_vertical_speed     =  0.0f;
   m_float_vertical_speed_cv  =  m_float_vertical_speed;

   m_list             =  -1;
   m_bool_Power       = true;
   m_bool_Power_cv    = true;
}

CVerticalSpeedGauge::~CVerticalSpeedGauge()
{
}


void  CVerticalSpeedGauge::Setup(void)
{
   CPanel::Initialize(GetSafeHwnd());

   theTicks.Initialize();
   theTicks.SetLabelRadius(0.60f);
   theTicks.SetOuterRadius(0.84f);
   theTicks.SetLabelProperties(1.8f, 1.25f);
   theTicks.SetTickColor(255, 255, 255);

   TICK_INFO   tick_info;

   tick_info.location   =  5.5f;
   tick_info.type       =  INTERMEDIATE;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);

   tick_info.location   =  16.0f;
   tick_info.type       =  MAJOR;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);


   tick_info.location   =  26.5f;
   tick_info.type       =  INTERMEDIATE;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);

   tick_info.location   =  37.0f;
   tick_info.type       =  MAJOR;
   strcpy(tick_info.ident, "4");
   theTicks.TickList.AddTail(tick_info);


   tick_info.location   =  47.5f;
   tick_info.type       =  INTERMEDIATE;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);

   tick_info.location   =  58.0f;
   tick_info.type       =  MAJOR;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);


   tick_info.location   =  68.5f;
   tick_info.type       =  INTERMEDIATE;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);

   tick_info.location   =  79.0f;
   tick_info.type       =  MAJOR;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);

   tick_info.location   =  90.0f;
   tick_info.type       =  NO_TICK;
   strcpy(tick_info.ident, "6");
   theTicks.TickList.AddTail(tick_info);



   tick_info.location   =  101.0f;
   tick_info.type       =  MAJOR;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);


   tick_info.location   =  111.5f;
   tick_info.type       =  INTERMEDIATE;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);

   tick_info.location   =  122.0f;
   tick_info.type       =  MAJOR;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);


   tick_info.location   =  132.5f;
   tick_info.type       =  INTERMEDIATE;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);

   tick_info.location   =  143.0f;
   tick_info.type       =  MAJOR;
   strcpy(tick_info.ident, "4");
   theTicks.TickList.AddTail(tick_info);


   tick_info.location   =  153.5f;
   tick_info.type       =  INTERMEDIATE;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);

   tick_info.location   =  164.0f;
   tick_info.type       =  MAJOR;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);


   tick_info.location   =  174.5f;
   tick_info.type       =  INTERMEDIATE;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);

   tick_info.location   =  185.0f;
   tick_info.type       =  MAJOR;
   strcpy(tick_info.ident, "2");
   theTicks.TickList.AddTail(tick_info);


   tick_info.location   =  202.5f;
   tick_info.type       =  INTERMEDIATE;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);

   tick_info.location   =  220.0f;
   tick_info.type       =  MAJOR;
   strcpy(tick_info.ident, "1");
   theTicks.TickList.AddTail(tick_info);


   tick_info.location   =  225.0f;
   tick_info.type       =  MINOR;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);

   tick_info.location   =  230.0f;
   tick_info.type       =  MINOR;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);

   tick_info.location   =  235.0f;
   tick_info.type       =  MINOR;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);

   tick_info.location   =  240.0f;
   tick_info.type       =  MINOR;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);

   tick_info.location   =  245.0f;
   tick_info.type       =  MAJOR;
   strcpy(tick_info.ident, ".5");
   theTicks.TickList.AddTail(tick_info);

   
   tick_info.location   =  250.0f;
   tick_info.type       =  MINOR;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);

   tick_info.location   =  255.0f;
   tick_info.type       =  MINOR;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);

   tick_info.location   =  260.0f;
   tick_info.type       =  MINOR;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);

   tick_info.location   =  265.0f;
   tick_info.type       =  MINOR;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);

   tick_info.location   =  270.0f;
   tick_info.type       =  MAJOR;
   strcpy(tick_info.ident, "0");
   theTicks.TickList.AddTail(tick_info);


   tick_info.location   =  275.0f;
   tick_info.type       =  MINOR;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);

   tick_info.location   =  280.0f;
   tick_info.type       =  MINOR;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);

   tick_info.location   =  285.0f;
   tick_info.type       =  MINOR;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);

   tick_info.location   =  290.0f;
   tick_info.type       =  MINOR;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);

   tick_info.location   =  295.0f;
   tick_info.type       =  MAJOR;
   strcpy(tick_info.ident, ".5");
   theTicks.TickList.AddTail(tick_info);


   tick_info.location   =  300.0f;
   tick_info.type       =  MINOR;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);

   tick_info.location   =  305.0f;
   tick_info.type       =  MINOR;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);

   tick_info.location   =  310.0f;
   tick_info.type       =  MINOR;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);

   tick_info.location   =  315.0f;
   tick_info.type       =  MINOR;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);

   tick_info.location   =  320.0f;
   tick_info.type       =  MAJOR;
   strcpy(tick_info.ident, "1");
   theTicks.TickList.AddTail(tick_info);


   tick_info.location   =  337.5f;
   tick_info.type       =  INTERMEDIATE;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);

   tick_info.location   =  355.0f;
   tick_info.type       =  MAJOR;
   strcpy(tick_info.ident, "2");
   theTicks.TickList.AddTail(tick_info);

   theTicks.GenerateLists();


   m_verticalSpeedNeedle.Format("%c", ALTIMETER_NEEDLE);
   m_verticalSpeed_title.Format("VERTICAL\nSPEED");
   fpm_x1000   =  ("FPM X 1000");


   if (m_list != -1)
      glDeleteLists(m_list, 1);

   m_list = glGenLists(1);
   glNewList(m_list, GL_COMPILE);
   {
      glPushMatrix();
      {
         // Draw the standard stuff, (bezel, screw heads, and primary title).
         CPanel::Draw();

         glTranslatef(0.0f, 0.25f, 0.0f);
         verticalSpeed_title.Draw(m_verticalSpeed_title,   true, 0.0f, 2.0f, 1.0f);
         glTranslatef(0.0f, -0.25f, 0.0f);

         // Draw tick marks and labels.
         theTicks.Draw();
         theTicks.DrawArc(true, 79.0f, 101.0f);

         glTranslatef(0.0f, -0.30f, 0.0f);
         fpmX1000_title.Draw(fpm_x1000, true, 0.0f, 1.6f, 1.0f);
         glTranslatef(0.0f,  0.30f, 0.0f);
      }
      glPopMatrix();
   }
   glEndList();
}


void  CVerticalSpeedGauge::Render(void)
{
   BeginDraw();

   glPushMatrix();
   {
      glCallList(m_list);

      glPushMatrix();
         glRotatef(-m_float_verticalSpeed_angle, 0.0f, 0.0f, 1.0f);
         glTranslatef( 0.0f, 0.5f, 0.0f);
         verticalSpeedNeedle.Draw(m_verticalSpeedNeedle, true, 0.0f, 17.5f);
      glPopMatrix();
   }
   glPopMatrix();

   if (!m_bool_Power)
   {
      glColor4ub(255, 255, 255, 64);
      glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);
         glBegin(GL_QUADS);
            glVertex2f(-1.0f, 1.0f);
            glVertex2f( 1.0f, 1.0f);
            glVertex2f( 1.0f, -1.0f);
            glVertex2f(-1.0f, -1.0f);
         glEnd();
      glPolygonMode(GL_FRONT_AND_BACK, GL_LINE);
   }

   EndDraw();
}

CWidget* CVerticalSpeedGauge::CreateObject()
{
   return new CVerticalSpeedGauge();
}

void CVerticalSpeedGauge::ChangeValue(const CString& rstrElementVar, CChangeValue* pCV)
{
   if (pCV  == NULL)
   {
      return;
   }
   CVariant *pVariant   =  pCV->Variant();

   if (rstrElementVar   == "Vertical Speed")
   {
      m_float_vertical_speed_cv  =  *pVariant;
   }
   else if (rstrElementVar   == "Power")
   {
      m_bool_Power_cv         =  *pVariant;
   }
}

/////////////////////////////////////////////////////////////////////////////
//
// bool CVerticalSpeedGauge::UpdateRenderVariables()
//
// Inputs           : None.
//
// Return Values    : success value of the update of the rendering variables.
//
// Date             : 16 June 1999
//
// Engineer         : Billy Baker
//
// Description      : Override of the parent's UpdateRenderVariables.  
//                    If the class is being destroyed while in this method,
//                    then the return value should be false. This method is
//                    called by the COMMS layer before it tells the mainframe
//                    that a screen update is needed.
//
/////////////////////////////////////////////////////////////////////////////
bool CVerticalSpeedGauge::UpdateRenderVariables()
{
   // Determine the rate at which this function is getting called.
   LARGE_INTEGER  theFrequency;
   QueryPerformanceFrequency(&theFrequency);
   static   LARGE_INTEGER  theStartCount;
   static   bool  one_time_only  =  true;
   LARGE_INTEGER  theEndCount, diffCount;
   float    iteration_rate;

   if (one_time_only)
   {
      QueryPerformanceCounter(&theStartCount);
      one_time_only  =  false;
   }
   
   QueryPerformanceCounter(&theEndCount);
   diffCount.QuadPart   =  theEndCount.QuadPart -  theStartCount.QuadPart;
   iteration_rate       =  (float)((float)diffCount.QuadPart /  (float)theFrequency.QuadPart);
   QueryPerformanceCounter(&theStartCount);
   

   static   float lpv_output        =  0.0f;

   if (iteration_rate   >= 1.0f)    // If for some reason we haven't been called for more than a second, just snap to desired value.
   {
      m_float_vertical_speed  =  m_float_vertical_speed_cv;
      lpv_output              =  m_float_vertical_speed_cv;
   }
   else
   {
      float slew_limit_per_iteration   =  440.0f   *  iteration_rate;
      float fraction                   =  m_float_vertical_speed_cv  *  iteration_rate;
      float calculated_filter_output   =  lpv_output  *  (1.0f -  iteration_rate)   +  fraction;

      if (calculated_filter_output  -  lpv_output  >  slew_limit_per_iteration)  
         lpv_output  += slew_limit_per_iteration;
      else if (lpv_output  -  calculated_filter_output   >  slew_limit_per_iteration)  
         lpv_output  -= slew_limit_per_iteration;
      else
         lpv_output  =  calculated_filter_output;

      m_float_vertical_speed  =  lpv_output;
   }

   if (     m_float_vertical_speed  >= -1000.0f && m_float_vertical_speed  <= 1000.0f)
      m_float_verticalSpeed_angle   =  ((320.0f-270.0f)/1000.0f   *  (m_float_vertical_speed -  0.0f))      +  270.0f;

   else if (m_float_vertical_speed  >= -2000.0f && m_float_vertical_speed  <  -1000.0f)
      m_float_verticalSpeed_angle   =  ((220.0f-185.0f)/1000.0f   *  (m_float_vertical_speed +  1000.0f))   +  220.0f;
   else if (m_float_vertical_speed  >  1000.0f  && m_float_vertical_speed  <= 2000.0f)
      m_float_verticalSpeed_angle   =  ((355.0f-320.0f)/1000.0f   *  (m_float_vertical_speed -  1000.0f))   +  320.0f;

   else if (m_float_vertical_speed  >= -6000.0f && m_float_vertical_speed  <  -2000.0f)
      m_float_verticalSpeed_angle   =  ((185.0f-101.0f)/4000.0f   *  (m_float_vertical_speed +  2000.0f))   +  185.0f;
   else if (m_float_vertical_speed  >  2000.0f  && m_float_vertical_speed  <= 6000.0f)
      m_float_verticalSpeed_angle   =  (( 79.0f- -5.0f)/4000.0f   *  (m_float_vertical_speed -  2000.0f))   +  -5.0f;

   else if (m_float_vertical_speed  >  6000.0f)
      m_float_verticalSpeed_angle   =  79.0f;
   else if (m_float_vertical_speed  <  -6000.0f)
      m_float_verticalSpeed_angle   =  101.0f;

   else
      m_float_verticalSpeed_angle   =  270.0f;

   m_bool_Power   =  m_bool_Power_cv;

   return CWidget::UpdateRenderVariables();
}