// UHFBackupPanel.cpp: implementation of the CUHFBackupPanel class.
//
//////////////////////////////////////////////////////////////////////

#include "..\core\stdafx.h"
#include "UHFBackupPanel.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CUHFBackupPanel::CUHFBackupPanel()
{
   m_exPtUpperLeft      =  CExtentsPoint(CPoint(0,0));
   m_exPtLowerRight     =  CExtentsPoint(CPoint(128,64));
   m_stlStrWidgetName   =  _FSI_STL::string("UHF_Backup_Panel");
   
   m_CStr_UHFActiveFrequency     =  "399.97";
   m_CStr_UHFActiveFrequency_cv  =  m_CStr_UHFActiveFrequency;
   m_CStr_UHFActiveChannel       =  "CH20";
   m_CStr_UHFActiveChannel_cv    =  m_CStr_UHFActiveChannel;
   m_CStr_UHFMode                =  "B";
   m_CStr_UHFMode_cv             =  m_CStr_UHFMode;
   m_CStr_buhf                   =  "STBY UHF";
   m_bool_Uhf_Tx                 =  false;
   m_bool_Uhf_Tx_cv              =  false;
   m_CStr_transmit               =  "TX";

   m_listGraphicalElementVars.clear();
   m_listGraphicalElementVars.push_back("UHF Frequency (backup)");
   m_listGraphicalElementVars.push_back("UHF Channel (backup)");
   m_listGraphicalElementVars.push_back("UHF Mode (backup)");
   m_listGraphicalElementVars.push_back("Uhf_Tx");

   m_list   =  -1;
}

CUHFBackupPanel::~CUHFBackupPanel()
{
}

void  CUHFBackupPanel::Setup(void)
{
   CPanel::Initialize(GetSafeHwnd());

   UHFActiveFrequency.SetForegroundColor(255, 128, 0);   // Orange

   if (m_list != -1)
      glDeleteLists(m_list, 1);

   m_list = glGenLists(1);
   glNewList(m_list, GL_COMPILE);
   {
      glPushMatrix();
      {
         // Draw the standard stuff, (bezel, screw heads, and primary title).
         CPanel::Draw();

         glTranslatef(0.0f,   0.35f,  0.0f);
         UHFLegend.SetForegroundColor(255, 128, 0);   // Orange
         UHFLegend.Draw(m_CStr_buhf, true, 0.0f, 3.0f /  m_aspect_ratio, 0.0f);
      }
      glPopMatrix();
   }
   glEndList();
}

void  CUHFBackupPanel::Render(void)
{
   BeginDraw();


   glPushMatrix();
   {
/*
      glPushMatrix();
         glTranslatef(0.0f,  0.35f,  0.0f);
         Channel.SetForegroundColor(0,  192,  0);            // Green
         Channel.Draw(m_CStr_UHFActiveChannel, true, 0.0f, 3.5f /  m_aspect_ratio, 0.0f);
      glPopMatrix();
*/

      glCallList(m_list);

      if (m_long_UHF_frequency)
      {
         glPushMatrix();
            glTranslatef(0.0f,  -0.35f,  0.0f);
            if (m_bool_Uhf_Tx)
               m_CStr_UHFDisplay =  m_CStr_UHFMode +  " "   +  m_CStr_transmit   +  " "   +  m_CStr_UHFActiveFrequency;
            else
               m_CStr_UHFDisplay =  m_CStr_UHFMode   +  " "   +  m_CStr_UHFActiveFrequency;
            UHFActiveFrequency.Draw(m_CStr_UHFDisplay,  true, 0.0f, 3.0f /  m_aspect_ratio, 0.0f);
         glPopMatrix();
      }
   }
   glPopMatrix();

   EndDraw();
}

void  CUHFBackupPanel::SetUHFActiveFrequency(long UHF_frequency)
{
   float    frequency   =  (float)(UHF_frequency)/1000.0f;
   // The format %5.4lf would show four places after the decimal, but %5.2lf would
   // cause the value to be rounded before showing two places after the decimal.
   // The following code truncates the value to two places after the decimal without rounding.
   CString  value;
   value.Format("%5.4lf",  frequency);            
   m_CStr_UHFActiveFrequency_cv.Format("%.6s", value);
}

void  CUHFBackupPanel::SetUHFActiveChannel(long UHF_channel)
{
   m_CStr_UHFActiveChannel_cv.Format("CH%d", UHF_channel);
}

void  CUHFBackupPanel::SetUHFMode(long UHF_Mode)
{
   switch   (UHF_Mode)
   {
      case  0:
         m_CStr_UHFMode_cv =  "A";  // ADF
         break;

      case  1:
         m_CStr_UHFMode_cv =  "M";  // Main
         break;

      case  2:
         m_CStr_UHFMode_cv =  "G";  // Guard
         break;

      case  3:
         m_CStr_UHFMode_cv =  "B";  // Both
         break;
   }
}

CWidget* CUHFBackupPanel::CreateObject()
{
   return new CUHFBackupPanel();
}

void CUHFBackupPanel::ChangeValue(const CString& rstrElementVar, CChangeValue* pCV)
{
   if (pCV == NULL)
   {
       return;
   }
   CVariant* pVariant = pCV->Variant();

   if (rstrElementVar      == "UHF Frequency (backup)")
   {
      m_long_UHF_frequency_cv =  (long)*pVariant;
      SetUHFActiveFrequency(m_long_UHF_frequency_cv);
   }
   else if (rstrElementVar == "UHF Channel (backup)")
   {
      SetUHFActiveChannel((long)*pVariant);
   }
   else if (rstrElementVar == "UHF Mode (backup)")
   {
      SetUHFMode((long)*pVariant);
   }
   else if (rstrElementVar == "Uhf_Tx")
   {
      m_bool_Uhf_Tx_cv     =  (bool)*pVariant;
   }
}

/////////////////////////////////////////////////////////////////////////////
//
// bool CUHFBackupPanel::UpdateRenderVariables()
//
// Inputs           : None.
//
// Return Values    : success value of the update of the rendering variables.
//
// Date             : 16 June 1999
//
// Engineer         : Billy Baker
//
// Description      : Override of the parent's UpdateRenderVariables.  
//                    If the class is being destroyed while in this method,
//                    then the return value should be false. This method is
//                    called by the COMMS layer before it tells the mainframe
//                    that a screen update is needed.
//
/////////////////////////////////////////////////////////////////////////////
bool CUHFBackupPanel::UpdateRenderVariables()
{
   m_long_UHF_frequency       =  m_long_UHF_frequency_cv;
   m_CStr_UHFActiveFrequency  =  m_CStr_UHFActiveFrequency_cv;
   m_CStr_UHFActiveChannel    =  m_CStr_UHFActiveChannel_cv;
   m_CStr_UHFMode             =  m_CStr_UHFMode_cv;
   m_bool_Uhf_Tx              =  m_bool_Uhf_Tx_cv;

   return CWidget::UpdateRenderVariables();
}
