// TrimIndicatorGauge.h: interface for the CTrimIndicatorGauge class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_TRIMINDICATORGAUGE_H__77C03246_8A19_11D2_AD51_006008B0E0C3__INCLUDED_)
#define AFX_TRIMINDICATORGAUGE_H__77C03246_8A19_11D2_AD51_006008B0E0C3__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

#include "..\general\OpenGLWidget.h"
#include "Panel.h"

class CTrimIndicatorGauge : public COpenGLWidget, public CPanel
{
public:
	CTrimIndicatorGauge();
	virtual ~CTrimIndicatorGauge();
   static CWidget* CreateObject();

   void  Setup(void);
   void  Render(void);
   virtual bool UpdateRenderVariables();

   void  SetAileronTrim(float aileronTrim);
   void  SetRudderTrim(float rudderTrim);
   void  SetElevatorTrim(float elevatorTrim);

   virtual void ChangeValue(const CString& rstrElementVar, CChangeValue* pCV);

protected:
   CString     aileron_needle;
   CTicks      aileronTicks;
   CTicks      aileronGreenTicks;
   COpenGLtext aileronNeedle;
   float       m_aileron_angle;
   float       m_aileron_angle_cv;
   
   CString     rudder_needle;
   CTicks      rudderTicks;
   CTicks      rudderGreenTicks;
   COpenGLtext rudderNeedle;
   float       m_rudder_angle;
   float       m_rudder_angle_cv;

   CString     elevator_needle;
   CTicks      elevatorTicks;
   CTicks      elevatorGreenTicks;
   COpenGLtext elevatorNeedle;
   float       m_elevator_angle;
   float       m_elevator_angle_cv;

// Attributes
public:
  	enum { IDB = IDB_TRIM_INDICATOR  };
};

#endif // !defined(AFX_TRIMINDICATORGAUGE_H__77C03246_8A19_11D2_AD51_006008B0E0C3__INCLUDED_)
